/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.mixin;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.model.animation.AnimationHandler;
import noppes.npcs.client.renderer.RenderCustomNpc;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.roles.JobPuppet;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BipedModel.class})
public class BipedBodyMixin<T extends LivingEntity> {
    @Inject(at={@At(value="HEAD")}, method={"setupAnim"})
    private void setupAnimPre(T livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo callbackInfo) {
        BipedModel bipedModel = (BipedModel)this;
        if (livingEntity instanceof EntityCustomNpc && bipedModel instanceof PlayerModel) {
            EntityCustomNpc playerEntity = (EntityCustomNpc)((Object)livingEntity);
            ClientProxy.data = playerEntity.modelData;
            ClientProxy.playerModel = (PlayerModel)bipedModel;
            RenderCustomNpc renderer = (RenderCustomNpc)Minecraft.func_71410_x().func_175598_ae().func_78713_a(livingEntity);
            ClientProxy.armorLayer = renderer.armorLayer;
            AnimationHandler.animateBipedPre(ClientProxy.data, bipedModel, livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"setupAnim"})
    private void setupAnimPost(T livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo callbackInfo) {
        BipedModel bipedModel = (BipedModel)this;
        if (livingEntity instanceof EntityCustomNpc) {
            JobPuppet job;
            EntityCustomNpc npc = (EntityCustomNpc)((Object)livingEntity);
            AnimationHandler.animateBipedPost(ClientProxy.data, bipedModel, livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            if (npc.job.getType() == 9 && (job = (JobPuppet)npc.job).isActive()) {
                float pi = (float)Math.PI;
                float partialTicks = Minecraft.func_71410_x().func_193989_ak();
                if (!job.head.disabled) {
                    bipedModel.field_178720_f.field_78795_f = bipedModel.field_78116_c.field_78795_f = job.getRotationX(job.head, job.head2, partialTicks) * pi;
                    bipedModel.field_178720_f.field_78796_g = bipedModel.field_78116_c.field_78796_g = job.getRotationY(job.head, job.head2, partialTicks) * pi;
                    bipedModel.field_178720_f.field_78808_h = bipedModel.field_78116_c.field_78808_h = job.getRotationZ(job.head, job.head2, partialTicks) * pi;
                }
                if (!job.body.disabled) {
                    bipedModel.field_78115_e.field_78795_f = job.getRotationX(job.body, job.body2, partialTicks) * pi;
                    bipedModel.field_78115_e.field_78796_g = job.getRotationY(job.body, job.body2, partialTicks) * pi;
                    bipedModel.field_78115_e.field_78808_h = job.getRotationZ(job.body, job.body2, partialTicks) * pi;
                }
                if (!job.larm.disabled) {
                    bipedModel.field_178724_i.field_78795_f = job.getRotationX(job.larm, job.larm2, partialTicks) * pi;
                    bipedModel.field_178724_i.field_78796_g = job.getRotationY(job.larm, job.larm2, partialTicks) * pi;
                    bipedModel.field_178724_i.field_78808_h = job.getRotationZ(job.larm, job.larm2, partialTicks) * pi;
                    if (npc.display.getHasLivingAnimation()) {
                        bipedModel.field_178724_i.field_78808_h -= MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
                        bipedModel.field_178724_i.field_78795_f -= MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
                    }
                }
                if (!job.rarm.disabled) {
                    bipedModel.field_178723_h.field_78795_f = job.getRotationX(job.rarm, job.rarm2, partialTicks) * pi;
                    bipedModel.field_178723_h.field_78796_g = job.getRotationY(job.rarm, job.rarm2, partialTicks) * pi;
                    bipedModel.field_178723_h.field_78808_h = job.getRotationZ(job.rarm, job.rarm2, partialTicks) * pi;
                    if (npc.display.getHasLivingAnimation()) {
                        bipedModel.field_178723_h.field_78808_h += MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f;
                        bipedModel.field_178723_h.field_78795_f += MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f;
                    }
                }
                if (!job.rleg.disabled) {
                    bipedModel.field_178721_j.field_78795_f = job.getRotationX(job.rleg, job.rleg2, partialTicks) * pi;
                    bipedModel.field_178721_j.field_78796_g = job.getRotationY(job.rleg, job.rleg2, partialTicks) * pi;
                    bipedModel.field_178721_j.field_78808_h = job.getRotationZ(job.rleg, job.rleg2, partialTicks) * pi;
                }
                if (!job.lleg.disabled) {
                    bipedModel.field_178722_k.field_78795_f = job.getRotationX(job.lleg, job.lleg2, partialTicks) * pi;
                    bipedModel.field_178722_k.field_78796_g = job.getRotationY(job.lleg, job.lleg2, partialTicks) * pi;
                    bipedModel.field_178722_k.field_78808_h = job.getRotationZ(job.lleg, job.lleg2, partialTicks) * pi;
                }
            }
        }
    }
}

