/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import noppes.npcs.NBTTags;
import noppes.npcs.controllers.data.CloneSpawnData;

public class SpawnData
extends WeightedRandom.Item {
    public List<ResourceLocation> biomes = new ArrayList<ResourceLocation>();
    public int id = -1;
    public String name = "";
    public Map<Integer, CloneSpawnData> data = new HashMap<Integer, CloneSpawnData>();
    public boolean liquid = false;
    public int type = 0;
    private static Field f = null;

    public SpawnData() {
        super(10);
    }

    public void readNBT(CompoundNBT compound) {
        this.id = compound.func_74762_e("SpawnId");
        this.name = compound.func_74779_i("SpawnName");
        this.setWeight(compound.func_74762_e("SpawnWeight"));
        this.biomes = NBTTags.getResourceLocationList(compound.func_150295_c("SpawnBiomes", 10));
        this.data = CloneSpawnData.load(compound.func_150295_c("SpawnData", 10));
        this.type = compound.func_74762_e("SpawnType");
    }

    public CompoundNBT writeNBT(CompoundNBT compound) {
        compound.func_74768_a("SpawnId", this.id);
        compound.func_74778_a("SpawnName", this.name);
        compound.func_74768_a("SpawnWeight", this.field_76292_a);
        compound.func_218657_a("SpawnBiomes", (INBT)NBTTags.nbtResourceLocationList(this.biomes));
        compound.func_218657_a("SpawnData", (INBT)CloneSpawnData.save(this.data));
        compound.func_74768_a("SpawnType", this.type);
        return compound;
    }

    public void setWeight(int weight) {
        if (weight == 0) {
            weight = 1;
        }
        try {
            f.set((Object)this, weight);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void setClone(int slot, int tab, String name) {
        this.data.put(slot, new CloneSpawnData(tab, name));
    }

    public CompoundNBT getCompound(int slot) {
        CloneSpawnData sd = this.data.get(slot);
        if (sd == null) {
            return null;
        }
        return sd.getCompound();
    }

    static {
        f = WeightedRandom.Item.class.getDeclaredFields()[0];
        f.setAccessible(true);
    }
}

