/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.select;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.shared.client.gui.components.GuiBasic;
import noppes.npcs.shared.client.gui.components.GuiButtonNop;
import noppes.npcs.shared.client.gui.components.GuiCustomScroll;
import noppes.npcs.shared.client.gui.listeners.ICustomScrollListener;
import noppes.npcs.shared.client.gui.listeners.IGuiInterface;

public class GuiSoundSelection
extends GuiBasic
implements ICustomScrollListener {
    private GuiCustomScroll scrollCategories;
    private GuiCustomScroll scrollQuests;
    private String selectedDomain;
    public ResourceLocation selectedResource;
    private HashMap<String, List<String>> domains = new HashMap();

    public GuiSoundSelection(String sound) {
        this.drawDefaultBackground = false;
        this.field_230704_d_ = "";
        this.setBackground("menubg.png");
        this.imageWidth = 366;
        this.imageHeight = 226;
        SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
        Collection set = handler.func_195477_a();
        for (ResourceLocation location : set) {
            List<String> list = this.domains.get(location.func_110624_b());
            if (list == null) {
                list = new ArrayList<String>();
                this.domains.put(location.func_110624_b(), list);
            }
            list.add(location.func_110623_a());
            this.domains.put(location.func_110624_b(), list);
        }
        if (sound != null && !sound.isEmpty()) {
            this.selectedResource = new ResourceLocation(sound);
            this.selectedDomain = this.selectedResource.func_110624_b();
            if (!this.domains.containsKey(this.selectedDomain)) {
                this.selectedDomain = null;
            }
        }
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.addButton(new GuiButtonNop(this, 2, this.guiLeft + this.imageWidth - 26, this.guiTop + 4, 20, 20, "X"));
        this.addButton(new GuiButtonNop((IGuiInterface)this, 1, this.guiLeft + 160, this.guiTop + 212, 70, 20, "gui.play", this.selectedResource != null));
        if (this.scrollCategories == null) {
            this.scrollCategories = new GuiCustomScroll(this, 0);
            this.scrollCategories.func_231149_a_(90, 200);
        }
        this.scrollCategories.setList(Lists.newArrayList(this.domains.keySet()));
        if (this.selectedDomain != null) {
            this.scrollCategories.setSelected(this.selectedDomain);
        }
        this.scrollCategories.guiLeft = this.guiLeft + 4;
        this.scrollCategories.guiTop = this.guiTop + 14;
        this.addScroll(this.scrollCategories);
        if (this.scrollQuests == null) {
            this.scrollQuests = new GuiCustomScroll(this, 1);
            this.scrollQuests.func_231149_a_(250, 200);
        }
        if (this.selectedDomain != null) {
            this.scrollQuests.setList(this.domains.get(this.selectedDomain));
        }
        if (this.selectedResource != null) {
            this.scrollQuests.setSelected(this.selectedResource.func_110623_a());
        }
        this.scrollQuests.guiLeft = this.guiLeft + 95;
        this.scrollQuests.guiTop = this.guiTop + 14;
        this.addScroll(this.scrollQuests);
    }

    @Override
    public void buttonEvent(GuiButtonNop guibutton) {
        if (guibutton.id == 1) {
            MusicController.Instance.stopMusic();
            BlockPos pos = this.player.func_233580_cy_();
            MusicController.Instance.playSound(SoundCategory.NEUTRAL, this.selectedResource.toString(), pos, 1.0f, 1.0f);
        }
        if (guibutton.id == 2) {
            this.close();
        }
    }

    @Override
    public void scrollClicked(double i, double j, int k, GuiCustomScroll scroll) {
        if (scroll.id == 0) {
            this.selectedDomain = scroll.getSelected();
            this.selectedResource = null;
            this.scrollQuests.clearSelection();
        }
        if (scroll.id == 1) {
            this.selectedResource = new ResourceLocation(this.selectedDomain, scroll.getSelected());
        }
        this.func_231160_c_();
    }

    @Override
    public void scrollDoubleClicked(String selection, GuiCustomScroll scroll) {
        if (this.selectedResource == null) {
            return;
        }
        this.close();
    }
}

