/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.wrapper.gui.CustomGuiEntityDisplayWrapper;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.custom.interfaces.IGuiComponent;
import noppes.npcs.entity.EntityNPCInterface;

public class CustomGuiEntityDisplay
extends Widget
implements IGuiComponent {
    private GuiCustom parent;
    public CustomGuiEntityDisplayWrapper component;
    private Entity entity;
    public int id;

    public CustomGuiEntityDisplay(GuiCustom parent, CustomGuiEntityDisplayWrapper component) {
        super(component.getPosX(), component.getPosY(), component.getWidth(), component.getHeight(), (ITextComponent)new StringTextComponent(""));
        this.component = component;
        this.parent = parent;
        this.init();
    }

    public void init() {
        this.id = this.component.getID();
        this.field_230690_l_ = this.component.getPosX();
        this.field_230691_m_ = this.component.getPosY();
        this.func_230991_b_(this.component.getWidth());
        this.setHeight(this.component.getHeight());
        if (this.component.entityId != -1) {
            this.entity = Minecraft.func_71410_x().field_71439_g.func_130014_f_().func_73045_a(this.component.entityId);
        } else if (!this.component.entityData.getMCNBT().isEmpty()) {
            this.entity = EntityType.func_220330_a((CompoundNBT)this.component.entityData.getMCNBT(), (World)Minecraft.func_71410_x().field_71441_e).orElse(null);
        }
        this.field_230693_o_ = true;
        this.field_230694_p_ = true;
    }

    public void setEntity(Entity entity) {
        this.entity = entity;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void onRender(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230694_p_) {
            boolean hovered;
            if (this.entity != null) {
                this.drawEntity(this.entity, this.field_230690_l_, this.field_230691_m_, this.component.getScale(), this.component.getRotation() / 2 + 180, mouseX, mouseY, (float)this.field_230688_j_ / 2.0f, (float)this.field_230689_k_ * 0.9f);
            }
            int x = GuiCustom.guiLeft + this.field_230690_l_;
            int y = GuiCustom.guiTop + this.field_230691_m_;
            boolean bl = hovered = mouseX >= x && mouseY >= y && mouseX < x + this.field_230688_j_ && mouseY < y + this.field_230689_k_;
            if (hovered && this.component.hasHoverText()) {
                this.parent.hoverText = this.component.getHoverTextList();
            }
        }
    }

    @Override
    public ICustomGuiComponent toComponent() {
        return null;
    }

    protected int func_230989_a_(boolean p_getYImage_1_) {
        return 0;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double dx, double dy) {
        return true;
    }

    public static CustomGuiEntityDisplay fromComponent(GuiCustom parent, CustomGuiEntityDisplayWrapper component) {
        CustomGuiEntityDisplay btn = new CustomGuiEntityDisplay(parent, component);
        return btn;
    }

    public void drawEntity(Entity entity, int x, int y, float zoomed, int rotation, int xMouse, int yMouse, float guiLeft, float guiTop) {
        EntityNPCInterface npc = null;
        if (entity instanceof EntityNPCInterface) {
            npc = (EntityNPCInterface)entity;
        }
        LivingEntity livingEntity = null;
        if (entity instanceof LivingEntity) {
            livingEntity = (LivingEntity)entity;
        }
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f2 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        if (livingEntity != null) {
            f2 = livingEntity.field_70761_aq;
            f5 = livingEntity.field_70758_at;
            f6 = livingEntity.field_70759_as;
        }
        float scale = 1.0f;
        if ((double)entity.func_213302_cg() > 2.4) {
            scale = 2.0f / entity.func_213302_cg();
        }
        float f7 = (float)GuiCustom.guiLeft + (float)x - (float)xMouse;
        float f8 = ((float)GuiCustom.guiTop + (float)y - 50.0f * scale * zoomed) * (entity.func_213302_cg() / entity.func_70047_e()) - (float)yMouse;
        if (this.component.isFollowingCursor) {
            entity.field_70177_z = (float)Math.atan(f7 / 80.0f) * 40.0f + (float)rotation;
            entity.field_70125_A = -((float)Math.atan(f8 / 40.0f)) * 20.0f;
        } else {
            entity.field_70177_z = rotation;
            entity.field_70125_A = 0.0f;
        }
        if (livingEntity != null) {
            livingEntity.field_70759_as = livingEntity.field_70761_aq = entity.field_70177_z;
            livingEntity.field_70758_at = livingEntity.field_70761_aq;
        }
        int orientation = 0;
        if (npc != null) {
            orientation = npc.ais.orientation;
            npc.ais.orientation = (int)entity.field_70177_z;
        }
        float fs = 30.0f * scale * zoomed;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((float)this.parent.getGuiLeft() + (float)x), (float)(this.parent.getGuiTop() + y), (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixStack = new MatrixStack();
        matrixStack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixStack.func_227862_a_(30.0f * scale * zoomed, 30.0f * scale * zoomed, 30.0f * scale * zoomed);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        EntityRendererManager lvt_16_1_ = Minecraft.func_71410_x().func_175598_ae();
        lvt_16_1_.func_178633_a(false);
        IRenderTypeBuffer.Impl lvt_17_1_ = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_((float)rotation));
        RenderSystem.runAsFancy(() -> lvt_16_1_.func_229084_a_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)lvt_17_1_, 0xF000F0));
        lvt_17_1_.func_228461_a_();
        lvt_16_1_.func_178633_a(true);
        RenderSystem.popMatrix();
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        if (livingEntity != null) {
            livingEntity.field_70761_aq = f2;
            livingEntity.field_70758_at = f5;
            livingEntity.field_70759_as = f6;
        }
        if (npc != null) {
            npc.ais.orientation = orientation;
        }
    }

    public ICustomGuiComponent component() {
        return this.component;
    }
}

