/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.shared.client.gui.components.GuiBasic;
import noppes.npcs.shared.client.gui.components.GuiButtonNop;
import noppes.npcs.shared.client.gui.components.GuiTextFieldNop;
import noppes.npcs.shared.client.gui.listeners.ITextfieldListener;

public class SubGuiColorSelector
extends GuiBasic
implements ITextfieldListener {
    private static final ResourceLocation resource = new ResourceLocation("customnpcs:textures/gui/color.png");
    private int colorX;
    private int colorY;
    private GuiTextFieldNop textfield;
    public int color;

    public SubGuiColorSelector(int color) {
        this.imageWidth = 176;
        this.imageHeight = 222;
        this.color = color;
        this.setBackground("smallbg.png");
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.colorX = this.guiLeft + 30;
        this.colorY = this.guiTop + 50;
        this.textfield = new GuiTextFieldNop(0, (Screen)this, this.guiLeft + 53, this.guiTop + 20, 70, 20, this.getColor());
        this.addTextField(this.textfield);
        this.textfield.func_146193_g(this.color);
        this.addButton(new GuiButtonNop(this, 66, this.guiLeft + 112, this.guiTop + 198, 60, 20, "gui.done"));
    }

    public String getColor() {
        String str = Integer.toHexString(this.color);
        while (str.length() < 6) {
            str = "0" + str;
        }
        return str;
    }

    @Override
    public boolean func_231042_a_(char c, int i) {
        String prev = this.textfield.func_146179_b();
        super.func_231042_a_(c, i);
        String newText = this.textfield.func_146179_b();
        if (newText.equals(prev)) {
            return false;
        }
        try {
            this.color = Integer.parseInt(this.textfield.func_146179_b(), 16);
            this.textfield.func_146193_g(this.color);
        }
        catch (NumberFormatException e) {
            this.textfield.func_146180_a(prev);
        }
        return true;
    }

    @Override
    public void buttonEvent(GuiButtonNop btn) {
        if (btn.id == 66) {
            this.close();
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int par1, int limbSwingAmount, float par3) {
        super.func_230430_a_(matrixStack, par1, limbSwingAmount, par3);
        this.field_230706_i_.func_110434_K().func_110577_a(resource);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_238474_b_(matrixStack, this.colorX, this.colorY, 0, 0, 120, 120);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean func_231044_a_(double i, double j, int k) {
        super.func_231044_a_(i, j, k);
        if (i < (double)this.colorX || i > (double)(this.colorX + 117) || j < (double)this.colorY || j > (double)(this.colorY + 117)) {
            return false;
        }
        InputStream stream = null;
        try (IResource iresource = this.field_230706_i_.func_195551_G().func_199002_a(resource);){
            stream = iresource.func_199027_b();
            BufferedImage bufferedimage = ImageIO.read(stream);
            this.color = bufferedimage.getRGB((int)(i - (double)this.guiLeft - 30.0) * 4, (int)(j - (double)this.guiTop - 50.0) * 4) & 0xFFFFFF;
            this.textfield.func_146193_g(this.color);
            this.textfield.func_146180_a(this.getColor());
        }
        catch (IOException iOException) {
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    @Override
    public void unFocused(GuiTextFieldNop textfield) {
        int color = 0;
        try {
            color = Integer.parseInt(textfield.func_146179_b(), 16);
        }
        catch (NumberFormatException e) {
            color = 0;
        }
        this.color = color;
        textfield.func_146193_g(color);
    }
}

