/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.gui.IButton;
import noppes.npcs.api.gui.IColoredLine;
import noppes.npcs.api.gui.ICustomGui;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.gui.IEntityDisplay;
import noppes.npcs.api.gui.IItemRenderer;
import noppes.npcs.api.gui.IItemSlot;
import noppes.npcs.api.gui.ILabel;
import noppes.npcs.api.gui.IScroll;
import noppes.npcs.api.gui.ITextArea;
import noppes.npcs.api.gui.ITextField;
import noppes.npcs.api.gui.ITexturedRect;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiButtonWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiColoredLineWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiComponentWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiEntityDisplayWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiItemRendererWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiItemSlotWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiLabelWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiScrollWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTextAreaWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTextFieldWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTexturedRectWrapper;
import noppes.npcs.containers.ContainerCustomGui;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.packets.Packets;
import noppes.npcs.packets.client.PacketGuiData;

public class CustomGuiWrapper
implements ICustomGui {
    int id;
    int width;
    int height;
    int playerInvX;
    int playerInvY;
    boolean pauseGame;
    boolean showPlayerInv;
    String backgroundTexture = "";
    ScriptContainer scriptHandler;
    List<ICustomGuiComponent> components = new ArrayList<ICustomGuiComponent>();
    List<IItemSlot> slots = new ArrayList<IItemSlot>();

    public CustomGuiWrapper() {
    }

    public CustomGuiWrapper(int id, int width, int height, boolean pauseGame) {
        this.id = id;
        this.width = width;
        this.height = height;
        this.pauseGame = pauseGame;
        this.scriptHandler = ScriptContainer.Current;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public List<ICustomGuiComponent> getComponents() {
        return this.components;
    }

    @Override
    public List<IItemSlot> getSlots() {
        return this.slots;
    }

    public ScriptContainer getScriptHandler() {
        return this.scriptHandler;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void setDoesPauseGame(boolean pauseGame) {
        this.pauseGame = pauseGame;
    }

    public boolean getDoesPauseGame() {
        return this.pauseGame;
    }

    @Override
    public void setBackgroundTexture(String resourceLocation) {
        this.backgroundTexture = resourceLocation;
    }

    public String getBackgroundTexture() {
        return this.backgroundTexture;
    }

    @Override
    public IButton addButton(int id, String label, int x, int y) {
        CustomGuiButtonWrapper component = new CustomGuiButtonWrapper(id, label, x, y);
        this.components.add(component);
        return component;
    }

    @Override
    public IButton addButton(int id, String label, int x, int y, int width, int height) {
        CustomGuiButtonWrapper component = new CustomGuiButtonWrapper(id, label, x, y, width, height);
        this.components.add(component);
        return component;
    }

    @Override
    public IButton addTexturedButton(int id, String label, int x, int y, int width, int height, String texture) {
        CustomGuiButtonWrapper component = new CustomGuiButtonWrapper(id, label, x, y, width, height, texture);
        this.components.add(component);
        return component;
    }

    @Override
    public IButton addTexturedButton(int id, String label, int x, int y, int width, int height, String texture, int textureX, int textureY) {
        CustomGuiButtonWrapper component = new CustomGuiButtonWrapper(id, label, x, y, width, height, texture, textureX, textureY);
        this.components.add(component);
        return component;
    }

    @Override
    public ILabel addLabel(int id, String label, int x, int y, int width, int height) {
        CustomGuiLabelWrapper component = new CustomGuiLabelWrapper(id, label, x, y, width, height);
        this.components.add(component);
        return component;
    }

    @Override
    public ILabel addLabel(int id, String label, int x, int y, int width, int height, int color) {
        CustomGuiLabelWrapper component = new CustomGuiLabelWrapper(id, label, x, y, width, height, color);
        this.components.add(component);
        return component;
    }

    @Override
    public ITextField addTextField(int id, int x, int y, int width, int height) {
        CustomGuiTextFieldWrapper component = new CustomGuiTextFieldWrapper(id, x, y, width, height);
        this.components.add(component);
        return component;
    }

    @Override
    public ITextArea addTextArea(int id, int x, int y, int width, int height) {
        CustomGuiTextAreaWrapper component = new CustomGuiTextAreaWrapper(id, x, y, width, height);
        this.components.add(component);
        return component;
    }

    @Override
    public ITexturedRect addTexturedRect(int id, String texture, int x, int y, int width, int height) {
        CustomGuiTexturedRectWrapper component = new CustomGuiTexturedRectWrapper(id, texture, x, y, width, height);
        this.components.add(component);
        return component;
    }

    @Override
    public ITexturedRect addTexturedRect(int id, String texture, int x, int y, int width, int height, int textureX, int textureY) {
        CustomGuiTexturedRectWrapper component = new CustomGuiTexturedRectWrapper(id, texture, x, y, width, height, textureX, textureY);
        this.components.add(component);
        return component;
    }

    @Override
    public IItemSlot addItemSlot(int x, int y) {
        return this.addItemSlot(x, y, ItemScriptedWrapper.AIR);
    }

    @Override
    public IItemSlot addItemSlot(int x, int y, IItemStack stack) {
        CustomGuiItemSlotWrapper slot = new CustomGuiItemSlotWrapper(x, y, stack);
        this.slots.add(slot);
        return this.slots.get(this.slots.size() - 1);
    }

    @Override
    public IScroll addScroll(int id, int x, int y, int width, int height, String[] list) {
        CustomGuiScrollWrapper component = new CustomGuiScrollWrapper(id, x, y, width, height, list);
        this.components.add(component);
        return component;
    }

    public IEntityDisplay addEntityDisplay(int id, int x, int y, int width, int height, IEntity entity) {
        CustomGuiEntityDisplayWrapper display = new CustomGuiEntityDisplayWrapper(id, x, y, width, height, entity);
        this.components.add(display);
        return display;
    }

    public IColoredLine addColoredLine(int id, int xStart, int yStart, int xEnd, int yEnd, int color, float thickness) {
        CustomGuiColoredLineWrapper line = new CustomGuiColoredLineWrapper(id, xStart, yStart, xEnd, yEnd, color, thickness);
        this.components.add(line);
        return line;
    }

    public IItemRenderer addItemRenderer(int id, int x, int y, int width, int height, IItemStack stack) {
        CustomGuiItemRendererWrapper rendererWrapper = new CustomGuiItemRendererWrapper(id, x, y, width, height, stack);
        this.components.add(rendererWrapper);
        return rendererWrapper;
    }

    @Override
    public void showPlayerInventory(int x, int y) {
        this.showPlayerInv = true;
        this.playerInvX = x;
        this.playerInvY = y;
    }

    @Override
    public ICustomGuiComponent getComponent(int componentID) {
        for (ICustomGuiComponent component : this.components) {
            if (component.getID() != componentID) continue;
            return component;
        }
        return null;
    }

    @Override
    public void removeComponent(int componentID) {
        this.components.removeIf(c -> c.getID() == componentID);
    }

    @Deprecated
    public void updateComponent(ICustomGuiComponent component) {
        for (int i = 0; i < this.components.size(); ++i) {
            ICustomGuiComponent c = this.components.get(i);
            if (c.getID() != component.getID()) continue;
            this.components.set(i, component);
            return;
        }
    }

    @Override
    public void update(IPlayer player) {
        if (((ServerPlayerEntity)player.getMCEntity()).field_71070_bA instanceof ContainerCustomGui) {
            Packets.send(player.getMCEntity(), new PacketGuiData(this.toNBT()));
        }
    }

    public void updateSlots(IPlayer player) {
        ((ContainerCustomGui)((ServerPlayerEntity)player.getMCEntity()).field_71070_bA).setGui(this, (PlayerEntity)player.getMCEntity());
    }

    public boolean getShowPlayerInv() {
        return this.showPlayerInv;
    }

    public int getPlayerInvX() {
        return this.playerInvX;
    }

    public int getPlayerInvY() {
        return this.playerInvY;
    }

    public ICustomGui fromNBT(CompoundNBT tag) {
        this.id = tag.func_74762_e("id");
        this.width = tag.func_74759_k("size")[0];
        this.height = tag.func_74759_k("size")[1];
        this.pauseGame = tag.func_74767_n("pause");
        this.backgroundTexture = tag.func_74779_i("bgTexture");
        ArrayList<ICustomGuiComponent> components = new ArrayList<ICustomGuiComponent>();
        ListNBT list = tag.func_150295_c("components", 10);
        for (INBT b : list) {
            CustomGuiComponentWrapper component = CustomGuiComponentWrapper.createFromNBT((CompoundNBT)b);
            components.add(component);
        }
        this.components = components;
        ArrayList<IItemSlot> slots = new ArrayList<IItemSlot>();
        list = tag.func_150295_c("slots", 10);
        for (INBT b2 : list) {
            CustomGuiItemSlotWrapper component2 = (CustomGuiItemSlotWrapper)CustomGuiComponentWrapper.createFromNBT((CompoundNBT)b2);
            slots.add(component2);
        }
        this.slots = slots;
        this.showPlayerInv = tag.func_74767_n("showPlayerInv");
        if (this.showPlayerInv) {
            this.playerInvX = tag.func_74759_k("pInvPos")[0];
            this.playerInvY = tag.func_74759_k("pInvPos")[1];
        }
        return this;
    }

    public CompoundNBT toNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("id", this.id);
        tag.func_74783_a("size", new int[]{this.width, this.height});
        tag.func_74757_a("pause", this.pauseGame);
        tag.func_74778_a("bgTexture", this.backgroundTexture);
        ListNBT list = new ListNBT();
        for (ICustomGuiComponent iCustomGuiComponent : this.components) {
            list.add((Object)((CustomGuiComponentWrapper)iCustomGuiComponent).toNBT(new CompoundNBT()));
        }
        tag.func_218657_a("components", (INBT)list);
        list = new ListNBT();
        for (ICustomGuiComponent iCustomGuiComponent : this.slots) {
            list.add((Object)((CustomGuiComponentWrapper)iCustomGuiComponent).toNBT(new CompoundNBT()));
        }
        tag.func_218657_a("slots", (INBT)list);
        tag.func_74757_a("showPlayerInv", this.showPlayerInv);
        if (this.showPlayerInv) {
            tag.func_74783_a("pInvPos", new int[]{this.playerInvX, this.playerInvY});
        }
        return tag;
    }
}

