/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.eventbus.api.BusBuilder;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import nikedemos.markovnames.generators.MarkovGenerator;
import noppes.npcs.CustomEntities;
import noppes.npcs.CustomNpcs;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IContainer;
import noppes.npcs.api.IDamageSource;
import noppes.npcs.api.INbt;
import noppes.npcs.api.IPos;
import noppes.npcs.api.IWorld;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.block.IBlock;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IEntity;
import noppes.npcs.api.entity.data.IPlayerMail;
import noppes.npcs.api.gui.ICustomGui;
import noppes.npcs.api.handler.ICloneHandler;
import noppes.npcs.api.handler.IDialogHandler;
import noppes.npcs.api.handler.IFactionHandler;
import noppes.npcs.api.handler.IQuestHandler;
import noppes.npcs.api.handler.IRecipeHandler;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.overlay.IOverlay;
import noppes.npcs.api.wrapper.BlockPosWrapper;
import noppes.npcs.api.wrapper.BlockWrapper;
import noppes.npcs.api.wrapper.ContainerWrapper;
import noppes.npcs.api.wrapper.DamageSourceWrapper;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.api.wrapper.NBTWrapper;
import noppes.npcs.api.wrapper.OverlayWrapper;
import noppes.npcs.api.wrapper.WorldWrapper;
import noppes.npcs.api.wrapper.WrapperEntityData;
import noppes.npcs.api.wrapper.gui.CustomGuiWrapper;
import noppes.npcs.containers.ContainerNpcInterface;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.shared.common.util.LRUHashMap;
import noppes.npcs.util.NBTJsonUtil;

public class WrapperNpcAPI
extends NpcAPI {
    private static final Map<DimensionType, WorldWrapper> worldCache = new LRUHashMap<DimensionType, WorldWrapper>(10);
    public static final IEventBus EVENT_BUS = BusBuilder.builder().build();
    private static NpcAPI instance = null;

    public static void clearCache() {
        worldCache.clear();
        BlockWrapper.clearCache();
    }

    @Override
    public IEntity getIEntity(Entity entity) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return null;
        }
        if (entity instanceof EntityNPCInterface) {
            return ((EntityNPCInterface)entity).wrappedNPC;
        }
        return WrapperEntityData.get(entity);
    }

    @Override
    public ICustomNpc createNPC(World level) {
        if (level.field_72995_K) {
            return null;
        }
        EntityCustomNpc npc = new EntityCustomNpc(CustomEntities.entityCustomNpc, level);
        return npc.wrappedNPC;
    }

    @Override
    public void registerPermissionNode(String permission, int defaultType) {
        if (defaultType < 0 || defaultType > 2) {
            throw new CustomNPCsException("Default type cant be smaller than 0 or larger than 2", new Object[0]);
        }
        if (this.hasPermissionNode(permission)) {
            throw new CustomNPCsException("Permission already exists", new Object[0]);
        }
        DefaultPermissionLevel level = DefaultPermissionLevel.values()[defaultType];
        PermissionAPI.registerNode((String)permission, (DefaultPermissionLevel)level, (String)permission);
    }

    @Override
    public boolean hasPermissionNode(String permission) {
        return PermissionAPI.getPermissionHandler().getRegisteredNodes().contains(permission);
    }

    @Override
    public ICustomNpc spawnNPC(World level, int x, int y, int z) {
        if (level.field_72995_K) {
            return null;
        }
        EntityCustomNpc npc = new EntityCustomNpc(CustomEntities.entityCustomNpc, level);
        npc.func_70080_a((double)x + 0.5, y, (double)z + 0.5, 0.0f, 0.0f);
        npc.ais.setStartPos(x, y, z);
        npc.func_70606_j(npc.func_110138_aP());
        level.func_217376_c((Entity)npc);
        return npc.wrappedNPC;
    }

    public static NpcAPI Instance() {
        if (instance == null) {
            instance = new WrapperNpcAPI();
        }
        return instance;
    }

    @Override
    public IEventBus events() {
        return EVENT_BUS;
    }

    @Override
    public IBlock getIBlock(World level, BlockPos pos) {
        return BlockWrapper.createNew(level, pos, level.func_180495_p(pos));
    }

    @Override
    public IItemStack getIItemStack(ItemStack itemstack) {
        if (itemstack == null || itemstack.func_190926_b()) {
            return ItemStackWrapper.AIR;
        }
        return (IItemStack)itemstack.getCapability(ItemStackWrapper.ITEMSCRIPTEDDATA_CAPABILITY, null).orElse((Object)ItemStackWrapper.AIR);
    }

    @Override
    public IWorld getIWorld(ServerWorld level) {
        WorldWrapper w = worldCache.get(level.func_230315_m_());
        if (w != null) {
            w.level = level;
            return w;
        }
        w = WorldWrapper.createNew(level);
        worldCache.put(level.func_230315_m_(), w);
        return w;
    }

    @Override
    public IWorld getIWorld(DimensionType dimension) {
        for (ServerWorld level : CustomNpcs.Server.func_212370_w()) {
            if (level.func_230315_m_() != dimension) continue;
            return this.getIWorld(level);
        }
        throw new CustomNPCsException("Unknown dimension: " + dimension, new Object[0]);
    }

    @Override
    public IWorld getIWorld(String dimension) {
        ResourceLocation loc = new ResourceLocation(dimension);
        for (ServerWorld level : CustomNpcs.Server.func_212370_w()) {
            if (!level.func_234923_W_().func_240901_a_().equals((Object)loc)) continue;
            return this.getIWorld(level);
        }
        throw new CustomNPCsException("Unknown dimension: " + loc, new Object[0]);
    }

    @Override
    public IContainer getIContainer(IInventory inventory) {
        return new ContainerWrapper(inventory);
    }

    @Override
    public IContainer getIContainer(Container container) {
        if (container instanceof ContainerNpcInterface) {
            return ContainerNpcInterface.getOrCreateIContainer((ContainerNpcInterface)container);
        }
        return new ContainerWrapper(container);
    }

    @Override
    public IFactionHandler getFactions() {
        this.checkWorld();
        return FactionController.instance;
    }

    private void checkWorld() {
        if (CustomNpcs.Server == null || CustomNpcs.Server.func_71241_aa()) {
            throw new CustomNPCsException("No world is loaded right now", new Object[0]);
        }
    }

    @Override
    public IRecipeHandler getRecipes() {
        this.checkWorld();
        return RecipeController.instance;
    }

    @Override
    public IQuestHandler getQuests() {
        this.checkWorld();
        return QuestController.instance;
    }

    @Override
    public IWorld[] getIWorlds() {
        this.checkWorld();
        ArrayList<IWorld> list = new ArrayList<IWorld>();
        for (ServerWorld level : CustomNpcs.Server.func_212370_w()) {
            list.add(this.getIWorld(level));
        }
        return list.toArray(new IWorld[list.size()]);
    }

    @Override
    public IPos getIPos(double x, double y, double z) {
        return new BlockPosWrapper(new BlockPos(x, y, z));
    }

    @Override
    public File getGlobalDir() {
        return CustomNpcs.Dir;
    }

    @Override
    public File getWorldDir() {
        return CustomNpcs.getWorldSaveDirectory();
    }

    @Override
    public INbt getINbt(CompoundNBT compound) {
        if (compound == null) {
            return new NBTWrapper(new CompoundNBT());
        }
        return new NBTWrapper(compound);
    }

    @Override
    public INbt stringToNbt(String str) {
        if (str == null || str.isEmpty()) {
            throw new CustomNPCsException("Cant cast empty string to nbt", new Object[0]);
        }
        try {
            return this.getINbt(NBTJsonUtil.Convert(str));
        }
        catch (NBTJsonUtil.JsonException e) {
            throw new CustomNPCsException(e, "Failed converting " + str, new Object[0]);
        }
    }

    @Override
    public IDamageSource getIDamageSource(DamageSource damagesource) {
        return new DamageSourceWrapper(damagesource);
    }

    @Override
    public IDialogHandler getDialogs() {
        return DialogController.instance;
    }

    @Override
    public ICloneHandler getClones() {
        return ServerCloneController.Instance;
    }

    @Override
    public String executeCommand(IWorld level, String command) {
        FakePlayer player = EntityNPCInterface.CommandPlayer;
        player.func_70029_a((World)level.getMCWorld());
        player.func_70107_b(0.0, 0.0, 0.0);
        return NoppesUtilServer.runCommand((World)level.getMCWorld(), BlockPos.field_177992_a, "API", command, null, (Entity)player);
    }

    @Override
    public INbt getRawPlayerData(String uuid) {
        return this.getINbt(PlayerData.loadPlayerData(uuid));
    }

    @Override
    public IPlayerMail createMail(String sender, String subject) {
        PlayerMail mail = new PlayerMail();
        mail.sender = sender;
        mail.subject = subject;
        return mail;
    }

    @Override
    public ICustomGui createCustomGui(int id, int width, int height, boolean pauseGame) {
        return new CustomGuiWrapper(id, width, height, pauseGame);
    }

    @Override
    public String getRandomName(int dictionary, int gender) {
        return MarkovGenerator.fetch(dictionary, gender);
    }

    @Override
    public IOverlay createOverlay(int id) {
        return new OverlayWrapper(id);
    }
}

