/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai;

import java.util.ArrayList;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import noppes.npcs.ai.AdvWalkNodeProcessor;

public class NpcGroundPathNavigator
extends GroundPathNavigator {
    public NpcGroundPathNavigator(MobEntity p_i45875_1_, World p_i45875_2_) {
        super(p_i45875_1_, p_i45875_2_);
    }

    protected PathFinder func_179679_a(int p_179679_1_) {
        this.field_179695_a = new AdvWalkNodeProcessor();
        this.field_179695_a.func_186317_a(true);
        return new PathFinder(this.field_179695_a, p_179679_1_);
    }

    protected void func_75508_h() {
        Vector3d vec3d = this.func_75502_i();
        int i = this.field_75514_c.func_75874_d();
        for (int j = this.field_75514_c.func_75873_e(); j < this.field_75514_c.func_75874_d(); ++j) {
            if ((double)this.field_75514_c.func_75877_a((int)j).field_75837_b == Math.floor(vec3d.field_72448_b)) continue;
            i = j;
            break;
        }
        this.field_188561_o = this.field_75515_a.func_213311_cf() > 0.75f ? this.field_75515_a.func_213311_cf() / 2.0f : 0.75f - this.field_75515_a.func_213311_cf() / 2.0f;
        BlockPos vec3i = this.field_75514_c.func_242948_g();
        if (MathHelper.func_76135_e((float)((float)(this.field_75515_a.func_226277_ct_() - ((double)vec3i.func_177958_n() + 0.5)))) < this.field_188561_o && MathHelper.func_76135_e((float)((float)(this.field_75515_a.func_226281_cx_() - ((double)vec3i.func_177952_p() + 0.5)))) < this.field_188561_o && Math.abs(this.field_75515_a.func_226278_cu_() - (double)vec3i.func_177956_o()) < 1.0) {
            this.field_75514_c.func_75875_a();
        }
        int k = MathHelper.func_76123_f((float)this.field_75515_a.func_213311_cf());
        int l = MathHelper.func_76123_f((float)this.field_75515_a.func_213302_cg());
        int i1 = k;
        for (int j1 = i - 1; j1 >= this.field_75514_c.func_75873_e(); --j1) {
            if (!this.isDirectPathBetweenPoints(vec3d, this.field_75514_c.func_75881_a((Entity)this.field_75515_a, j1), k, l, i1)) continue;
            this.field_75514_c.func_75872_c(j1);
            break;
        }
        this.func_179677_a(vec3d);
    }

    protected boolean isDirectPathBetweenPoints(Vector3d posVec31, Vector3d posVec32, int sizeX, int sizeY, int sizeZ) {
        int i = MathHelper.func_76128_c((double)posVec31.field_72450_a);
        int j = MathHelper.func_76128_c((double)posVec31.field_72449_c);
        double d0 = posVec32.field_72450_a - posVec31.field_72450_a;
        double d1 = posVec32.field_72449_c - posVec31.field_72449_c;
        double d2 = d0 * d0 + d1 * d1;
        if (d2 < 1.0E-8) {
            return false;
        }
        double d3 = 1.0 / Math.sqrt(d2);
        if (!this.isSafeToStandAt(i, (int)posVec31.field_72448_b, j, sizeX += 2, sizeY, sizeZ += 2, posVec31, d0 *= d3, d1 *= d3)) {
            return false;
        }
        sizeX -= 2;
        sizeZ -= 2;
        double d4 = 1.0 / Math.abs(d0);
        double d5 = 1.0 / Math.abs(d1);
        double d6 = (double)i - posVec31.field_72450_a;
        double d7 = (double)j - posVec31.field_72449_c;
        if (d0 >= 0.0) {
            d6 += 1.0;
        }
        if (d1 >= 0.0) {
            d7 += 1.0;
        }
        d6 /= d0;
        d7 /= d1;
        int k = d0 < 0.0 ? -1 : 1;
        int l = d1 < 0.0 ? -1 : 1;
        int i1 = MathHelper.func_76128_c((double)posVec32.field_72450_a);
        int j1 = MathHelper.func_76128_c((double)posVec32.field_72449_c);
        int k1 = i1 - i;
        int l1 = j1 - j;
        while (k1 * k > 0 || l1 * l > 0) {
            if (d6 < d7) {
                d6 += d4;
                k1 = i1 - (i += k);
            } else {
                d7 += d5;
                l1 = j1 - (j += l);
            }
            if (this.isSafeToStandAt(i, (int)posVec31.field_72448_b, j, sizeX, sizeY, sizeZ, posVec31, d0, d1)) continue;
            return false;
        }
        return true;
    }

    private boolean isPositionClear(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vector3d p_179692_7_, double p_179692_8_, double p_179692_10_) {
        for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)new BlockPos(x, y, z), (BlockPos)new BlockPos(x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1))) {
            double d1;
            double d0 = (double)blockpos.func_177958_n() + 0.5 - p_179692_7_.field_72450_a;
            if (!(d0 * p_179692_8_ + (d1 = (double)blockpos.func_177952_p() + 0.5 - p_179692_7_.field_72449_c) * p_179692_10_ >= 0.0) || this.field_75513_b.func_180495_p(blockpos).func_196957_g((IBlockReader)this.field_75513_b, blockpos, PathType.LAND)) continue;
            return false;
        }
        return true;
    }

    private boolean isSafeToStandAt(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vector3d vec31, double p_179683_8_, double p_179683_10_) {
        int i = x - sizeX / 2;
        int j = z - sizeZ / 2;
        if (!this.isPositionClear(i, y, j, sizeX, sizeY, sizeZ, vec31, p_179683_8_, p_179683_10_)) {
            return false;
        }
        for (int k = i; k < i + sizeX; ++k) {
            for (int l = j; l < j + sizeZ; ++l) {
                double d0 = (double)k + 0.5 - vec31.field_72450_a;
                double d1 = (double)l + 0.5 - vec31.field_72449_c;
                if (!(d0 * p_179683_8_ + d1 * p_179683_10_ >= 0.0)) continue;
                PathNodeType pathnodetype = ((AdvWalkNodeProcessor)this.field_179695_a).func_237230_a_(this.field_75515_a, k, y - 1, l);
                if (pathnodetype == PathNodeType.WATER) {
                    return false;
                }
                if (pathnodetype == PathNodeType.LAVA) {
                    return false;
                }
                if (pathnodetype == PathNodeType.OPEN) {
                    return false;
                }
                pathnodetype = ((AdvWalkNodeProcessor)this.field_179695_a).func_237230_a_(this.field_75515_a, k, y, l);
                float f = this.field_75515_a.func_184643_a(pathnodetype);
                if (f < 0.0f || f >= 8.0f) {
                    return false;
                }
                if (pathnodetype != PathNodeType.DAMAGE_FIRE && pathnodetype != PathNodeType.DANGER_FIRE && pathnodetype != PathNodeType.DAMAGE_OTHER) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    protected Path func_225464_a(Set<BlockPos> p_225464_1_, int p_225464_2_, boolean p_225464_3_, int p_225464_4_) {
        try {
            return super.func_225464_a(p_225464_1_, p_225464_2_, p_225464_3_, p_225464_4_);
        }
        catch (Exception e) {
            return new Path(new ArrayList(), BlockPos.field_177992_a, false);
        }
    }

    public Path func_75494_a(Entity p_75494_1_, int p_75494_2_) {
        try {
            return super.func_75494_a(p_75494_1_, p_75494_2_);
        }
        catch (Exception e) {
            return new Path(new ArrayList(), BlockPos.field_177992_a, false);
        }
    }

    @Nullable
    public Path func_241390_a_(Set<BlockPos> p_241390_1_, int p_241390_2_) {
        try {
            return super.func_241390_a_(p_241390_1_, p_241390_2_);
        }
        catch (Exception e) {
            return new Path(new ArrayList(), BlockPos.field_177992_a, false);
        }
    }

    @Nullable
    public Path func_225463_a(Stream<BlockPos> p_225463_1_, int p_225463_2_) {
        try {
            return super.func_225463_a(p_225463_1_, p_225463_2_);
        }
        catch (Exception e) {
            return new Path(new ArrayList(), BlockPos.field_177992_a, false);
        }
    }

    public Path func_179680_a(BlockPos p_179680_1_, int p_179680_2_) {
        try {
            return super.func_179680_a(p_179680_1_, p_179680_2_);
        }
        catch (Exception e) {
            return new Path(new ArrayList(), BlockPos.field_177992_a, false);
        }
    }
}

