/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;

public class NpcMiscInventory
implements IInventory {
    public final NonNullList<ItemStack> items;
    public int stackLimit = 64;
    private int size;

    public NpcMiscInventory(int size) {
        this.size = size;
        this.items = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    public CompoundNBT getToNBT() {
        CompoundNBT nbttagcompound = new CompoundNBT();
        nbttagcompound.func_218657_a("NpcMiscInv", (INBT)NBTTags.nbtItemStackList(this.items));
        return nbttagcompound;
    }

    public void setFromNBT(CompoundNBT nbttagcompound) {
        NBTTags.getItemStackList(nbttagcompound.func_150295_c("NpcMiscInv", 10), this.items);
    }

    public int func_70302_i_() {
        return this.size;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public boolean removeItem(ItemStack eating, int decrease) {
        for (int slot = 0; slot < this.items.size(); ++slot) {
            ItemStack item = (ItemStack)this.items.get(slot);
            if (item.func_190926_b() || eating != item || item.func_190916_E() < decrease) continue;
            item.func_77979_a(decrease);
            if (item.func_190916_E() <= 0) {
                this.items.set(slot, (Object)ItemStack.field_190927_a);
            }
            return true;
        }
        return false;
    }

    public ItemStack func_70304_b(int var1) {
        return (ItemStack)this.items.set(var1, (Object)ItemStack.field_190927_a);
    }

    public void func_70299_a(int var1, ItemStack var2) {
        if (var1 >= this.func_70302_i_()) {
            return;
        }
        this.items.set(var1, (Object)var2);
    }

    public int func_70297_j_() {
        return this.stackLimit;
    }

    public boolean func_70300_a(PlayerEntity var1) {
        return true;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void func_70296_d() {
    }

    public boolean addItemStack(ItemStack item) {
        ItemStack mergable;
        boolean merged = false;
        while (!(mergable = this.getMergableItem(item)).func_190926_b() && mergable.func_190916_E() > 0) {
            int size = mergable.func_77976_d() - mergable.func_190916_E();
            if (size > item.func_190916_E()) {
                mergable.func_190920_e(mergable.func_77976_d());
                item.func_190920_e(item.func_190916_E() - size);
                merged = true;
                continue;
            }
            mergable.func_190920_e(mergable.func_190916_E() + item.func_190916_E());
            item.func_190920_e(0);
        }
        if (item.func_190916_E() <= 0) {
            return true;
        }
        int slot = this.firstFreeSlot();
        if (slot >= 0) {
            this.items.set(slot, (Object)item.func_77946_l());
            item.func_190920_e(0);
            return true;
        }
        return merged;
    }

    public ItemStack getMergableItem(ItemStack item) {
        for (ItemStack is : this.items) {
            if (!NoppesUtilPlayer.compareItems(item, is, false, false) || is.func_190916_E() >= is.func_77976_d()) continue;
            return is;
        }
        return ItemStack.field_190927_a;
    }

    public int firstFreeSlot() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!((ItemStack)this.items.get(i)).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public void setSize(int i) {
        this.size = i;
    }

    public void func_174889_b(PlayerEntity player) {
    }

    public void func_174886_c(PlayerEntity player) {
    }

    public void func_174888_l() {
    }

    public boolean func_191420_l() {
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            ItemStack item = this.func_70301_a(slot);
            if (NoppesUtilServer.IsItemStackNull(item) || item.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

