/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import noppes.npcs.CustomEntities;
import noppes.npcs.CustomNpcs;
import noppes.npcs.controllers.SpawnController;
import noppes.npcs.controllers.data.SpawnData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;

public class NPCSpawning {
    public static void findChunksForSpawning(ServerWorld level) {
        if (!SpawnController.instance.data.isEmpty() && level.func_82737_E() % 400L == 0L) {
            ChunkManager chunkManager = level.func_72863_F().field_217237_a;
            ArrayList list = Lists.newArrayList((Iterable)Iterables.unmodifiableIterable((Iterable)chunkManager.field_219252_f.values()));
            Collections.shuffle(list);
            list.forEach(chunkHolder -> {
                Chunk chunk;
                ChunkPos pos;
                Biome biome;
                Optional optional1 = chunkHolder.func_219297_b().getNow(ChunkHolder.field_219308_c).left();
                if (optional1.isPresent() && SpawnController.instance.hasSpawnList((biome = level.func_226691_t_((pos = (chunk = (Chunk)optional1.get()).func_76632_l()).func_206849_h())).getRegistryName())) {
                    AxisAlignedBB bb = new AxisAlignedBB((double)pos.func_180334_c(), 0.0, (double)pos.func_180333_d(), (double)pos.func_180332_e(), (double)level.func_217301_I(), (double)pos.func_180330_f());
                    ArrayList entities = Lists.newArrayList();
                    chunk.func_177430_a(PlayerEntity.class, bb.func_186662_g(4.0), (List)entities, null);
                    if (entities.isEmpty()) {
                        chunk.func_177430_a(EntityCustomNpc.class, bb, (List)entities, null);
                        if (entities.size() < CustomNpcs.NpcNaturalSpawningChunkLimit) {
                            NPCSpawning.spawnChunk(level, chunk);
                        }
                    }
                }
            });
        }
    }

    private static void spawnChunk(ServerWorld level, Chunk chunk) {
        BlockPos chunkposition = NPCSpawning.getChunk((World)level, chunk);
        int j1 = chunkposition.func_177958_n();
        int k1 = chunkposition.func_177956_o();
        int l1 = chunkposition.func_177952_p();
        for (int i = 0; i < 3; ++i) {
            int z;
            int b1 = 6;
            int x = j1 + (level.field_73012_v.nextInt(b1) - level.field_73012_v.nextInt(b1));
            BlockPos pos = new BlockPos(x, k1, z = l1 + (level.field_73012_v.nextInt(b1) - level.field_73012_v.nextInt(b1)));
            ResourceLocation name = level.func_226691_t_(pos).getRegistryName();
            SpawnData data = SpawnController.instance.getRandomSpawnData(name);
            if (data == null || data.data.isEmpty() || !NPCSpawning.canCreatureTypeSpawnAtLocation(data, (World)level, pos)) continue;
            NPCSpawning.spawnData(data, (World)level, pos);
        }
    }

    public static int countNPCs(ServerWorld level) {
        int count = 0;
        Collection list = level.field_175741_N.values();
        for (Entity entity : list) {
            if (!(entity instanceof EntityNPCInterface)) continue;
            ++count;
        }
        return count;
    }

    private static BlockPos getChunk(World level, Chunk chunk) {
        ChunkPos chunkpos = chunk.func_76632_l();
        int i = chunkpos.func_180334_c() + level.field_73012_v.nextInt(16);
        int j = chunkpos.func_180333_d() + level.field_73012_v.nextInt(16);
        int k = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, i, j) + 1;
        int l = level.field_73012_v.nextInt(k + 1);
        return new BlockPos(i, l, j);
    }

    public static void performWorldGenSpawning(World level, Biome biome, int x, int z, Random rand) {
        if (!(biome.func_242433_b().func_242557_a() >= 1.0f) && !(biome.func_242433_b().func_242557_a() < 0.0f) && SpawnController.instance.hasSpawnList(biome.getRegistryName())) {
            int tries = 0;
            block0: while (rand.nextFloat() < biome.func_242433_b().func_242557_a() && ++tries <= 20) {
                SpawnData data = SpawnController.instance.getRandomSpawnData(biome.getRegistryName());
                int size = 16;
                int j1 = x + rand.nextInt(size);
                int k1 = z + rand.nextInt(size);
                int l1 = j1;
                int i2 = k1;
                for (int k2 = 0; k2 < 4; ++k2) {
                    BlockPos pos = NPCSpawning.getTopNonCollidingPos((IWorldReader)level, CustomEntities.entityCustomNpc, 0, k1);
                    if (NPCSpawning.canCreatureTypeSpawnAtLocation(data, level, pos)) {
                        if (!NPCSpawning.spawnData(data, level, pos)) continue;
                        continue block0;
                    }
                    j1 += rand.nextInt(5) - rand.nextInt(5);
                    k1 += rand.nextInt(5) - rand.nextInt(5);
                    while (j1 < x || j1 >= x + size || k1 < z || k1 >= z + size) {
                        j1 = l1 + rand.nextInt(5) - rand.nextInt(5);
                        k1 = i2 + rand.nextInt(5) - rand.nextInt(5);
                    }
                }
            }
        }
    }

    private static boolean spawnData(SpawnData data, World level, BlockPos pos) {
        MobEntity entityliving;
        try {
            CompoundNBT nbt = data.getCompound(1);
            if (nbt == null) {
                return false;
            }
            Entity entity = EntityType.func_220330_a((CompoundNBT)nbt, (World)level).orElse(null);
            if (entity == null || !(entity instanceof MobEntity)) {
                return false;
            }
            entityliving = (MobEntity)entity;
            if (entity instanceof EntityCustomNpc) {
                EntityCustomNpc npc = (EntityCustomNpc)entity;
                npc.stats.spawnCycle = 4;
                npc.stats.respawnTime = 0;
                npc.ais.returnToStart = false;
                npc.ais.setStartPos(pos);
            }
            entity.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, level.field_73012_v.nextFloat() * 360.0f, 0.0f);
        }
        catch (Exception var7) {
            var7.printStackTrace();
            return false;
        }
        Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((MobEntity)entityliving, (IWorld)level, (double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), null, (SpawnReason)SpawnReason.NATURAL);
        if (canSpawn != Event.Result.DENY && (canSpawn != Event.Result.DEFAULT || entityliving.func_213380_a((IWorld)level, SpawnReason.NATURAL))) {
            level.func_73046_m().func_222817_e(() -> level.func_217376_c((Entity)entityliving));
            return true;
        }
        return false;
    }

    public static float getLightLevel(World level, BlockPos pos) {
        int blockLight = level.func_226658_a_(LightType.BLOCK, pos);
        int skyLight = level.func_226658_a_(LightType.SKY, pos);
        int skyDarken = level.func_175657_ab();
        float skyLightValue = (11.0f - (float)skyDarken) * 15.0f / 11.0f;
        return Math.max((float)blockLight, (float)skyLight / 15.0f * skyLightValue);
    }

    public static boolean canCreatureTypeSpawnAtLocation(SpawnData data, World level, BlockPos pos) {
        if (level.func_175723_af().func_177746_a(pos) && level.func_226664_a_(CustomEntities.entityCustomNpc.func_220328_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()))) {
            if (data.type == 1 && NPCSpawning.getLightLevel(level, pos) > 8.0f || data.type == 2 && NPCSpawning.getLightLevel(level, pos) <= 8.0f) {
                return false;
            }
            BlockState state = level.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (data.liquid) {
                return state.func_185904_a().func_76224_d() && level.func_180495_p(pos.func_177977_b()).func_185904_a().func_76224_d() && !level.func_180495_p(pos.func_177984_a()).func_215686_e((IBlockReader)level, pos.func_177984_a());
            }
            BlockPos blockpos1 = pos.func_177977_b();
            BlockState state1 = level.func_180495_p(blockpos1);
            Block block1 = state1.func_177230_c();
            boolean flag = block1 != Blocks.field_150357_h && block1 != Blocks.field_180401_cv;
            BlockPos down = blockpos1.func_177977_b();
            return (flag |= level.func_180495_p(down).func_177230_c().canCreatureSpawn(level.func_180495_p(down), (IBlockReader)level, down, EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, CustomEntities.entityCustomNpc)) && !state.func_185897_m() && !state.func_185904_a().func_76224_d() && !level.func_180495_p(pos.func_177984_a()).func_185897_m();
        }
        return false;
    }

    private static BlockPos getTopNonCollidingPos(IWorldReader p_208498_0_, EntityType<?> p_208498_1_, int p_208498_2_, int p_208498_3_) {
        BlockPos blockpos;
        int i = p_208498_0_.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, p_208498_2_, p_208498_3_);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable(p_208498_2_, i, p_208498_3_);
        if (p_208498_0_.func_230315_m_().func_236037_d_()) {
            do {
                blockpos$mutable.func_189536_c(Direction.DOWN);
            } while (!p_208498_0_.func_180495_p((BlockPos)blockpos$mutable).func_196958_f());
            do {
                blockpos$mutable.func_189536_c(Direction.DOWN);
            } while (p_208498_0_.func_180495_p((BlockPos)blockpos$mutable).func_196958_f() && blockpos$mutable.func_177956_o() > 0);
        }
        return p_208498_0_.func_180495_p(blockpos = blockpos$mutable.func_177977_b()).func_196957_g((IBlockReader)p_208498_0_, blockpos, PathType.LAND) ? blockpos : blockpos$mutable.func_185334_h();
    }
}

