/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import java.util.HashMap;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import noppes.npcs.ModelEyeData;
import noppes.npcs.ModelPartConfig;
import noppes.npcs.ModelPartData;
import noppes.npcs.constants.EnumParts;

public class ModelDataShared {
    protected ModelPartConfig arm1 = new ModelPartConfig();
    protected ModelPartConfig arm2 = new ModelPartConfig();
    protected ModelPartConfig body = new ModelPartConfig();
    protected ModelPartConfig leg1 = new ModelPartConfig();
    protected ModelPartConfig leg2 = new ModelPartConfig();
    protected ModelPartConfig head = new ModelPartConfig();
    protected ModelPartData legParts = new ModelPartData("legs");
    public ModelEyeData eyes = new ModelEyeData();
    protected ResourceLocation entityName = null;
    protected LivingEntity entity;
    public CompoundNBT extra = new CompoundNBT();
    protected HashMap<EnumParts, ModelPartData> parts = new HashMap();

    public CompoundNBT save() {
        CompoundNBT compound = new CompoundNBT();
        if (this.entityName != null) {
            compound.func_74778_a("EntityName", this.entityName.toString());
        }
        compound.func_218657_a("ArmsConfig", (INBT)this.arm1.save());
        compound.func_218657_a("BodyConfig", (INBT)this.body.save());
        compound.func_218657_a("LegsConfig", (INBT)this.leg1.save());
        compound.func_218657_a("HeadConfig", (INBT)this.head.save());
        compound.func_218657_a("LegParts", (INBT)this.legParts.save());
        compound.func_218657_a("Eyes", (INBT)this.eyes.save());
        compound.func_218657_a("ExtraData", (INBT)this.extra);
        ListNBT list = new ListNBT();
        for (EnumParts e : this.parts.keySet()) {
            CompoundNBT item = this.parts.get((Object)e).save();
            item.func_74778_a("PartName", e.name);
            list.add((Object)item);
        }
        compound.func_218657_a("Parts", (INBT)list);
        return compound;
    }

    public void load(CompoundNBT compound) {
        this.setEntity(compound.func_74779_i("EntityName"));
        this.arm1.load(compound.func_74775_l("ArmsConfig"));
        this.body.load(compound.func_74775_l("BodyConfig"));
        this.leg1.load(compound.func_74775_l("LegsConfig"));
        this.head.load(compound.func_74775_l("HeadConfig"));
        this.legParts.load(compound.func_74775_l("LegParts"));
        this.eyes.load(compound.func_74775_l("Eyes"));
        this.extra = compound.func_74775_l("ExtraData");
        HashMap<EnumParts, ModelPartData> parts = new HashMap<EnumParts, ModelPartData>();
        ListNBT list = compound.func_150295_c("Parts", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT item = list.func_150305_b(i);
            String name = item.func_74779_i("PartName");
            ModelPartData part = new ModelPartData(name);
            part.load(item);
            EnumParts e = EnumParts.FromName(name);
            if (e == null) continue;
            parts.put(e, part);
        }
        this.parts = parts;
        this.updateTransate();
    }

    private void updateTransate() {
        for (EnumParts part : EnumParts.values()) {
            float y;
            float x;
            ModelPartConfig body;
            ModelPartConfig config = this.getPartConfig(part);
            if (config == null) continue;
            if (part == EnumParts.HEAD) {
                config.setTranslate(0.0f, this.getBodyY(), 0.0f);
                continue;
            }
            if (part == EnumParts.ARM_LEFT) {
                body = this.getPartConfig(EnumParts.BODY);
                x = (1.0f - body.scaleX) * 0.25f + (1.0f - config.scaleX) * 0.075f;
                y = this.getBodyY() + (1.0f - config.scaleY) * -0.1f;
                config.setTranslate(-x, y, 0.0f);
                if (config.notShared) continue;
                ModelPartConfig arm = this.getPartConfig(EnumParts.ARM_RIGHT);
                arm.copyValues(config);
                continue;
            }
            if (part == EnumParts.ARM_RIGHT) {
                body = this.getPartConfig(EnumParts.BODY);
                x = (1.0f - body.scaleX) * 0.25f + (1.0f - config.scaleX) * 0.075f;
                y = this.getBodyY() + (1.0f - config.scaleY) * -0.1f;
                config.setTranslate(x, y, 0.0f);
                continue;
            }
            if (part == EnumParts.LEG_LEFT) {
                config.setTranslate(-(1.0f - config.scaleX) * 0.125f, this.getLegsY(), -(1.0f - config.scaleZ) * 0.00625f);
                if (config.notShared) continue;
                ModelPartConfig leg = this.getPartConfig(EnumParts.LEG_RIGHT);
                leg.copyValues(config);
                continue;
            }
            if (part == EnumParts.LEG_RIGHT) {
                config.setTranslate((1.0f - config.scaleX) * 0.125f, this.getLegsY(), -(1.0f - config.scaleZ) * 0.00625f);
                continue;
            }
            if (part != EnumParts.BODY) continue;
            config.setTranslate(0.0f, this.getBodyY(), 0.0f);
        }
    }

    public void setEntity(String name) {
        this.entityName = name == null || name.isEmpty() ? null : new ResourceLocation(name);
        this.entity = null;
        this.extra = new CompoundNBT();
    }

    public void setEntity(ResourceLocation name) {
        this.entityName = name;
        this.entity = null;
        this.extra = new CompoundNBT();
    }

    public ResourceLocation getEntityName() {
        return this.entityName;
    }

    public boolean hasEntity() {
        return this.entityName != null;
    }

    public float offsetY() {
        if (this.entity == null) {
            return -this.getBodyY();
        }
        return this.entity.func_213302_cg() - 1.8f;
    }

    public void clearEntity() {
        this.entity = null;
    }

    public ModelPartData getPartData(EnumParts type) {
        if (type == EnumParts.LEGS) {
            return this.legParts;
        }
        if (type == EnumParts.EYES) {
            return this.eyes;
        }
        return this.parts.get((Object)type);
    }

    public ModelPartConfig getPartConfig(EnumParts type) {
        if (type == EnumParts.BODY) {
            return this.body;
        }
        if (type == EnumParts.ARM_LEFT) {
            return this.arm1;
        }
        if (type == EnumParts.ARM_RIGHT) {
            return this.arm2;
        }
        if (type == EnumParts.LEG_LEFT) {
            return this.leg1;
        }
        if (type == EnumParts.LEG_RIGHT) {
            return this.leg2;
        }
        return this.head;
    }

    public void removePart(EnumParts type) {
        this.parts.remove((Object)type);
    }

    public ModelPartData getOrCreatePart(EnumParts type) {
        if (type == null) {
            return null;
        }
        if (type == EnumParts.EYES) {
            return this.eyes;
        }
        ModelPartData part = this.getPartData(type);
        if (part == null) {
            part = new ModelPartData(type.name);
            this.parts.put(type, part);
        }
        return part;
    }

    public float getBodyY() {
        return (1.0f - this.body.scaleY) * 0.75f + this.getLegsY();
    }

    public float getLegsY() {
        ModelPartConfig legs = this.leg1;
        if (this.leg2.notShared && this.leg2.scaleY > this.leg1.scaleY) {
            legs = this.leg2;
        }
        return (1.0f - legs.scaleY) * 0.75f;
    }
}

