/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.util;

import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.FluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;

public class RayTrace
implements IBlockReader {
    private static Predicate<Entity> isVisible = entity -> !entity.func_175149_v() && entity.func_70067_L();
    private static Minecraft minecraft = Minecraft.func_71410_x();

    public TileEntity func_175625_s(BlockPos pos) {
        return RayTrace.minecraft.field_71441_e.func_175625_s(pos);
    }

    public BlockState func_180495_p(BlockPos pos) {
        return RayTrace.minecraft.field_71441_e.func_180495_p(pos);
    }

    public FluidState func_204610_c(BlockPos pos) {
        return RayTrace.minecraft.field_71441_e.func_204610_c(pos);
    }

    public LivingEntity getEntityInCrosshair(float partialTicks, double reachDistance) {
        AxisAlignedBB searchBox;
        Minecraft client = Minecraft.func_71410_x();
        Entity viewer = client.func_175606_aa();
        if (viewer == null) {
            return null;
        }
        Vector3d position = viewer.func_174824_e(partialTicks);
        Vector3d look = viewer.func_70676_i(1.0f);
        Vector3d max = position.func_72441_c(look.field_72450_a * reachDistance, look.field_72448_b * reachDistance, look.field_72449_c * reachDistance);
        EntityRayTraceResult result = ProjectileHelper.func_221273_a((Entity)viewer, (Vector3d)position, (Vector3d)max, (AxisAlignedBB)(searchBox = viewer.func_174813_aQ().func_216361_a(look.func_186678_a(reachDistance)).func_72321_a(1.0, 1.0, 1.0)), isVisible, (double)(reachDistance * reachDistance));
        if (result == null || result.func_216348_a() == null) {
            return null;
        }
        if (result.func_216348_a() instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)result.func_216348_a();
            BlockRayTraceResult blockHit = this.func_217299_a(this.setupRayTraceContext((PlayerEntity)client.field_71439_g, reachDistance, RayTraceContext.FluidMode.NONE));
            if (!blockHit.func_216346_c().equals((Object)RayTraceResult.Type.MISS)) {
                double blockDistance = blockHit.func_216347_e().func_72438_d(position);
                if (blockDistance > (double)target.func_70032_d((Entity)client.field_71439_g)) {
                    return target;
                }
            } else {
                return target;
            }
        }
        return null;
    }

    private RayTraceContext setupRayTraceContext(PlayerEntity player, double distance, RayTraceContext.FluidMode fluidHandling) {
        float pitch = player.field_70125_A;
        float yaw = player.field_70177_z;
        Vector3d fromPos = player.func_174824_e(1.0f);
        float float_3 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float float_4 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float float_5 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float xComponent = float_4 * float_5;
        float yComponent = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float zComponent = float_3 * float_5;
        Vector3d toPos = fromPos.func_72441_c((double)xComponent * distance, (double)yComponent * distance, (double)zComponent * distance);
        return new RayTraceContext(fromPos, toPos, RayTraceContext.BlockMode.OUTLINE, fluidHandling, (Entity)player);
    }

    public BlockRayTraceResult func_217299_a(RayTraceContext context) {
        return (BlockRayTraceResult)IBlockReader.func_217300_a((RayTraceContext)context, (c, pos) -> {
            BlockState block = this.func_180495_p((BlockPos)pos);
            if (!block.func_200132_m()) {
                return null;
            }
            VoxelShape blockShape = c.func_222251_a(block, (IBlockReader)this, pos);
            return this.func_217296_a(c.func_222253_b(), c.func_222250_a(), (BlockPos)pos, blockShape, block);
        }, c -> {
            Vector3d v = c.func_222253_b().func_178788_d(c.func_222250_a());
            return BlockRayTraceResult.func_216352_a((Vector3d)c.func_222250_a(), (Direction)Direction.func_210769_a((double)v.field_72450_a, (double)v.field_72448_b, (double)v.field_72449_c), (BlockPos)new BlockPos(c.func_222250_a()));
        });
    }
}

