/*
 * Decompiled with CFR 0.152.
 */
package net.torocraft.torohealth.bars;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.torocraft.torohealth.ToroHealth;
import net.torocraft.torohealth.bars.BarParticle;
import net.torocraft.torohealth.bars.BarStates;

public class BarState {
    public final LivingEntity entity;
    public float health;
    public float previousHealth;
    public float previousHealthDisplay;
    public float previousHealthDelay;
    public int lastDmg;
    public int lastDmgCumulative;
    public float lastHealth;
    public float lastDmgDelay;
    private float animationSpeed = 0.0f;
    private static final float HEALTH_INDICATOR_DELAY = 10.0f;

    public BarState(LivingEntity entity) {
        this.entity = entity;
    }

    public void tick() {
        this.health = Math.min(this.entity.func_110143_aJ(), this.entity.func_110138_aP());
        this.incrementTimers();
        if ((double)this.lastHealth < 0.1) {
            this.reset();
        } else if (this.lastHealth != this.health) {
            this.handleHealthChange();
        } else if (this.lastDmgDelay == 0.0f) {
            this.reset();
        }
        this.updateAnimations();
    }

    private void reset() {
        this.lastHealth = this.health;
        this.lastDmg = 0;
        this.lastDmgCumulative = 0;
    }

    private void incrementTimers() {
        if (this.lastDmgDelay > 0.0f) {
            this.lastDmgDelay -= 1.0f;
        }
        if (this.previousHealthDelay > 0.0f) {
            this.previousHealthDelay -= 1.0f;
        }
    }

    private void handleHealthChange() {
        this.lastDmg = MathHelper.func_76123_f((float)this.lastHealth) - MathHelper.func_76123_f((float)this.health);
        this.lastDmgCumulative += this.lastDmg;
        this.lastDmgDelay = 20.0f;
        this.lastHealth = this.health;
        if (ToroHealth.CONFIG.particle.show) {
            BarStates.PARTICLES.add(new BarParticle((Entity)this.entity, this.lastDmg));
        }
    }

    private void updateAnimations() {
        if (this.previousHealthDelay > 0.0f) {
            float diff = this.previousHealthDisplay - this.health;
            if (diff > 0.0f) {
                this.animationSpeed = diff / 10.0f;
            }
        } else if (this.previousHealthDelay < 1.0f && this.previousHealthDisplay > this.health) {
            this.previousHealthDisplay -= this.animationSpeed;
        } else {
            this.previousHealthDisplay = this.health;
            this.previousHealth = this.health;
            this.previousHealthDelay = 10.0f;
        }
    }
}

