/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.wypi;

import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.api.charactercreator.FactionId;
import xyz.pixelatedw.mineminenomi.api.charactercreator.RaceId;
import xyz.pixelatedw.mineminenomi.api.charactercreator.StyleId;
import xyz.pixelatedw.mineminenomi.api.interactions.Interaction;
import xyz.pixelatedw.mineminenomi.api.morph.MorphInfo;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.QuestId;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class WyRegistry {
    private static HashMap<String, String> langMap = new HashMap();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"mineminenomi");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"mineminenomi");
    public static final DeferredRegister<ContainerType<?>> CONTAINER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"mineminenomi");
    public static final DeferredRegister<AbilityCore<?>> ABILITIES = DeferredRegister.create(ModRegistries.ABILITIES, (String)"mineminenomi");
    public static final DeferredRegister<Effect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"mineminenomi");
    public static final DeferredRegister<Enchantment> ENCHANTMENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENCHANTMENTS, (String)"mineminenomi");
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"mineminenomi");
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"mineminenomi");
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"mineminenomi");
    public static final DeferredRegister<QuestId<?>> QUESTS = DeferredRegister.create(ModRegistries.QUESTS, (String)"mineminenomi");
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"mineminenomi");
    public static final DeferredRegister<FoliagePlacerType<?>> FOLIAGE_PLACER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FOLIAGE_PLACER_TYPES, (String)"mineminenomi");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"mineminenomi");
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"mineminenomi");
    public static final DeferredRegister<ChallengeCore<?>> CHALLENGES = DeferredRegister.create(ModRegistries.CHALLENGES, (String)"mineminenomi");
    public static final DeferredRegister<ParticleEffect<?>> PARTICLE_EFFECTS = DeferredRegister.create(ModRegistries.PARTICLE_EFFECTS, (String)"mineminenomi");
    public static final DeferredRegister<MorphInfo> MORPHS = DeferredRegister.create(ModRegistries.MORPHS, (String)"mineminenomi");
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"mineminenomi");
    public static final DeferredRegister<StyleId> STYLES = DeferredRegister.create(StyleId.class, (String)"mineminenomi");
    public static final DeferredRegister<RaceId> RACES = DeferredRegister.create(RaceId.class, (String)"mineminenomi");
    public static final DeferredRegister<FactionId> FACTIONS = DeferredRegister.create(FactionId.class, (String)"mineminenomi");
    public static final DeferredRegister<Interaction> INTERACTIONS = DeferredRegister.create(ModRegistries.INTERACTIONS, (String)"mineminenomi");

    public static HashMap<String, String> getLangMap() {
        return langMap;
    }

    public static String registerName(String key, String localizedName) {
        WyRegistry.getLangMap().put(key, localizedName);
        return key;
    }

    public static TranslationTextComponent registerTextComponent(String key, String localizedName) {
        return new TranslationTextComponent(WyRegistry.registerName(key, localizedName));
    }

    public static <T extends MorphInfo> RegistryObject<T> registerMorph(String resourceName, Supplier<T> morph) {
        RegistryObject reg = MORPHS.register(resourceName, morph);
        return reg;
    }

    public static <T extends Interaction> RegistryObject<T> registerInteraction(String resourceName, Supplier<T> morph) {
        RegistryObject reg = INTERACTIONS.register(resourceName, morph);
        return reg;
    }

    public static <T extends Biome> RegistryObject<T> registerBiome(String localizedName, Supplier<T> biome) {
        String resourceName = WyHelper.getResourceName(localizedName);
        WyRegistry.getLangMap().put("biome.mineminenomi." + resourceName, localizedName);
        RegistryObject reg = BIOMES.register(resourceName, biome);
        return reg;
    }

    public static <T extends ParticleEffect<?>> RegistryObject<T> registerParticleEffect(String localizedName, Supplier<T> attr) {
        String resourceName = WyHelper.getResourceName(localizedName);
        RegistryObject reg = PARTICLE_EFFECTS.register("particle_effect.mineminenomi." + resourceName, attr);
        return reg;
    }

    public static RegistryObject<Attribute> registerAttribute(String localizedName, Supplier<Attribute> attr) {
        String resourceName = WyHelper.getResourceName(localizedName);
        WyRegistry.getLangMap().put("attribute.name.generic.mineminenomi." + resourceName, localizedName);
        RegistryObject reg = ATTRIBUTES.register("generic." + resourceName, attr);
        return reg;
    }

    public static <T extends ParticleType<?>> RegistryObject<T> registerParticleType(String localizedName, Supplier<T> type) {
        String resourceName = WyHelper.getResourceName(localizedName);
        RegistryObject reg = PARTICLE_TYPES.register(resourceName, type);
        return reg;
    }

    public static <T extends Feature<?>> RegistryObject<T> registerFeature(String localizedName, Supplier<T> feature) {
        String resourceName = WyHelper.getResourceName(localizedName);
        RegistryObject reg = FEATURES.register(resourceName, feature);
        return reg;
    }

    public static <T extends FoliagePlacerType<?>> RegistryObject<T> registerFoliagePlacer(String localizedName, Supplier<T> feature) {
        String resourceName = WyHelper.getResourceName(localizedName);
        RegistryObject reg = FOLIAGE_PLACER_TYPES.register(resourceName, feature);
        return reg;
    }

    public static <T extends Effect> RegistryObject<T> registerEffect(String localizedName, Supplier<T> effect) {
        String resourceName = WyHelper.getResourceName(localizedName);
        return WyRegistry.registerEffect(localizedName, resourceName, effect);
    }

    public static <T extends Effect> RegistryObject<T> registerEffect(String localizedName, String resourceKey, Supplier<T> effect) {
        String resourceName = WyHelper.getResourceName(resourceKey);
        WyRegistry.getLangMap().put("effect.mineminenomi." + resourceName, localizedName);
        RegistryObject reg = EFFECTS.register(resourceName, effect);
        return reg;
    }

    public static <T extends Enchantment> RegistryObject<T> registerEnchantment(String localizedName, Supplier<T> enchantment) {
        String resourceName = WyHelper.getResourceName(localizedName);
        WyRegistry.getLangMap().put("enchantment.mineminenomi." + resourceName, localizedName);
        RegistryObject reg = ENCHANTMENTS.register(resourceName, enchantment);
        return reg;
    }

    public static <T extends Quest> QuestId<T> registerQuest(QuestId<T> quest) {
        String resourceName = WyHelper.getResourceName(quest.getName());
        WyRegistry.getLangMap().put("quest.mineminenomi." + resourceName, quest.getName());
        ResourceLocation key = new ResourceLocation("mineminenomi", resourceName);
        RegistryObject ret = RegistryObject.of((ResourceLocation)key, ModRegistries.QUESTS);
        if (!QUESTS.getEntries().contains(ret)) {
            QUESTS.register(resourceName, () -> quest);
        }
        return quest;
    }

    public static <T extends IAbility> AbilityCore<T> registerAbility(AbilityCore<T> core) {
        String resourceName = WyHelper.getResourceName(core.getId());
        ResourceLocation key = new ResourceLocation("mineminenomi", resourceName);
        WyRegistry.getLangMap().put("ability.mineminenomi." + resourceName, core.getUnlocalizedName());
        RegistryObject ret = RegistryObject.of((ResourceLocation)key, ModRegistries.ABILITIES);
        if (!ABILITIES.getEntries().contains(ret)) {
            ABILITIES.register(resourceName, () -> core);
            if (core.getIcon() == null) {
                core.setIcon(new ResourceLocation(key.func_110624_b(), "textures/abilities/" + key.func_110623_a() + ".png"));
            }
        }
        return core;
    }

    public static RegistryObject<SoundEvent> registerSound(String localizedName) {
        String resourceName = WyHelper.getResourceName(localizedName);
        WyRegistry.getLangMap().put("mineminenomi.subtitle." + resourceName, localizedName);
        SoundEvent sound = new SoundEvent(new ResourceLocation("mineminenomi", resourceName));
        RegistryObject reg = SOUNDS.register(resourceName, () -> sound);
        return reg;
    }

    public static <T extends Item> RegistryObject<T> registerItem(String localizedName, Supplier<T> item) {
        String resourceName = WyHelper.getResourceName(localizedName);
        WyRegistry.getLangMap().put("item.mineminenomi." + resourceName, localizedName);
        RegistryObject reg = ITEMS.register(resourceName, item);
        return reg;
    }

    public static RegistryObject<ForgeSpawnEggItem> registerSpawnEggItem(String localizedEntityName, Supplier<ForgeSpawnEggItem> supp) {
        String entityResName = WyHelper.getResourceName(localizedEntityName);
        String resourceName = entityResName + "_spawn_egg";
        String localizedName = "Spawn " + localizedEntityName;
        WyRegistry.getLangMap().put("item.mineminenomi." + resourceName, localizedName);
        RegistryObject reg = ITEMS.register(resourceName, supp);
        return reg;
    }

    public static <T extends Block> RegistryObject<T> registerBlock(String localizedName, Supplier<T> block) {
        return WyRegistry.registerBlock(localizedName, block, (ItemGroup)null);
    }

    public static <T extends Block> RegistryObject<T> registerBlock(String localizedName, Supplier<T> block, @Nullable ItemGroup tab) {
        Item.Properties blockItemProps = new Item.Properties();
        if (tab != null) {
            blockItemProps.func_200916_a(tab);
        }
        return WyRegistry.registerBlock(localizedName, block, blockItemProps);
    }

    public static <T extends Block> RegistryObject<T> registerBlock(String localizedName, Supplier<T> block, Item.Properties props) {
        String resourceName = WyHelper.getResourceName(localizedName);
        WyRegistry.getLangMap().put("block.mineminenomi." + resourceName, localizedName);
        RegistryObject reg = BLOCKS.register(resourceName, block);
        WyRegistry.registerItem(localizedName, () -> new BlockItem((Block)reg.get(), props));
        return reg;
    }

    public static <T extends Block> RegistryObject<T> registerBlock(String localizedName, Supplier<T> block, Function<T, BlockItem> blockItemFunc) {
        String resourceName = WyHelper.getResourceName(localizedName);
        WyRegistry.getLangMap().put("block.mineminenomi." + resourceName, localizedName);
        RegistryObject reg = BLOCKS.register(resourceName, block);
        WyRegistry.registerItem(localizedName, () -> (BlockItem)blockItemFunc.apply(reg.get()));
        return reg;
    }

    public static <T extends Block> RegistryObject<T> registerBlockOnly(String localizedName, Supplier<T> block) {
        String resourceName = WyHelper.getResourceName(localizedName);
        WyRegistry.getLangMap().put("block.mineminenomi." + resourceName, localizedName);
        RegistryObject reg = BLOCKS.register(resourceName, block);
        return reg;
    }

    public static <C extends Container> RegistryObject<ContainerType<C>> registerContainer(String localizedName, IContainerFactory<C> containerFactory) {
        String resourceName = WyHelper.getResourceName(localizedName);
        WyRegistry.getLangMap().put("container.mineminenomi." + resourceName, localizedName);
        RegistryObject reg = CONTAINER_TYPES.register(resourceName, () -> IForgeContainerType.create((IContainerFactory)containerFactory));
        return reg;
    }

    public static RegistryObject<TileEntityType<?>> registerTileEntity(String localizedName, Supplier<TileEntity> factory, Block ... blocks) {
        String resourceName = WyHelper.getResourceName(localizedName);
        TileEntityType type = TileEntityType.Builder.func_223042_a(factory, (Block[])blocks).func_206865_a(null);
        RegistryObject reg = TILE_ENTITIES.register(resourceName, () -> type);
        return reg;
    }

    public static <T extends Entity> EntityType.Builder<T> createFastEntityType(EntityType.IFactory<T> factory) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)EntityClassification.MISC);
        builder.setTrackingRange(128).setShouldReceiveVelocityUpdates(true).setUpdateInterval(3).func_220321_a(0.6f, 1.8f);
        return builder;
    }

    public static <T extends Entity> EntityType.Builder createEntityType(EntityType.IFactory<T> factory) {
        return WyRegistry.createEntityType(factory, EntityClassification.MISC);
    }

    public static <T extends Entity> EntityType.Builder createEntityType(EntityType.IFactory<T> factory, EntityClassification classification) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a(factory, (EntityClassification)classification);
        builder.setTrackingRange(10).setShouldReceiveVelocityUpdates(true).setUpdateInterval(1).func_220321_a(0.6f, 1.8f);
        return builder;
    }

    public static <T extends Entity> RegistryObject<EntityType<T>> registerEntityType(String localizedName, Supplier<EntityType<T>> supp) {
        String resourceName = WyHelper.getResourceName(localizedName);
        WyRegistry.getLangMap().put("entity.mineminenomi." + resourceName, localizedName);
        RegistryObject reg = ENTITY_TYPES.register(resourceName, supp);
        return reg;
    }

    public static <T extends Entity> RegistryObject<EntityType<T>> registerEntityType(String localizedName, String resourceName, Supplier<EntityType<T>> supp) {
        WyRegistry.getLangMap().put("entity.mineminenomi." + resourceName, localizedName);
        RegistryObject reg = ENTITY_TYPES.register(resourceName, supp);
        return reg;
    }

    public static <T extends Entity> void registerEntityType(EntityType<T> type, String localizedName) {
        String resourceName = WyHelper.getResourceName(localizedName);
        WyRegistry.getLangMap().put("entity.mineminenomi." + resourceName, localizedName);
    }

    public static <I extends RaceId> RegistryObject<I> registerRace(String localizedName, Supplier<I> race) {
        String resourceName = WyHelper.getResourceName(localizedName);
        WyRegistry.getLangMap().put("race.mineminenomi." + resourceName, localizedName);
        RegistryObject reg = RACES.register(resourceName, race);
        return reg;
    }

    public static <I extends FactionId> RegistryObject<I> registerFaction(String localizedName, Supplier<I> faction) {
        String resourceName = WyHelper.getResourceName(localizedName);
        return WyRegistry.registerFaction(resourceName, localizedName, faction);
    }

    public static <I extends FactionId> RegistryObject<I> registerFaction(String id, String localizedName, Supplier<I> faction) {
        WyRegistry.getLangMap().put("faction.mineminenomi." + id, localizedName);
        RegistryObject reg = FACTIONS.register(id, faction);
        return reg;
    }

    public static <I extends StyleId> RegistryObject<I> registerStyle(String localizedName, Supplier<I> style) {
        String resourceName = WyHelper.getResourceName(localizedName);
        WyRegistry.getLangMap().put("style.mineminenomi." + resourceName, localizedName);
        RegistryObject reg = STYLES.register(resourceName, style);
        return reg;
    }
}

