/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.wypi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class WyPatreon {
    public static final HashMap<UUID, List<AccountType>> PATREONS = new HashMap();
    public static final BuildMode BUILD_MODE = BuildMode.RELEASE;

    public static boolean isDevBuild() {
        return BUILD_MODE == BuildMode.DEV;
    }

    public static boolean isEarlyAccessBuild() {
        return BUILD_MODE == BuildMode.EARLY_ACCESS;
    }

    public static boolean isPublicQABuild() {
        return BUILD_MODE == BuildMode.PUBLIC_QA;
    }

    public static boolean isReleaseBuild() {
        return BUILD_MODE == BuildMode.RELEASE;
    }

    public static boolean isQABuild() {
        return BUILD_MODE == BuildMode.QA;
    }

    public static boolean isPromoBuild() {
        return BUILD_MODE == BuildMode.PROMO;
    }

    @Nullable
    private static List<AccountType> getPatreonLevel(PlayerEntity player) throws IOException {
        String apiURL = "/patreon/" + player.func_110124_au().toString();
        String[] result = (String[])WyHelper.sendGET(apiURL, String[].class);
        if (result != null && result.length > 0) {
            ArrayList<AccountType> types = new ArrayList<AccountType>();
            for (String group : result) {
                String formattedGroupName = WyHelper.getResourceName(group);
                if (formattedGroupName.equalsIgnoreCase("patreon_rookie")) {
                    types.add(AccountType.ROOKIE);
                }
                if (formattedGroupName.equalsIgnoreCase("patreon_supernova")) {
                    types.add(AccountType.SUPERNOVA);
                }
                if (formattedGroupName.equalsIgnoreCase("patreon_celestial_dragon")) {
                    types.add(AccountType.CELESTIAL_DRAGON);
                }
                if (!formattedGroupName.equalsIgnoreCase("mine_mine_no_mi_qateam")) continue;
                types.add(AccountType.TESTER);
            }
            return types;
        }
        return null;
    }

    public static boolean isCelestialDragon(PlayerEntity player) {
        if (!PATREONS.containsKey(player.func_110124_au())) {
            return false;
        }
        List<AccountType> accountInfo = PATREONS.get(player.func_110124_au());
        boolean hasType = accountInfo != null && accountInfo.contains((Object)AccountType.CELESTIAL_DRAGON);
        return hasType;
    }

    public static boolean isSupernova(PlayerEntity player) {
        if (!PATREONS.containsKey(player.func_110124_au())) {
            return false;
        }
        List<AccountType> accountInfo = PATREONS.get(player.func_110124_au());
        boolean hasType = accountInfo != null && accountInfo.contains((Object)AccountType.SUPERNOVA);
        return hasType || WyPatreon.isCelestialDragon(player);
    }

    public static boolean isTester(PlayerEntity player) {
        if (!PATREONS.containsKey(player.func_110124_au())) {
            return false;
        }
        List<AccountType> accountInfo = PATREONS.get(player.func_110124_au());
        boolean hasType = accountInfo != null && accountInfo.contains((Object)AccountType.TESTER);
        return hasType;
    }

    public static boolean isRookie(PlayerEntity player) {
        if (!PATREONS.containsKey(player.func_110124_au())) {
            return false;
        }
        List<AccountType> accountInfo = PATREONS.get(player.func_110124_au());
        boolean hasType = accountInfo != null && accountInfo.contains((Object)AccountType.ROOKIE);
        return hasType || WyPatreon.isSupernova(player) || WyPatreon.isCelestialDragon(player);
    }

    public static boolean hasPatreonAccess(PlayerEntity player) {
        if (WyPatreon.isDevBuild() && WyPatreon.isCelestialDragon(player)) {
            return true;
        }
        if (WyPatreon.isQABuild() && WyPatreon.isTester(player)) {
            return true;
        }
        return WyPatreon.isEarlyAccessBuild() && WyPatreon.isSupernova(player);
    }

    public static boolean isPublicQAPeriod() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        if (year != 2025) {
            return false;
        }
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        return month == 5;
    }

    public static class PatreonEvents {
        private static final ITextComponent NO_ACCESS_MESSAGE = new StringTextComponent("\u00a7c\u00a7lWARNING!\u00a7r \n\nYou don't have access to this version yet!");
        private static final ITextComponent PUBLIC_TESTING_ENDED_MESSAGE = new StringTextComponent("\u00a7c\u00a7lWARNING!\u00a7r \n\nPublic testing access for this build has ended, please download the actual release!");

        @SubscribeEvent
        public void onEntityJoinWorld(EntityJoinWorldEvent event) {
            if (!(event.getEntity() instanceof PlayerEntity) || event.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            if (WyPatreon.isPublicQABuild()) {
                if (!WyPatreon.isPublicQAPeriod()) {
                    event.setCanceled(true);
                    player.field_71135_a.func_194028_b(PUBLIC_TESTING_ENDED_MESSAGE);
                }
                return;
            }
            if (WyPatreon.isReleaseBuild() || WyPatreon.isDevBuild() && WyDebug.isDebug()) {
                return;
            }
            if (WyPatreon.isPromoBuild() && player.func_184102_h().func_71262_S()) {
                return;
            }
            if (PATREONS.containsKey(player.func_110124_au())) {
                List<AccountType> accountInfo = PATREONS.get(player.func_110124_au());
                if (accountInfo == null || accountInfo.isEmpty()) {
                    event.setCanceled(true);
                    player.field_71135_a.func_194028_b(NO_ACCESS_MESSAGE);
                    return;
                }
                if (WyPatreon.hasPatreonAccess((PlayerEntity)player)) {
                    return;
                }
            }
            List patreonLevels = null;
            try {
                patreonLevels = WyPatreon.getPatreonLevel((PlayerEntity)player);
            }
            catch (IOException e) {
                e.printStackTrace();
                event.setCanceled(true);
                player.field_71135_a.func_194028_b(NO_ACCESS_MESSAGE);
                return;
            }
            PATREONS.put(player.func_110124_au(), patreonLevels);
            if (patreonLevels == null || patreonLevels.isEmpty() || !WyPatreon.hasPatreonAccess((PlayerEntity)player)) {
                event.setCanceled(true);
                player.field_71135_a.func_194028_b(NO_ACCESS_MESSAGE);
                return;
            }
        }
    }

    public static enum AccountType {
        NORMAL,
        ROOKIE,
        SUPERNOVA,
        CELESTIAL_DRAGON,
        TESTER;

    }

    public static enum BuildMode {
        RELEASE,
        DEV,
        EARLY_ACCESS,
        QA,
        PROMO,
        PUBLIC_QA;

    }
}

