/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.wypi;

import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.loading.FMLEnvironment;
import xyz.pixelatedw.mineminenomi.commands.FGCommand;

public class WyDebug {
    public static final HashMap<EntityType, Long> ENTITY_COUNTER = new HashMap();
    public static final Set<Long> PARTICLE_PACKETS = new HashSet<Long>();
    private static final DecimalFormat TIME_FORMATTER = new DecimalFormat("########0.000");
    private static Logger logger = Logger.getLogger("mineminenomi");

    public static boolean isDebug() {
        return !FMLEnvironment.production || ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
    }

    public static String getCallerClassName() {
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        for (int i = 1; i < stElements.length; ++i) {
            StackTraceElement ste = stElements[i];
            if (ste.getClassName().equals(WyDebug.class.getName()) || ste.getClassName().indexOf("java.lang.Thread") == 0) continue;
            return ste.getClassName();
        }
        return null;
    }

    public static void printStackTrace() {
        if (!WyDebug.isDebug()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("==========THIS IS NOT AN ERROR, ITS DEBUG TEXT============\n");
        StackTraceElement[] stElements = Thread.currentThread().getStackTrace();
        for (int i = 1; i < stElements.length; ++i) {
            StackTraceElement ste = stElements[i];
            sb.append(ste.toString() + "\n");
        }
        sb.append("==========END DEBUG TEXT============\n");
        System.out.println(sb.toString());
    }

    public static void debug(Object msg) {
        if (WyDebug.isDebug()) {
            logger.log(Level.INFO, WyDebug.getCallerClassName() + ": " + String.valueOf(msg));
        }
    }

    public static void countEntity(MobEntity entity) {
        EntityType type = entity.func_200600_R();
        if (ENTITY_COUNTER.containsKey(type)) {
            long v = ENTITY_COUNTER.get(type) + 1L;
            ENTITY_COUNTER.replace(type, v);
        } else {
            ENTITY_COUNTER.put(type, 1L);
        }
    }

    public static void trackPacket() {
        if (!WyDebug.isDebug()) {
            return;
        }
        PARTICLE_PACKETS.add(System.nanoTime());
    }

    public static void showTPSInChat(PlayerEntity player) {
        if (WyDebug.isDebug() && FGCommand.SHOW_TPS && !player.field_70170_p.field_72995_K) {
            RegistryKey dim = World.field_234918_g_;
            long[] times = player.func_184102_h().getTickTime(dim);
            if (times == null) {
                times = new long[]{0L};
            }
            long sum = 0L;
            for (long v : times) {
                sum += v;
            }
            double worldTickTime = (double)(sum / (long)times.length) * 1.0E-6;
            double worldTPS = Math.min(1000.0 / worldTickTime, 20.0);
            if (worldTPS < 19.0) {
                String color = "\u00a72";
                if (worldTPS >= 15.0 && worldTPS < 18.0) {
                    color = "\u00a7a";
                } else if (worldTPS >= 10.0 && worldTPS < 15.0) {
                    color = "\u00a76";
                } else if (worldTPS >= 5.0 && worldTPS < 10.0) {
                    color = "\u00a7d";
                } else if (worldTPS < 5.0) {
                    color = "\u00a7c";
                }
                player.func_145747_a((ITextComponent)new TranslationTextComponent("commands.forge.tps.summary.all", new Object[]{color + " " + TIME_FORMATTER.format(worldTickTime), TIME_FORMATTER.format(worldTPS)}), Util.field_240973_b_);
            }
        }
    }
}

