/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.spawners;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.entities.TraderEntity;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class TraderSpawner {
    private Random random = new Random();
    private int cooldown;
    private static final List<Supplier<? extends EntityType<?>>> TRADER_TYPES = Arrays.asList(ModEntities.MARINE_TRADER, ModEntities.PIRATE_TRADER);

    public void tick(ServerWorld world) {
        world.func_217381_Z().func_76320_a("traderSpawnerTick");
        if (--this.cooldown <= 0) {
            this.cooldown = CommonConfig.INSTANCE.getTimeBetweenTraderSpawns();
            if (this.random.nextInt(100) <= CommonConfig.INSTANCE.getChanceForTraderSpawn()) {
                this.spawn(world);
            }
        }
        world.func_217381_Z().func_76319_b();
    }

    private void spawn(ServerWorld world) {
        world.func_217381_Z().func_76320_a("traderSpawnerSpawn");
        int listSize = MathHelper.func_76125_a((int)(world.func_217369_A().size() / 3), (int)1, (int)10);
        PlayerEntity[] cachedPlayers = new PlayerEntity[listSize];
        for (int i = 0; i < cachedPlayers.length; ++i) {
            boolean canSpawnInBiome;
            boolean alreadyCached;
            ServerPlayerEntity player = world.func_217472_l_();
            if (player == null || (alreadyCached = Arrays.stream(cachedPlayers).anyMatch(arg_0 -> TraderSpawner.lambda$spawn$0((PlayerEntity)player, arg_0)))) continue;
            cachedPlayers[i] = player;
            int r = this.random.nextInt(TRADER_TYPES.size());
            EntityType<?> entityType = TRADER_TYPES.get(r).get();
            BlockPos targetPos = player.func_233580_cy_();
            BlockPos spawnPos = WyHelper.findOnGroundSpawnLocation((World)world, entityType, targetPos, 20);
            List traders = WyHelper.getNearbyEntities(player.func_213303_ch(), (IWorld)world, 40.0, null, TraderEntity.class);
            if (spawnPos == null) {
                return;
            }
            boolean bl = canSpawnInBiome = world.func_226691_t_(targetPos).func_201856_r() != Biome.Category.OCEAN;
            if (traders.size() >= 3 || !canSpawnInBiome) continue;
            entityType.func_220342_a(world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, spawnPos, SpawnReason.EVENT, false, false);
            WyDebug.debug("Trader (" + entityType + ") spawned at: " + spawnPos);
        }
        world.func_217381_Z().func_76319_b();
    }

    private static /* synthetic */ boolean lambda$spawn$0(PlayerEntity player, PlayerEntity target) {
        return target == player;
    }
}

