/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.features.trees;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;
import xyz.pixelatedw.mineminenomi.init.ModFeatures;

public class SabaodyTrunkPlacer
extends AbstractTrunkPlacer {
    public static final Codec<SabaodyTrunkPlacer> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.intRange((int)0, (int)64).fieldOf("base_height").forGetter(placer -> placer.field_236906_d_), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_a").forGetter(placer -> placer.field_236907_e_), (App)Codec.intRange((int)0, (int)24).fieldOf("height_rand_b").forGetter(placer -> placer.field_236908_f_), (App)Codec.BOOL.fieldOf("is_chonky").forGetter(placer -> placer.isChonky)).apply((Applicative)inst, SabaodyTrunkPlacer::new));
    private boolean isChonky;
    private int width = 2;

    public SabaodyTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, boolean isChonky) {
        super(baseHeight, heightRandA, heightRandB);
        this.isChonky = isChonky;
        this.width = this.isChonky ? 5 : 2;
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return ModFeatures.SABAODY_TRUNK_PLACER;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader world, Random rand, int height, BlockPos pos, Set<BlockPos> set, MutableBoundingBox bb, BaseTreeFeatureConfig config) {
        ArrayList list = Lists.newArrayList();
        list.addAll(this.placeTrunkCustom(world, rand, height, pos, set, bb, config));
        for (int i = 0; i < height / 2; i += 2 + rand.nextInt(1)) {
            float f = rand.nextFloat() * ((float)Math.PI * 2);
            int j = 0;
            int k = 0;
            double rootLength = (this.isChonky ? 10 : 5) + rand.nextInt(5);
            for (int l = 0; l < (this.isChonky ? 70 : 40); ++l) {
                double x = Math.min((double)l, rootLength);
                j = (int)(0.5 + (double)MathHelper.func_76134_b((float)f) * x);
                k = (int)(0.5 + (double)MathHelper.func_76126_a((float)f) * x);
                BlockPos blockpos = pos.func_177982_a(j, i - 3 - l / 2, k);
                SabaodyTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)blockpos, set, (MutableBoundingBox)bb, (BaseTreeFeatureConfig)config);
                SabaodyTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)blockpos.func_177974_f(), set, (MutableBoundingBox)bb, (BaseTreeFeatureConfig)config);
                SabaodyTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)blockpos.func_177976_e(), set, (MutableBoundingBox)bb, (BaseTreeFeatureConfig)config);
                SabaodyTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)blockpos.func_177984_a(), set, (MutableBoundingBox)bb, (BaseTreeFeatureConfig)config);
                SabaodyTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)blockpos.func_177978_c(), set, (MutableBoundingBox)bb, (BaseTreeFeatureConfig)config);
                SabaodyTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)blockpos.func_177968_d(), set, (MutableBoundingBox)bb, (BaseTreeFeatureConfig)config);
                SabaodyTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos)blockpos.func_177977_b(), set, (MutableBoundingBox)bb, (BaseTreeFeatureConfig)config);
            }
        }
        return list;
    }

    public List<FoliagePlacer.Foliage> placeTrunkCustom(IWorldGenerationReader world, Random rand, int height, BlockPos pos, Set<BlockPos> set, MutableBoundingBox bb, BaseTreeFeatureConfig config) {
        BlockPos.Mutable mutpos = new BlockPos.Mutable();
        for (int i = 0; i < height; ++i) {
            SabaodyTrunkPlacer.placeLogIfFreeWithOffset(world, rand, mutpos, set, bb, config, pos, 0, i, 0);
            if (i >= height - 1) continue;
            for (int xSize = -this.width; xSize <= this.width; ++xSize) {
                for (int zSize = -this.width; zSize <= this.width; ++zSize) {
                    int distance = Math.max(Math.abs(xSize), Math.abs(zSize));
                    if (distance > this.width || xSize == 0 && zSize == 0) continue;
                    SabaodyTrunkPlacer.placeLogIfFreeWithOffset(world, rand, mutpos, set, bb, config, pos, xSize, i, zSize);
                }
            }
        }
        return ImmutableList.of((Object)new FoliagePlacer.Foliage(pos.func_177981_b(height - (this.isChonky ? 0 : 2)), 0, true));
    }

    private static void placeLogIfFreeWithOffset(IWorldGenerationReader world, Random rand, BlockPos.Mutable mutpos, Set<BlockPos> set, MutableBoundingBox bb, BaseTreeFeatureConfig config, BlockPos pos, int x, int y, int z) {
        mutpos.func_239621_a_((Vector3i)pos, x, y, z);
        SabaodyTrunkPlacer.func_236910_a_((IWorldGenerationReader)world, (Random)rand, (BlockPos.Mutable)mutpos, set, (MutableBoundingBox)bb, (BaseTreeFeatureConfig)config);
    }
}

