/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.features.structures.smallbase.marine;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xyz.pixelatedw.mineminenomi.api.WantedPosterData;
import xyz.pixelatedw.mineminenomi.api.enums.CanvasSize;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.blocks.FlagBlock;
import xyz.pixelatedw.mineminenomi.blocks.WantedPosterBlock;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.FlagTileEntity;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.WantedPosterTileEntity;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModLootTables;
import xyz.pixelatedw.mineminenomi.init.ModStructures;
import xyz.pixelatedw.mineminenomi.init.ModValues;

public class MarineSmallBasePiece
extends TemplateStructurePiece {
    private ResourceLocation resourceLocation;
    private Rotation rotation;
    private Set<UUID> posters = new HashSet<UUID>();

    public MarineSmallBasePiece(TemplateManager template, CompoundNBT nbt) {
        super(ModStructures.Pieces.MARINE_SMALL_BASE_PIECE, nbt);
        this.resourceLocation = new ResourceLocation(nbt.func_74779_i("Template"));
        this.rotation = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
        this.build(template);
    }

    public MarineSmallBasePiece(TemplateManager template, BlockPos pos, Rotation rot) {
        super(ModStructures.Pieces.MARINE_SMALL_BASE_PIECE, 0);
        this.field_186178_c = pos;
        this.rotation = rot;
        this.resourceLocation = new ResourceLocation("mineminenomi", "marine/small_base");
        this.build(template);
    }

    protected void func_143011_b(CompoundNBT nbt) {
        super.func_143011_b(nbt);
        nbt.func_74778_a("Template", this.resourceLocation.toString());
        nbt.func_74778_a("Rot", this.rotation.name());
    }

    private void build(TemplateManager templateManager) {
        Template template = templateManager.func_200220_a(this.resourceLocation);
        PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
        this.func_186173_a(template, this.field_186178_c, placementsettings);
    }

    protected void func_186175_a(String function, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox sbb) {
        if (function.equals("captain_chest")) {
            StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.SMALL_MARINE_BASE_CAPTAIN_CHEST);
        }
        if (function.equals("dorm_supplies")) {
            StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.SMALL_MARINE_BASE_DORM_CHEST);
        }
        if (function.equals("food_supplies")) {
            StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.SMALL_MARINE_BASE_FOOD_CHEST);
        }
        if (function.equals("desk_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.GRUNT, 1);
        }
        if (function.equals("main_hall_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.GRUNT, 5);
        }
        if (function.equals("bedrooms_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.BRUTE, 3);
        }
        if (function.equals("upstairs_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.GRUNT, 5);
        }
        if (function.equals("captain_room_spawn")) {
            StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.CAPTAIN, 1);
        }
        Rotation rot = this.field_186177_b.func_186215_c();
        if (function.startsWith("wanted_poster_")) {
            ExtendedWorldData worldData = ExtendedWorldData.get();
            Optional<Map.Entry<UUID, Long>> bounty = worldData.getAllBounties().entrySet().stream().findAny();
            String[] funcSplt = function.split("_");
            int id = -1;
            try {
                id = Integer.parseInt(funcSplt[2]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (id >= 0) {
                if (id <= 5) {
                    this.generateWantedPoster(world, pos, rot, Direction.NORTH, bounty);
                } else if (id > 5 && id <= 10) {
                    this.generateWantedPoster(world, pos, rot, Direction.SOUTH, bounty);
                } else if (id == 11 || id == 12) {
                    this.generateWantedPoster(world, pos, rot, Direction.SOUTH, bounty);
                } else if (id == 13) {
                    this.generateWantedPoster(world, pos, rot, Direction.WEST, bounty);
                }
            }
        }
        if (function.equals("flag")) {
            BlockState state = ((Block)ModBlocks.FLAG.get()).func_176223_P();
            state = (BlockState)state.func_206870_a((Property)WantedPosterBlock.FACING, (Comparable)rot.func_185831_a(Direction.EAST));
            state = (BlockState)state.func_206870_a(FlagBlock.SIZE, (Comparable)((Object)CanvasSize.HUGE));
            world.func_180501_a(pos, state, 3);
            FlagBlock.placeSubs((IWorld)world, pos, state, false);
            TileEntity flagTile = world.func_175625_s(pos);
            if (flagTile != null && flagTile instanceof FlagTileEntity) {
                ((FlagTileEntity)flagTile).setFaction(ModValues.MARINE);
            }
        }
    }

    private void generateWantedPoster(IServerWorld world, BlockPos pos, Rotation rot, Direction dir, Optional<Map.Entry<UUID, Long>> bounty) {
        if (world.func_201670_d()) {
            return;
        }
        if (!world.func_201674_k().nextBoolean()) {
            return;
        }
        if (bounty.isPresent()) {
            UUID key = bounty.get().getKey();
            PlayerEntity player = world.func_217371_b(key);
            if (this.posters.contains(key) || player == null) {
                world.func_180501_a(pos, ((Block)ModBlocks.STRUCTURE_AIR.get()).func_176223_P(), 3);
                return;
            }
            WantedPosterData wantedPosterData = new WantedPosterData((LivingEntity)player, bounty.get().getValue());
            BlockState state = ((Block)ModBlocks.WANTED_POSTER.get()).func_176223_P();
            state = (BlockState)state.func_206870_a((Property)WantedPosterBlock.FACING, (Comparable)rot.func_185831_a(dir));
            world.func_180501_a(pos, state, 2);
            TileEntity tile = world.func_175625_s(pos);
            if (tile instanceof WantedPosterTileEntity) {
                ((WantedPosterTileEntity)tile).setWantedPosterData(wantedPosterData);
                tile.func_70296_d();
            }
            this.posters.add(key);
        } else {
            world.func_180501_a(pos, ((Block)ModBlocks.STRUCTURE_AIR.get()).func_176223_P(), 3);
        }
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager pStructureManager, ChunkGenerator pChunkGenerator, Random pRandom, MutableBoundingBox pBox, ChunkPos pChunkPos, BlockPos pPos) {
        boolean flag = super.func_230383_a_(world, pStructureManager, pChunkGenerator, pRandom, pBox, pChunkPos, pPos);
        return flag;
    }
}

