/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.features.structures.smallbase.bandit;

import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.init.ModBiomes;
import xyz.pixelatedw.mineminenomi.world.features.structures.OPStructure;
import xyz.pixelatedw.mineminenomi.world.features.structures.smallbase.bandit.BanditSmallBasePieces;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BanditSmallBaseStructure
extends OPStructure<NoFeatureConfig> {
    public BanditSmallBaseStructure() {
        super(NoFeatureConfig.field_236558_a_);
    }

    @Override
    public boolean biomeCheck(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.OCEAN) {
            return false;
        }
        if (event.getName() == null) {
            return false;
        }
        if (event.getName().equals((Object)((Biome)ModBiomes.RAIGO.get()).getRegistryName())) {
            return false;
        }
        boolean canSpawn = CommonConfig.INSTANCE.canSpawnSmallBases();
        return canSpawn;
    }

    @Override
    public StructuresHelper.StructureFaction getFaction() {
        return StructuresHelper.StructureFaction.NEUTRAL;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig featureConfig) {
        boolean isChance;
        boolean superFlag = super.func_230363_a_(chunkGenerator, biomeSource, seed, chunkRandom, chunkX, chunkZ, biome, chunkPos, featureConfig);
        boolean bl = isChance = MathHelper.func_151237_a((double)(WyHelper.randomWithRange((Random)chunkRandom, 0, 100) + WyHelper.randomDouble((Random)chunkRandom)), (double)0.0, (double)100.0) < CommonConfig.INSTANCE.getChanceForLargeBasesSpawn();
        if (!superFlag || !isChance) {
            return false;
        }
        boolean isFlatGround = WyHelper.isSurfaceFlat(chunkGenerator, chunkX + 1, chunkZ + 2, 2);
        return isFlatGround;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    public static class Start
    extends StructureStart<NoFeatureConfig> {
        public Start(Structure<NoFeatureConfig> structure, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int reference, long seed) {
            super(structure, chunkX, chunkZ, mutableBoundingBox, reference, seed);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManager, int chunkX, int chunkZ, Biome biomeIn, NoFeatureConfig config) {
            Rotation rotation = Rotation.func_222466_a((Random)this.field_214631_d);
            int x0 = (chunkX << 4) + 7;
            int z0 = (chunkZ << 4) + 7;
            int x1 = (chunkX + 1 << 4) + 7;
            int z1 = (chunkZ + 2 << 4) + 7;
            int surfaceY = chunkGenerator.func_222529_a(x1, z1, Heightmap.Type.WORLD_SURFACE_WG);
            BlockPos blockpos = new BlockPos(x0, surfaceY, z0);
            BanditSmallBasePieces.addComponents(templateManager, blockpos, this.field_75075_a);
            this.func_202500_a();
            StructuresHelper.SPAWNED_STRUCTURES.add(blockpos);
            WyDebug.debug("Bandit Small Base spawned at: /tp " + ((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78897_a + " ~ " + ((StructurePiece)this.field_75075_a.get((int)0)).func_74874_b().field_78896_c);
        }
    }
}

