/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.features.structures.smallbase.bandit;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.init.ModLootTables;
import xyz.pixelatedw.mineminenomi.init.ModStructures;

public class BanditSmallBasePieces {
    private static final ResourceLocation HOUSE = new ResourceLocation("mineminenomi", "bandit/small_base_house");
    private static final ResourceLocation UNDERGROUND = new ResourceLocation("mineminenomi", "bandit/small_base_underground");
    private static final Map<ResourceLocation, BlockPos> POSITION_OFFSET = ImmutableMap.builder().put((Object)HOUSE, (Object)new BlockPos(20, 26, 24)).put((Object)UNDERGROUND, (Object)new BlockPos(0, 0, 0)).build();

    public static void addComponents(TemplateManager templateManager, BlockPos pos, List<StructurePiece> components) {
        components.add((StructurePiece)new HousePiece(templateManager, pos));
        components.add((StructurePiece)new UndergroundPiece(templateManager, pos));
    }

    public static class Piece
    extends TemplateStructurePiece {
        protected ResourceLocation resourceLocation;
        protected Rotation field_186169_c;

        public Piece(TemplateManager template, IStructurePieceType type, CompoundNBT nbt) {
            super(type, nbt);
            this.resourceLocation = new ResourceLocation(nbt.func_74779_i("Template"));
            this.field_186169_c = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
        }

        public Piece(TemplateManager template, IStructurePieceType type, ResourceLocation res, BlockPos pos) {
            super(type, 0);
            this.resourceLocation = res;
            BlockPos blockpos = (BlockPos)POSITION_OFFSET.get(this.resourceLocation);
            this.field_186178_c = pos.func_177982_a(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            this.field_186169_c = Rotation.NONE;
        }

        protected void func_143011_b(CompoundNBT nbt) {
            super.func_143011_b(nbt);
            nbt.func_74778_a("Template", this.resourceLocation.toString());
            nbt.func_74778_a("Rot", this.field_186169_c.name());
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox sbb) {
            if (function.equals("equipment_chest")) {
                StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.SMALL_BANDIT_BASE_MINE_CHEST);
            }
            if (function.equals("gem_chest")) {
                StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.SMALL_BANDIT_BASE_ORES_CHEST);
            }
            if (function.equals("lab_chest")) {
                StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.SMALL_BANDIT_BASE_LAB_CHEST);
            }
            if (function.equals("gold_chest")) {
                StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.SMALL_BANDIT_BASE_GOLD_CHEST);
            }
            if (function.equals("lounge_spawn")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.BANDIT, StructuresHelper.StructureSpawnType.GRUNT, 5);
            }
            if (function.equals("hall_spawn")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.BANDIT, StructuresHelper.StructureSpawnType.BRUTE, 3);
            }
            if (function.equals("bedroom_spawn_1")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.BANDIT, StructuresHelper.StructureSpawnType.GRUNT, 5);
            }
            if (function.equals("bedroom_spawn_2")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.BANDIT, StructuresHelper.StructureSpawnType.CAPTAIN, 1);
            }
            if (function.equals("lab_spawn")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.BANDIT, StructuresHelper.StructureSpawnType.BRUTE, 3);
            }
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager pStructureManager, ChunkGenerator pChunkGenerator, Random pRandom, MutableBoundingBox pBox, ChunkPos pChunkPos, BlockPos pPos) {
            BlockPos ogPos = this.field_186178_c;
            this.field_186178_c = this.field_186178_c.func_177982_a(0, -28, 0);
            boolean flag = super.func_230383_a_(world, pStructureManager, pChunkGenerator, pRandom, pBox, pChunkPos, pPos);
            this.field_186178_c = ogPos;
            return flag;
        }
    }

    public static class HousePiece
    extends Piece {
        public HousePiece(TemplateManager template, CompoundNBT nbt) {
            super(template, ModStructures.Pieces.BANDIT_SMALL_BASE_HOUSE_PIECE, nbt);
            this.build(template);
        }

        public HousePiece(TemplateManager template, BlockPos pos) {
            super(template, ModStructures.Pieces.BANDIT_SMALL_BASE_HOUSE_PIECE, HOUSE, pos);
            this.build(template);
        }

        private void build(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.field_186169_c).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }
    }

    public static class UndergroundPiece
    extends Piece {
        public UndergroundPiece(TemplateManager template, CompoundNBT nbt) {
            super(template, ModStructures.Pieces.BANDIT_SMALL_BASE_UNDERGROUND_PIECE, nbt);
            this.build(template);
        }

        public UndergroundPiece(TemplateManager template, BlockPos pos) {
            super(template, ModStructures.Pieces.BANDIT_SMALL_BASE_UNDERGROUND_PIECE, UNDERGROUND, pos);
            this.build(template);
        }

        private void build(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.field_186169_c).func_186214_a(Mirror.NONE).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }
    }
}

