/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.features.structures.largebase.marine;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xyz.pixelatedw.mineminenomi.api.WantedPosterData;
import xyz.pixelatedw.mineminenomi.api.enums.CanvasSize;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.blocks.FlagBlock;
import xyz.pixelatedw.mineminenomi.blocks.WantedPosterBlock;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.FlagTileEntity;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.WantedPosterTileEntity;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModLootTables;
import xyz.pixelatedw.mineminenomi.init.ModStructures;
import xyz.pixelatedw.mineminenomi.init.ModValues;

public class MarineLargeBasePieces {
    private static final ResourceLocation STRUCTURE = new ResourceLocation("mineminenomi", "marine/large_base");
    private static final ResourceLocation PRISON = new ResourceLocation("mineminenomi", "marine/large_base_prison");
    private static final Map<ResourceLocation, BlockPos> POSITION_OFFSET = ImmutableMap.builder().put((Object)STRUCTURE, (Object)new BlockPos(0, 0, 0)).put((Object)PRISON, (Object)new BlockPos(10, -13, 14)).build();
    private static final Map<ResourceLocation, BlockPos> CENTER_OFFSET = ImmutableMap.builder().put((Object)STRUCTURE, (Object)new BlockPos(0, 0, 0)).put((Object)PRISON, (Object)new BlockPos(0, 0, 0)).build();

    public static void addComponents(TemplateManager templateManager, BlockPos pos, List<StructurePiece> components) {
        components.add((StructurePiece)new MainBodyPiece(templateManager, pos));
        components.add((StructurePiece)new PrisonPiece(templateManager, pos));
    }

    public static class Piece
    extends TemplateStructurePiece {
        protected ResourceLocation resourceLocation;
        protected Rotation field_186169_c;
        protected StructureProcessor processor;
        private Set<UUID> posters = new HashSet<UUID>();

        public Piece(TemplateManager template, IStructurePieceType type, CompoundNBT nbt) {
            super(type, nbt);
            this.resourceLocation = new ResourceLocation(nbt.func_74779_i("Template"));
            this.field_186169_c = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
            this.processor = BlockIgnoreStructureProcessor.field_215206_c;
            this.build(template);
        }

        public Piece(TemplateManager template, IStructurePieceType type, ResourceLocation res, BlockPos pos, StructureProcessor proc) {
            super(type, 0);
            this.field_186169_c = Rotation.NONE;
            this.resourceLocation = res;
            BlockPos blockpos = (BlockPos)POSITION_OFFSET.get(this.resourceLocation);
            this.field_186178_c = pos.func_177982_a(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            this.processor = BlockIgnoreStructureProcessor.field_215206_c;
            this.build(template);
        }

        protected void func_143011_b(CompoundNBT nbt) {
            super.func_143011_b(nbt);
            nbt.func_74778_a("Template", this.resourceLocation.toString());
            nbt.func_74778_a("Rot", this.field_186169_c.name());
        }

        private void build(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.field_186169_c).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)CENTER_OFFSET.get(this.resourceLocation)).func_215222_a(this.processor);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_186175_a(String function, BlockPos pos, IServerWorld world, Random rand, MutableBoundingBox pSbb) {
            boolean chest;
            if (function.equals("food_storage_chest")) {
                StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.LARGE_MARINE_BASE_FOOD_CHEST);
            }
            if (function.equals("enchantment_chest")) {
                StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.LARGE_MARINE_BASE_LAB_CHEST);
            }
            if (function.equals("supplies_chest")) {
                StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.LARGE_MARINE_BASE_GENERIC_CHEST);
            }
            if (function.equals("captain_room_chest")) {
                StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.LARGE_MARINE_BASE_CAPTAIN_CHEST);
            }
            if (chest = rand.nextBoolean()) {
                if (function.equals("office_chest_1")) {
                    StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.LARGE_MARINE_BASE_CAPTAIN_CHEST);
                }
            } else if (function.equals("office_chest_2")) {
                StructuresHelper.spawnLoot((IWorld)world, pos, ModLootTables.LARGE_MARINE_BASE_CAPTAIN_CHEST);
            }
            StructuresHelper.StructureFaction prisoners1 = world.func_201674_k().nextBoolean() ? StructuresHelper.StructureFaction.BANDIT : StructuresHelper.StructureFaction.PIRATE;
            StructuresHelper.StructureFaction prisoners2 = world.func_201674_k().nextBoolean() ? StructuresHelper.StructureFaction.BANDIT : StructuresHelper.StructureFaction.PIRATE;
            StructuresHelper.StructureFaction prisoners3 = world.func_201674_k().nextBoolean() ? StructuresHelper.StructureFaction.BANDIT : StructuresHelper.StructureFaction.PIRATE;
            StructuresHelper.StructureFaction prisoners4 = world.func_201674_k().nextBoolean() ? StructuresHelper.StructureFaction.BANDIT : StructuresHelper.StructureFaction.PIRATE;
            boolean extraSpawns = rand.nextBoolean();
            if (function.equals("prison_spawn_1")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, prisoners1, StructuresHelper.StructureSpawnType.GRUNT, 3);
            }
            if (extraSpawns && function.equals("prison_spawn_2")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, prisoners2, StructuresHelper.StructureSpawnType.GRUNT, 3);
            } else if (!extraSpawns) {
                world.func_180501_a(pos, ((Block)ModBlocks.STRUCTURE_AIR.get()).func_176223_P(), 3);
            }
            if (function.equals("prison_spawn_3")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, prisoners3, StructuresHelper.StructureSpawnType.GRUNT, 2);
            }
            if (extraSpawns && function.equals("prison_spawn_4")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, prisoners4, StructuresHelper.StructureSpawnType.GRUNT, 2);
            } else if (!extraSpawns) {
                world.func_180501_a(pos, ((Block)ModBlocks.STRUCTURE_AIR.get()).func_176223_P(), 3);
            }
            if (function.equals("front_desk_spawn")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.GRUNT, 5);
            }
            if (function.equals("prison_guard_spawn")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.GRUNT, 3);
            }
            if (function.equals("dinner_spawn")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.GRUNT, 5);
            }
            if (function.equals("bedroom_spawn")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.GRUNT, 3);
            }
            if (function.equals("lounge_spawn_1")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.GRUNT, 5);
            }
            if (function.equals("lounge_spawn_2")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.BRUTE, 5);
            }
            if (function.equals("captain_room_spawn")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.CAPTAIN, 1);
            }
            if (function.equals("office_spawn")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.CAPTAIN, 1);
            }
            if (function.equals("rooftop_spawn")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.SNIPER, 5);
            }
            if (function.equals("balcony_spawn")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, StructuresHelper.StructureFaction.MARINE, StructuresHelper.StructureSpawnType.SNIPER, 1);
            }
            if (function.equals("special_prison")) {
                StructuresHelper.spawnMobs((IWorld)world, pos, prisoners4, StructuresHelper.StructureSpawnType.GRUNT, 4);
            }
            Rotation rot = this.field_186177_b.func_186215_c();
            if (function.startsWith("wanted_poster_")) {
                ExtendedWorldData worldData = ExtendedWorldData.get();
                Optional<Map.Entry<UUID, Long>> bounty = worldData.getAllBounties().entrySet().stream().findAny();
                String[] funcSplt = function.split("_");
                int id = -1;
                try {
                    id = Integer.parseInt(funcSplt[2]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (id >= 0) {
                    if (id <= 5) {
                        this.generateWantedPoster(world, pos, rot, Direction.NORTH, bounty);
                    } else if (id > 5 && id <= 10) {
                        this.generateWantedPoster(world, pos, rot, Direction.SOUTH, bounty);
                    } else if (id == 11 || id == 12) {
                        this.generateWantedPoster(world, pos, rot, Direction.SOUTH, bounty);
                    } else if (id == 13) {
                        this.generateWantedPoster(world, pos, rot, Direction.WEST, bounty);
                    }
                }
            }
            if (function.equals("flag")) {
                BlockState state = ((Block)ModBlocks.FLAG.get()).func_176223_P();
                state = (BlockState)state.func_206870_a((Property)WantedPosterBlock.FACING, (Comparable)rot.func_185831_a(Direction.NORTH));
                state = (BlockState)state.func_206870_a(FlagBlock.SIZE, (Comparable)((Object)CanvasSize.HUGE));
                world.func_180501_a(pos, state, 3);
                FlagBlock.placeSubs((IWorld)world, pos, state, false);
                TileEntity flagTile = world.func_175625_s(pos);
                if (flagTile != null && flagTile instanceof FlagTileEntity) {
                    ((FlagTileEntity)flagTile).setFaction(ModValues.MARINE);
                }
            }
        }

        private void generateWantedPoster(IServerWorld world, BlockPos pos, Rotation rot, Direction dir, Optional<Map.Entry<UUID, Long>> bounty) {
            if (world.func_201670_d()) {
                return;
            }
            if (!world.func_201674_k().nextBoolean()) {
                return;
            }
            if (bounty.isPresent()) {
                UUID key = bounty.get().getKey();
                PlayerEntity player = world.func_217371_b(key);
                if (this.posters.contains(key) || player == null) {
                    world.func_180501_a(pos, ((Block)ModBlocks.STRUCTURE_AIR.get()).func_176223_P(), 3);
                    return;
                }
                WantedPosterData wantedPosterData = new WantedPosterData((LivingEntity)player, bounty.get().getValue());
                BlockState state = ((Block)ModBlocks.WANTED_POSTER.get()).func_176223_P();
                state = (BlockState)state.func_206870_a((Property)WantedPosterBlock.FACING, (Comparable)rot.func_185831_a(dir));
                world.func_180501_a(pos, state, 2);
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof WantedPosterTileEntity) {
                    ((WantedPosterTileEntity)tile).setWantedPosterData(wantedPosterData);
                    tile.func_70296_d();
                }
                this.posters.add(key);
            } else {
                world.func_180501_a(pos, ((Block)ModBlocks.STRUCTURE_AIR.get()).func_176223_P(), 3);
            }
        }

        public boolean func_230383_a_(ISeedReader world, StructureManager pStructureManager, ChunkGenerator pChunkGenerator, Random pRandom, MutableBoundingBox pBox, ChunkPos pChunkPos, BlockPos pPos) {
            boolean flag = super.func_230383_a_(world, pStructureManager, pChunkGenerator, pRandom, pBox, pChunkPos, pPos);
            return flag;
        }
    }

    public static class PrisonPiece
    extends Piece {
        public PrisonPiece(TemplateManager template, CompoundNBT nbt) {
            super(template, ModStructures.Pieces.MARINE_LARGE_BASE_PRISON_PIECE, nbt);
        }

        public PrisonPiece(TemplateManager template, BlockPos pos) {
            super(template, ModStructures.Pieces.MARINE_LARGE_BASE_PRISON_PIECE, PRISON, pos, (StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
        }

        @Override
        public boolean func_230383_a_(ISeedReader world, StructureManager pStructureManager, ChunkGenerator pChunkGenerator, Random pRandom, MutableBoundingBox pBox, ChunkPos pChunkPos, BlockPos pPos) {
            boolean flag = super.func_230383_a_(world, pStructureManager, pChunkGenerator, pRandom, pBox, pChunkPos, pPos);
            ArrayList infos = new ArrayList();
            infos.addAll(this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, Blocks.field_150463_bK));
            infos.addAll(this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, Blocks.field_196659_cl));
            infos.addAll(this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, Blocks.field_150411_aY));
            infos.addAll(this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, Blocks.field_222432_lU));
            for (Template.BlockInfo info : infos) {
                world.func_180501_a(info.field_186242_a, (BlockState)info.field_186243_b.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)), 3);
            }
            return flag;
        }
    }

    public static class MainBodyPiece
    extends Piece {
        public MainBodyPiece(TemplateManager template, CompoundNBT nbt) {
            super(template, ModStructures.Pieces.MARINE_LARGE_BASE_BODY_PIECE, nbt);
        }

        public MainBodyPiece(TemplateManager template, BlockPos pos) {
            super(template, ModStructures.Pieces.MARINE_LARGE_BASE_BODY_PIECE, STRUCTURE, pos, (StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a);
        }

        @Override
        public boolean func_230383_a_(ISeedReader world, StructureManager pStructureManager, ChunkGenerator pChunkGenerator, Random pRandom, MutableBoundingBox pBox, ChunkPos pChunkPos, BlockPos pPos) {
            boolean flag = super.func_230383_a_(world, pStructureManager, pChunkGenerator, pRandom, pBox, pChunkPos, pPos);
            ArrayList infos = new ArrayList();
            infos.addAll(this.field_186176_a.func_215381_a(this.field_186178_c, this.field_186177_b, Blocks.field_150481_bH));
            for (Template.BlockInfo info : infos) {
                world.func_180501_a(info.field_186242_a, (BlockState)info.field_186243_b.func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)), 3);
            }
            return flag;
        }
    }
}

