/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.features;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import xyz.pixelatedw.mineminenomi.data.world.StructuresWorldData;
import xyz.pixelatedw.mineminenomi.init.ModBiomes;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SnowMountainFeature
extends Feature<ProbabilityConfig> {
    public SnowMountainFeature() {
        super(ProbabilityConfig.field_236576_b_);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, ProbabilityConfig config) {
        int radius;
        if (rand.nextFloat() >= config.field_203622_a) {
            return false;
        }
        StructuresWorldData structData = StructuresWorldData.get();
        int x0 = pos.func_177958_n();
        int z0 = pos.func_177952_p();
        int y0 = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x0, z0);
        int check = radius = 1000;
        BlockPos pos0 = new BlockPos(x0, y0, z0);
        if (structData.isNearSnowMountain(pos0, radius)) {
            return false;
        }
        BiomeProvider biomeSource = chunkGen.func_202090_b();
        for (Biome biomeCheck : biomeSource.func_225530_a_(x0, y0, z0, 10)) {
            if (biomeCheck.getRegistryName().equals((Object)((Biome)ModBiomes.DRUM.get()).getRegistryName())) continue;
            return false;
        }
        BlockPos.Mutable mutpos = new BlockPos.Mutable(x0, y0, z0);
        int minY = 0;
        int maxY = 0;
        for (int x = 7; x < 64; x += 16) {
            for (int z = 7; z < 64; z += 16) {
                mutpos.func_181079_c(x0 + x, y0, z0 + z);
                int landHeight = chunkGen.func_222531_c(mutpos.func_177958_n(), mutpos.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
                if (minY == 0) {
                    minY = landHeight;
                }
                if (maxY == 0) {
                    maxY = landHeight;
                }
                minY = Math.min(minY, landHeight);
                maxY = Math.max(maxY, landHeight);
            }
        }
        double heightDiff = Math.abs(maxY - minY);
        mutpos.func_181079_c(x0, y0, z0);
        for (int y = 0; y < 60; ++y) {
            for (int x = x0 - radius; x <= x0 + radius; ++x) {
                for (int z = z0 - radius; z <= z0 + radius; ++z) {
                    double distance = (x0 - x) * (x0 - x) + (z0 - z) * (z0 - z);
                    if (y > 20 && y < 40) {
                        check = 950;
                    }
                    if (y > 40 && y < 60) {
                        check = 900;
                    }
                    if (!(distance < (double)check)) continue;
                    mutpos.func_189532_c((double)x, (double)y0 - heightDiff + (double)y, (double)z);
                    BlockState blockstate = world.func_180495_p((BlockPos)mutpos);
                    Block block = blockstate.func_177230_c();
                    if (!blockstate.isAir((IBlockReader)world, (BlockPos)mutpos) && !SnowMountainFeature.func_227250_b_((Block)block) && block != Blocks.field_196604_cC && block != Blocks.field_150433_aE && block != Blocks.field_150432_aD) continue;
                    WyHelper.swapBlockData((IWorld)world, (BlockPos)mutpos, Blocks.field_196604_cC.func_176223_P());
                }
            }
        }
        structData.addSnowMountain(pos0);
        return true;
    }
}

