/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.features;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.shapes.BitSetVoxelShapePart;
import net.minecraft.util.math.shapes.VoxelShapePart;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.template.Template;
import xyz.pixelatedw.mineminenomi.data.world.StructuresWorldData;

public class RareTreeFeature
extends Feature<BaseTreeFeatureConfig> {
    public RareTreeFeature() {
        super(BaseTreeFeatureConfig.field_236676_a_);
    }

    public static boolean isFree(IWorldGenerationBaseReader pLevel, BlockPos pPos) {
        return RareTreeFeature.validTreePos(pLevel, pPos) || pLevel.func_217375_a(pPos, p_236417_0_ -> p_236417_0_.func_235714_a_((ITag)BlockTags.field_200031_h));
    }

    private static boolean isVine(IWorldGenerationBaseReader pLevel, BlockPos pPos) {
        return pLevel.func_217375_a(pPos, p_236415_0_ -> p_236415_0_.func_203425_a(Blocks.field_150395_bd));
    }

    private static boolean isBlockWater(IWorldGenerationBaseReader pLevel, BlockPos pPos) {
        return pLevel.func_217375_a(pPos, p_236413_0_ -> p_236413_0_.func_203425_a(Blocks.field_150355_j));
    }

    public static boolean isAirOrLeaves(IWorldGenerationBaseReader pLevel, BlockPos pPos) {
        return pLevel.func_217375_a(pPos, p_236411_0_ -> p_236411_0_.func_196958_f() || p_236411_0_.func_235714_a_((ITag)BlockTags.field_206952_E));
    }

    private static boolean isGrassOrDirtOrFarmland(IWorldGenerationBaseReader p_236418_0_, BlockPos p_236418_1_) {
        return p_236418_0_.func_217375_a(p_236418_1_, p_236409_0_ -> {
            Block block = p_236409_0_.func_177230_c();
            return RareTreeFeature.func_227250_b_((Block)block) || block == Blocks.field_150458_ak;
        });
    }

    private static boolean isReplaceablePlant(IWorldGenerationBaseReader pLevel, BlockPos pPos) {
        return pLevel.func_217375_a(pPos, p_236406_0_ -> {
            Material material = p_236406_0_.func_185904_a();
            return material == Material.field_151582_l;
        });
    }

    public static void setBlockKnownShape(IWorldWriter pLevel, BlockPos pPos, BlockState pState) {
        pLevel.func_180501_a(pPos, pState, 19);
    }

    public static boolean validTreePos(IWorldGenerationBaseReader pLevel, BlockPos pPos) {
        return RareTreeFeature.isAirOrLeaves(pLevel, pPos) || RareTreeFeature.isReplaceablePlant(pLevel, pPos) || RareTreeFeature.isBlockWater(pLevel, pPos);
    }

    private boolean doPlace(IWorldGenerationReader p_225557_1_, Random p_225557_2_, BlockPos p_225557_3_, Set<BlockPos> p_225557_4_, Set<BlockPos> p_225557_5_, MutableBoundingBox p_225557_6_, BaseTreeFeatureConfig p_225557_7_) {
        BlockPos blockpos;
        int i = p_225557_7_.field_236678_g_.func_236917_a_(p_225557_2_);
        int j = p_225557_7_.field_236677_f_.func_230374_a_(p_225557_2_, i, p_225557_7_);
        int k = i - j;
        int l = p_225557_7_.field_236677_f_.func_230376_a_(p_225557_2_, k);
        if (!p_225557_7_.field_227372_q_) {
            int i1 = p_225557_1_.func_205770_a(Heightmap.Type.OCEAN_FLOOR, p_225557_3_).func_177956_o();
            int j1 = p_225557_1_.func_205770_a(Heightmap.Type.WORLD_SURFACE, p_225557_3_).func_177956_o();
            if (j1 - i1 > p_225557_7_.field_236680_i_) {
                return false;
            }
            int k1 = p_225557_7_.field_236682_l_ == Heightmap.Type.OCEAN_FLOOR ? i1 : (p_225557_7_.field_236682_l_ == Heightmap.Type.WORLD_SURFACE ? j1 : p_225557_1_.func_205770_a(p_225557_7_.field_236682_l_, p_225557_3_).func_177956_o());
            blockpos = new BlockPos(p_225557_3_.func_177958_n(), k1, p_225557_3_.func_177952_p());
        } else {
            blockpos = p_225557_3_;
        }
        if (blockpos.func_177956_o() >= 1 && blockpos.func_177956_o() + i + 1 <= 256) {
            if (!RareTreeFeature.isGrassOrDirtOrFarmland((IWorldGenerationBaseReader)p_225557_1_, blockpos.func_177977_b())) {
                return false;
            }
            OptionalInt optionalint = p_225557_7_.field_236679_h_.func_236710_c_();
            int l1 = this.getMaxFreeTreeHeight((IWorldGenerationBaseReader)p_225557_1_, i, blockpos, p_225557_7_);
            if (l1 >= i || optionalint.isPresent() && l1 >= optionalint.getAsInt()) {
                List list = p_225557_7_.field_236678_g_.func_230382_a_(p_225557_1_, p_225557_2_, l1, blockpos, p_225557_4_, p_225557_6_, p_225557_7_);
                list.forEach(p_236407_8_ -> p_225557_7_.field_236677_f_.func_236752_a_(p_225557_1_, p_225557_2_, p_225557_7_, l1, p_236407_8_, j, l, p_225557_5_, p_225557_6_));
                return true;
            }
            return false;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(IWorldGenerationBaseReader pLevel, int pTrunkHeight, BlockPos pTopPosition, BaseTreeFeatureConfig pConfig) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int i = 0; i <= pTrunkHeight + 1; ++i) {
            int j = pConfig.field_236679_h_.func_230369_a_(pTrunkHeight, i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    blockpos$mutable.func_239621_a_((Vector3i)pTopPosition, k, i, l);
                    if (RareTreeFeature.isFree(pLevel, (BlockPos)blockpos$mutable) && (pConfig.field_236681_j_ || !RareTreeFeature.isVine(pLevel, (BlockPos)blockpos$mutable))) continue;
                    return i - 2;
                }
            }
        }
        return pTrunkHeight;
    }

    protected void func_230367_a_(IWorldWriter pLevel, BlockPos pPos, BlockState pState) {
        RareTreeFeature.setBlockKnownShape(pLevel, pPos, pState);
    }

    public final boolean place(ISeedReader world, ChunkGenerator chunkGen, Random rand, BlockPos pos, BaseTreeFeatureConfig config) {
        int z0;
        int y0;
        int x0;
        BlockPos pos0;
        StructuresWorldData structData = StructuresWorldData.get();
        if (structData.isNearHugeSabaodyTree(pos0 = new BlockPos(x0 = pos.func_177958_n(), y0 = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, x0, z0 = pos.func_177952_p()), z0), 1000.0)) {
            return false;
        }
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        MutableBoundingBox mutableboundingbox = MutableBoundingBox.func_78887_a();
        boolean flag = this.doPlace((IWorldGenerationReader)world, rand, pos, set, set1, mutableboundingbox, config);
        if (mutableboundingbox.field_78897_a <= mutableboundingbox.field_78893_d && flag && !set.isEmpty()) {
            if (!config.field_227370_o_.isEmpty()) {
                ArrayList list = Lists.newArrayList((Iterable)set);
                ArrayList list1 = Lists.newArrayList((Iterable)set1);
                list.sort(Comparator.comparingInt(Vector3i::func_177956_o));
                list1.sort(Comparator.comparingInt(Vector3i::func_177956_o));
                config.field_227370_o_.forEach(p_236405_6_ -> p_236405_6_.func_225576_a_(world, rand, list, list1, set2, mutableboundingbox));
            }
            VoxelShapePart voxelshapepart = this.updateLeaves((IWorld)world, mutableboundingbox, set, set2);
            Template.func_222857_a((IWorld)world, (int)3, (VoxelShapePart)voxelshapepart, (int)mutableboundingbox.field_78897_a, (int)mutableboundingbox.field_78895_b, (int)mutableboundingbox.field_78896_c);
            structData.addHugeSabaodyTree(pos0);
            return true;
        }
        return false;
    }

    private VoxelShapePart updateLeaves(IWorld pLevel, MutableBoundingBox pBoundingBox, Set<BlockPos> pLogPositions, Set<BlockPos> pFoliagePositions) {
        ArrayList list = Lists.newArrayList();
        BitSetVoxelShapePart voxelshapepart = new BitSetVoxelShapePart(pBoundingBox.func_78883_b(), pBoundingBox.func_78882_c(), pBoundingBox.func_78880_d());
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (BlockPos blockpos : Lists.newArrayList(pFoliagePositions)) {
            if (!pBoundingBox.func_175898_b((Vector3i)blockpos)) continue;
            voxelshapepart.func_199625_a(blockpos.func_177958_n() - pBoundingBox.field_78897_a, blockpos.func_177956_o() - pBoundingBox.field_78895_b, blockpos.func_177952_p() - pBoundingBox.field_78896_c, true, true);
        }
        for (BlockPos blockpos1 : Lists.newArrayList(pLogPositions)) {
            if (pBoundingBox.func_175898_b((Vector3i)blockpos1)) {
                voxelshapepart.func_199625_a(blockpos1.func_177958_n() - pBoundingBox.field_78897_a, blockpos1.func_177956_o() - pBoundingBox.field_78895_b, blockpos1.func_177952_p() - pBoundingBox.field_78896_c, true, true);
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                blockpos$mutable.func_239622_a_((Vector3i)blockpos1, direction);
                if (pLogPositions.contains(blockpos$mutable) || !(blockstate = pLevel.func_180495_p((BlockPos)blockpos$mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa)) continue;
                ((Set)list.get(0)).add(blockpos$mutable.func_185334_h());
                RareTreeFeature.setBlockKnownShape((IWorldWriter)pLevel, (BlockPos)blockpos$mutable, (BlockState)blockstate.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(1)));
                if (!pBoundingBox.func_175898_b((Vector3i)blockpos$mutable)) continue;
                voxelshapepart.func_199625_a(blockpos$mutable.func_177958_n() - pBoundingBox.field_78897_a, blockpos$mutable.func_177956_o() - pBoundingBox.field_78895_b, blockpos$mutable.func_177952_p() - pBoundingBox.field_78896_c, true, true);
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (pBoundingBox.func_175898_b((Vector3i)blockpos2)) {
                    voxelshapepart.func_199625_a(blockpos2.func_177958_n() - pBoundingBox.field_78897_a, blockpos2.func_177956_o() - pBoundingBox.field_78895_b, blockpos2.func_177952_p() - pBoundingBox.field_78896_c, true, true);
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    blockpos$mutable.func_239622_a_((Vector3i)blockpos2, direction1);
                    if (set.contains(blockpos$mutable) || set1.contains(blockpos$mutable) || !(blockstate1 = pLevel.func_180495_p((BlockPos)blockpos$mutable)).func_235901_b_((Property)BlockStateProperties.field_208514_aa) || (k = ((Integer)blockstate1.func_177229_b((Property)BlockStateProperties.field_208514_aa)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.func_206870_a((Property)BlockStateProperties.field_208514_aa, (Comparable)Integer.valueOf(l + 1));
                    RareTreeFeature.setBlockKnownShape((IWorldWriter)pLevel, (BlockPos)blockpos$mutable, blockstate2);
                    if (pBoundingBox.func_175898_b((Vector3i)blockpos$mutable)) {
                        voxelshapepart.func_199625_a(blockpos$mutable.func_177958_n() - pBoundingBox.field_78897_a, blockpos$mutable.func_177956_o() - pBoundingBox.field_78895_b, blockpos$mutable.func_177952_p() - pBoundingBox.field_78896_c, true, true);
                    }
                    set1.add(blockpos$mutable.func_185334_h());
                }
            }
        }
        return voxelshapepart;
    }
}

