/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens.extra.panels;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.client.gui.ScrollPanel;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.client.crew.CKickFromCrewPacket;
import xyz.pixelatedw.mineminenomi.screens.CrewDetailsScreen;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.SimpleButton;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class CrewMembersListPanel
extends ScrollPanel {
    private static final int ENTRY_HEIGHT = 20;
    private final CrewDetailsScreen parent;
    private final List<Crew.Member> displayedMembers;
    private final Minecraft mc = Minecraft.func_71410_x();

    public CrewMembersListPanel(CrewDetailsScreen parent, List<Crew.Member> list) {
        super(parent.getMinecraft(), 220, 160, parent.field_230709_l_ / 2 - 80, parent.field_230708_k_ / 2 + 10);
        this.parent = parent;
        this.displayedMembers = list;
    }

    public boolean func_231048_c_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return false;
    }

    protected int getContentHeight() {
        return this.displayedMembers.size() * 20 - 2;
    }

    protected int getScrollAmount() {
        return 12;
    }

    protected void drawGradientRect(MatrixStack matrixStack, int left, int top, int right, int bottom, int color1, int color2) {
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void drawPanel(MatrixStack matrixStack, int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
        int y = relativeY;
        int x = this.parent.field_230708_k_ / 2 + 40;
        int yOffset = 0;
        for (Crew.Member member : this.displayedMembers) {
            String memberName = member.getUsername();
            if (memberName.length() >= 20) {
                memberName = memberName.substring(0, 20) + "...";
            }
            memberName = memberName + (member.isCaptain() ? " (" + I18n.func_135052_a((String)ModI18n.CREW_CAPTAIN, (Object[])new Object[0]) + ")" : "");
            WyHelper.drawStringWithBorder(this.mc.field_71466_p, matrixStack, memberName, x, y + 1 + yOffset, -1);
            if (!member.isCaptain()) {
                SimpleButton kickButton = new SimpleButton(x - 20, y + yOffset, 10, 10, (ITextComponent)new StringTextComponent("X"), b -> {});
                kickButton.setHoverTextColor("#FF0000");
                kickButton.func_230430_a_(matrixStack, mouseX, mouseY, 0.0f);
            }
            yOffset += 20;
        }
    }

    private Crew.Member findEntry(int mouseX, int mouseY) {
        double offset = (float)(mouseY - this.top) + this.scrollDistance;
        if (offset <= 0.0) {
            return null;
        }
        int lineIdx = (int)(offset / 20.0);
        if (lineIdx >= this.displayedMembers.size()) {
            return null;
        }
        Crew.Member entry = this.displayedMembers.get(lineIdx);
        if (entry != null) {
            return entry;
        }
        return null;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        Crew.Member member = this.findEntry((int)mouseX, (int)mouseY);
        if (member != null && this.func_231047_b_(mouseX, mouseY) && button == 0 && mouseX > (double)(this.left + 10) && mouseX < (double)(this.left + 20)) {
            WyNetwork.sendToServer(new CKickFromCrewPacket(member.getUUID()));
            this.displayedMembers.removeIf(mem -> mem.getUUID().equals(member.getUUID()));
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        return mouseX >= (double)this.left && mouseY >= (double)this.top && mouseX < (double)(this.left + this.width - 5) && mouseY < (double)(this.top + this.height);
    }
}

