/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens.extra.panels;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.client.gui.ScrollPanel;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCoreUnlockWrapper;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusManager;
import xyz.pixelatedw.mineminenomi.api.abilities.components.PauseTickComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.client.ability.CEquipAbilityPacket;
import xyz.pixelatedw.mineminenomi.packets.client.ability.CTogglePassiveAbilityPacket;
import xyz.pixelatedw.mineminenomi.screens.SelectHotbarAbilitiesScreen;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class AbilitiesListScreenPanel<A extends IAbility>
extends ScrollPanel {
    private static final float[] SPACINGS = new float[]{1.25f, 1.05f};
    private static final float ENTRY_HEIGHT = 20.0f;
    private final SelectHotbarAbilitiesScreen<A> parent;
    private final PlayerEntity player;
    private final IAbilityData props;
    private final List<Entry<IAbility>> allAbilities;
    private final TreeSet<AbilityCore<IAbility>> unlockedAbilities;
    private final TreeSet<IAbility> passiveAbilities;
    private final AbilityCategory category;
    private final Map<AbilityCore<IAbility>, IAbility> unlockedToEquippedMap = new HashMap<AbilityCore<IAbility>, IAbility>();
    private final Minecraft mc = Minecraft.func_71410_x();
    private SelectHotbarAbilitiesScreen.Compactness compactness;
    private Entry<IAbility> hoveredEntry;

    public AbilitiesListScreenPanel(SelectHotbarAbilitiesScreen<A> parent, IAbilityData abilityProps, AbilityCategory category) {
        super(parent.getMinecraft(), 210, 130, parent.field_230709_l_ / 2 - 92, parent.field_230708_k_ / 2 - 102);
        Minecraft parentMinecraft = parent.getMinecraft();
        this.parent = parent;
        this.player = parentMinecraft.field_71439_g;
        this.props = abilityProps;
        this.category = category;
        this.compactness = parent.getCompactness();
        this.allAbilities = new ArrayList<Entry<IAbility>>();
        this.unlockedAbilities = this.props.getUnlockedAbilitiesStream().map(AbilityCoreUnlockWrapper::getAbilityCore).filter(core -> !core.isHidden() && core.getType().equals((Object)AbilityType.ACTION) && category.isCorePartofCategory().test((AbilityCore)core)).collect(Collectors.toCollection(TreeSet::new));
        this.passiveAbilities = this.props.getPassiveAbilities(abl -> !abl.getCore().isHidden() && abl.getCore().getType() == AbilityType.PASSIVE && category.isAbilityPartofCategory().test((IAbility)abl)).stream().collect(Collectors.toCollection(TreeSet::new));
        for (AbilityCore<IAbility> abilityCore : this.unlockedAbilities) {
            this.allAbilities.add(new Entry<IAbility>(abilityCore));
        }
        this.allAbilities.add(new Entry());
        for (IAbility iAbility : this.passiveAbilities) {
            this.allAbilities.add(new Entry(this, iAbility));
        }
        this.unlockedToEquippedMap.clear();
        for (AbilityCore abilityCore : this.unlockedAbilities) {
            Object abl3 = this.props.getEquippedAbility(abilityCore);
            if (abl3 == null) {
                abl3 = abilityCore.createAbility();
            }
            this.unlockedToEquippedMap.put(abilityCore, (IAbility)abl3);
        }
    }

    public boolean func_231048_c_(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return true;
    }

    protected int getContentHeight() {
        int size = this.allAbilities.stream().collect(Collectors.toList()).size();
        return (int)((float)size * this.getEntrySpacing() + 2.0f);
    }

    public float getEntrySpacing() {
        return 20.0f * this.compactness.getSpacing();
    }

    public void setCompactness(SelectHotbarAbilitiesScreen.Compactness compactness) {
        this.compactness = compactness;
    }

    protected void drawGradientRect(MatrixStack stack, int left, int top, int right, int bottom, int color1, int color2) {
    }

    protected int getScrollAmount() {
        return 15;
    }

    protected void drawPanel(MatrixStack matrixStack, int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
        float y2;
        float y = relativeY;
        float x = this.parent.field_230708_k_ / 2 - 100 + 40;
        for (AbilityCore<IAbility> core : this.unlockedAbilities) {
            boolean isHovering;
            if (core == null) continue;
            IAbility abl = this.unlockedToEquippedMap.get(core);
            int color = 0xFFFFFF;
            boolean bl = isHovering = (float)mouseX >= x && (float)mouseY >= y && (float)mouseX < x + (float)this.width && (float)mouseY < y + this.getEntrySpacing();
            if (this.props.hasEquippedAbility(core)) {
                color = 0xFF0000;
            } else if (isHovering) {
                color = 10014975;
            }
            RenderSystem.enableBlend();
            this.mc.func_110434_K().func_110577_a(ModResources.WIDGETS);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(x - 34.0f + (float)this.compactness.getSlotOffsetX()), (double)(y - (float)this.compactness.getSlotOffsetY()), 0.0);
            matrixStack.func_227862_a_(this.compactness.getSlotScale(), this.compactness.getSlotScale(), 1.0f);
            this.func_238474_b_(matrixStack, 0, 0, 0, 0, 23, 23);
            matrixStack.func_227865_b_();
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 250.0);
            WyHelper.drawStringWithBorder(this.mc.field_71466_p, matrixStack, abl.getDisplayName(), (int)x, (int)y + 4, color);
            RendererHelper.drawIcon(abl.getIcon((LivingEntity)this.player), matrixStack, MathHelper.func_76141_d((float)x) - 30 + this.compactness.getIconOffsetX(), MathHelper.func_76141_d((float)y) + this.compactness.getIconOffsetY(), 1.0f, this.compactness.getIconSize(), this.compactness.getIconSize());
            matrixStack.func_227865_b_();
            y2 = y;
            abl.getComponent(ModAbilityKeys.DISABLE).ifPresent(comp -> {
                if (comp.isDisabled()) {
                    RendererHelper.drawIcon(ModResources.DISABLED_ABILITY, matrixStack, MathHelper.func_76141_d((float)x) - 30, MathHelper.func_76141_d((float)y2), 3.0f, 16.0f, 16.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            });
            y += this.getEntrySpacing();
        }
        if (this.passiveAbilities.size() > 0) {
            matrixStack.func_227861_a_(0.0, 0.0, 250.0);
            WyHelper.drawStringWithBorder(this.mc.field_71466_p, matrixStack, (ITextComponent)new StringTextComponent("Passives"), (int)x - 20, (int)y + 4, 0x8B8B8B);
            matrixStack.func_227861_a_(0.0, 0.0, -250.0);
            y += this.getEntrySpacing();
            for (IAbility abl : this.passiveAbilities) {
                if (abl == null) continue;
                Color textColor = WyHelper.hexToRGB("#aaff77");
                Color iconColor = WyHelper.hexToRGB("#FFFFFF");
                Optional<PauseTickComponent> pauseComp = abl.getComponent(ModAbilityKeys.PAUSE_TICK);
                if (pauseComp.isPresent() && pauseComp.get().isPaused()) {
                    textColor = iconColor = WyHelper.hexToRGB("#FF0000");
                }
                RenderSystem.enableBlend();
                this.mc.func_110434_K().func_110577_a(ModResources.WIDGETS);
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)(x - 34.0f + (float)this.compactness.getSlotOffsetX()), (double)(y - (float)this.compactness.getSlotOffsetY()), 0.0);
                matrixStack.func_227862_a_(this.compactness.getSlotScale(), this.compactness.getSlotScale(), 1.0f);
                this.func_238474_b_(matrixStack, 0, 0, 0, 0, 23, 23);
                matrixStack.func_227865_b_();
                matrixStack.func_227861_a_(0.0, 0.0, 250.0);
                WyHelper.drawStringWithBorder(this.mc.field_71466_p, matrixStack, abl.getDisplayName(), (int)x, (int)y + 4, textColor.getRGB());
                RendererHelper.drawIcon(abl.getIcon((LivingEntity)this.player), matrixStack, MathHelper.func_76141_d((float)x) - 30 + this.compactness.getIconOffsetX(), MathHelper.func_76141_d((float)y) + this.compactness.getIconOffsetY(), 1.0f, this.compactness.getIconSize(), this.compactness.getIconSize(), (float)iconColor.getRed() / 255.0f, (float)iconColor.getGreen() / 255.0f, (float)iconColor.getBlue() / 255.0f, 1.0f);
                matrixStack.func_227861_a_(0.0, 0.0, -250.0);
                y2 = y;
                abl.getComponent(ModAbilityKeys.DISABLE).ifPresent(comp -> {
                    if (comp.isDisabled()) {
                        RendererHelper.drawIcon(ModResources.DISABLED_ABILITY, matrixStack, MathHelper.func_76141_d((float)x) - 30, MathHelper.func_76141_d((float)y2), 3.0f, 16.0f, 16.0f, 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                });
                y += this.getEntrySpacing();
            }
        }
    }

    @Nullable
    private Entry<IAbility> findAbilityEntry(int mouseX, int mouseY) {
        double offset = (float)(mouseY - this.top) + this.scrollDistance;
        if (offset <= 0.0) {
            return null;
        }
        int lineIdx = (int)(offset / (double)this.getEntrySpacing());
        if (lineIdx >= this.allAbilities.size()) {
            return null;
        }
        Entry<IAbility> entry = this.allAbilities.get(lineIdx);
        if (entry != null) {
            return entry;
        }
        return null;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        Entry<IAbility> entry = this.findAbilityEntry((int)mouseX, (int)mouseY);
        boolean flag = true;
        if (entry != null && this.func_231047_b_(mouseX, mouseY) && button == 0) {
            if (entry.isActive()) {
                if (this.parent.getSelectionMode() == SelectHotbarAbilitiesScreen.Selection.DRAG_AND_DROP && this.parent.slotSelected <= 0) {
                    this.parent.setDraggedAbility(((Entry)entry).abilityCore);
                } else if (this.parent.getSelectionMode() == SelectHotbarAbilitiesScreen.Selection.KEYBIND && this.parent.slotSelected >= 0 && flag && entry.getActive() != null) {
                    WyNetwork.sendToServer(new CEquipAbilityPacket(this.parent.slotSelected, entry.getActive()));
                    this.parent.isDirty = true;
                }
            } else if (entry.isPassive() && entry.getPassive() != null) {
                WyNetwork.sendToServer(new CTogglePassiveAbilityPacket(entry.getPassive().getCore()));
            }
        }
        if (WyDebug.isDebug() && entry != null && button == 1) {
            IAbility abl = null;
            if (entry.isActive()) {
                abl = this.unlockedToEquippedMap.get(entry.getActive());
            } else if (entry.isPassive()) {
                for (IAbility passive : this.passiveAbilities) {
                    if (!passive.equals(entry.getPassive())) continue;
                    abl = entry.getPassive();
                    break;
                }
            }
            if (abl != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("\u00a75" + abl.getDisplayName().getString() + "\u00a7r\n");
                for (AbilityComponent<?> comp : abl.getComponents().values()) {
                    if (!comp.getBonusManagers().hasNext()) continue;
                    comp.getBonusManagers().forEachRemaining(m -> {
                        if (!m.getBonuses().isEmpty()) {
                            sb.append("\u00a76" + comp.getKey().getId() + "\u00a7r\n");
                            return;
                        }
                    });
                    comp.getBonusManagers().forEachRemaining(m -> m.getBonuses().forEach(e -> {
                        sb.append("  \u00a72" + e.getKey() + "\u00a7r\n");
                        sb.append("  " + ((BonusManager.BonusValue)e.getValue()).toString() + "\n\n");
                    }));
                }
                this.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(sb.toString()), Util.field_240973_b_);
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        return mouseX >= (double)this.left && mouseY >= (double)this.top && mouseX < (double)(this.left + this.width - 5) && mouseY < (double)(this.top + this.height);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.hoveredEntry = null;
        if (this.func_231047_b_(mouseX, mouseY)) {
            this.hoveredEntry = this.findAbilityEntry(mouseX, mouseY);
            if (this.hoveredEntry == null) {
                return;
            }
            IAbility abl = null;
            if (this.hoveredEntry.isActive()) {
                abl = this.unlockedToEquippedMap.get(this.hoveredEntry.getActive());
            } else if (this.hoveredEntry.isPassive()) {
                abl = this.hoveredEntry.getPassive();
            }
            if (abl != null && !this.parent.hasDraggedAbility() && SelectHotbarAbilitiesScreen.canShowTooltips()) {
                SelectHotbarAbilitiesScreen.renderAbilityTooltip(matrixStack, mouseX, mouseY, abl);
            }
        }
    }

    @Nullable
    public AbilityCore<?> getHoveredEntry() {
        if (this.hoveredEntry != null) {
            return this.hoveredEntry.getActive();
        }
        return null;
    }

    class Entry<T extends IAbility> {
        @Nullable
        private T ability;
        @Nullable
        private AbilityCore<T> abilityCore;

        public Entry() {
        }

        public Entry(T ability) {
            this.ability = ability;
        }

        public Entry(AbilityCore<T> abilityCore) {
            this.abilityCore = abilityCore;
        }

        public AbilityCore<T> getActive() {
            return this.abilityCore;
        }

        public boolean isActive() {
            return this.abilityCore != null;
        }

        public T getPassive() {
            return this.ability;
        }

        public boolean isPassive() {
            return this.ability != null;
        }
    }
}

