/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.crew.JollyRoger;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.client.crew.CLeaveCrewPacket;
import xyz.pixelatedw.mineminenomi.packets.client.ui.COpenJollyRogerCreatorScreenPacket;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.PlankButton;
import xyz.pixelatedw.mineminenomi.screens.extra.panels.CrewMembersListPanel;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@OnlyIn(value=Dist.CLIENT)
public class CrewDetailsScreen
extends Screen {
    private PlayerEntity player;
    private JollyRoger jollyRoger;
    private final Crew crew;
    private CrewMembersListPanel membersListPanel;

    public CrewDetailsScreen(Crew crew) {
        super((ITextComponent)new StringTextComponent(""));
        this.field_230706_i_ = Minecraft.func_71410_x();
        this.player = this.field_230706_i_.field_71439_g;
        this.crew = crew;
    }

    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float f) {
        this.func_230446_a_(matrixStack);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int posX = (this.field_230708_k_ - 256) / 2;
        int posY = (this.field_230709_l_ - 256) / 2;
        posY -= 20;
        String nameString = new TranslationTextComponent(ModI18n.GUI_NAME).getString();
        String jollyRogerString = new TranslationTextComponent(ModI18n.GUI_CREW_JOLLY_ROGER).getString();
        String membersString = new TranslationTextComponent(ModI18n.GUI_CREW_MEMBERS).getString();
        String crewActual = "";
        if (this.crew == null) {
            return;
        }
        crewActual = this.crew.getName();
        WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, TextFormatting.BOLD + nameString + ": " + TextFormatting.RESET + crewActual, posX - 50, posY + 50, -1);
        WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, TextFormatting.BOLD + jollyRogerString + ": ", posX - 50, posY + 70, -1);
        WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, TextFormatting.BOLD + membersString + ": ", posX + 150, posY + 50, -1);
        matrixStack.func_227860_a_();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        float scale = 0.4f;
        matrixStack.func_227861_a_((double)(posX - 110), (double)(posY + 15), 1.0);
        matrixStack.func_227861_a_(128.0, 128.0, 0.0);
        matrixStack.func_227862_a_(scale, scale, scale);
        matrixStack.func_227861_a_(-128.0, -128.0, 0.0);
        if (this.jollyRoger != null) {
            RendererHelper.drawPlayerJollyRoger(this.jollyRoger, matrixStack);
        }
        RenderSystem.disableBlend();
        matrixStack.func_227865_b_();
        if (this.membersListPanel != null) {
            this.membersListPanel.func_230430_a_(matrixStack, x, y, f);
        }
        super.func_230430_a_(matrixStack, x, y, f);
    }

    public void func_231160_c_() {
        this.field_230705_e_.clear();
        this.field_230710_m_.clear();
        if (this.crew == null) {
            return;
        }
        this.membersListPanel = new CrewMembersListPanel(this, this.crew.getMembers());
        this.field_230705_e_.add(this.membersListPanel);
        this.func_231035_a_((IGuiEventListener)this.membersListPanel);
        UUID captainUUID = this.crew.getCaptain().getUUID();
        PlayerEntity crewCaptain = this.field_230706_i_.field_71441_e.func_217371_b(captainUUID);
        this.jollyRoger = this.crew.getJollyRoger();
        int posX = (this.field_230708_k_ - 256) / 2 - 50;
        int posY = (this.field_230709_l_ - 256) / 2;
        this.func_230480_a_((Widget)new PlankButton(posX += 80, (posY -= 20) + 240, 80, 26, (ITextComponent)new TranslationTextComponent(ModI18n.GUI_LEAVE), b -> {
            WyNetwork.sendToServer(new CLeaveCrewPacket());
            Minecraft.func_71410_x().func_147108_a(null);
        }));
        if (crewCaptain != null && this.player == crewCaptain) {
            this.func_230480_a_((Widget)new PlankButton(posX += 90, posY + 240, 120, 26, (ITextComponent)new TranslationTextComponent(ModI18n.GUI_CHANGE_JOLLY_ROGER), b -> WyNetwork.sendToServer(new COpenJollyRogerCreatorScreenPacket())));
        }
    }

    public static void open(Crew crew) {
        Minecraft.func_71410_x().func_147108_a((Screen)new CrewDetailsScreen(crew));
    }
}

