/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.charactercreator.CharacterCreatorEntry;
import xyz.pixelatedw.mineminenomi.api.charactercreator.CharacterCreatorSelectionMap;
import xyz.pixelatedw.mineminenomi.api.charactercreator.ICharacterCreatorEntry;
import xyz.pixelatedw.mineminenomi.api.charactercreator.RaceId;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.client.CFinishCCPacket;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.AbilitySlotButton;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.SimpleButton;
import xyz.pixelatedw.mineminenomi.screens.extra.buttons.TexturedIconButton;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

@OnlyIn(value=Dist.CLIENT)
public class CharacterCreatorScreen
extends Screen {
    private final ClientPlayerEntity player;
    private ResourceLocation icon = ModResources.RANDOM;
    private ITextComponent label = ModI18n.GUI_RANDOM;
    private List<AbilityCore<?>> topAbilities = new ArrayList();
    private List<AbilityCore<?>> bottomAbilities = new ArrayList();
    private int page;
    private int maxOpt;
    private int renderTick = 0;
    private int minkTextureId = 0;
    private int[] options = new int[3];
    private TexturedIconButton factionButton;
    private TexturedIconButton raceButton;
    private TexturedIconButton styleButton;
    private final List<AbilitySlotButton> abilitySlots = Lists.newArrayList();
    private boolean hasRandomizedRace;
    private boolean allowMinkRaceSelect;

    public CharacterCreatorScreen(boolean hasRandomizedRace, boolean allowMinkRaceSelect) {
        super(StringTextComponent.field_240750_d_);
        this.field_230706_i_ = Minecraft.func_71410_x();
        this.player = this.field_230706_i_.field_71439_g;
        this.hasRandomizedRace = hasRandomizedRace;
        this.allowMinkRaceSelect = allowMinkRaceSelect;
    }

    public void func_230430_a_(MatrixStack matrixStack, int x, int y, float f) {
        this.func_230446_a_(matrixStack);
        int posX = this.field_230708_k_ / 2;
        int posY = this.field_230709_l_ / 2;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.BOOK);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(posX - 120), (double)(posY - 80), 0.0);
        matrixStack.func_227861_a_(128.0, 128.0, 0.0);
        matrixStack.func_227862_a_(1.2f, 1.2f, 1.2f);
        matrixStack.func_227861_a_(-128.0, -128.0, 0.0);
        GuiUtils.drawTexturedModalRect((MatrixStack)matrixStack, (int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (float)0.0f);
        matrixStack.func_227865_b_();
        posX += 65;
        posY -= 20;
        if (!this.allowMinkRaceSelect && this.renderTick % 150 == 0) {
            this.increaseMinkRace();
        }
        this.drawCategoryIcon(matrixStack, this.icon, posX - 115, posY - 120, 0.7f);
        this.drawCategoryLabel(matrixStack, this.label, posX + 75, posY - 5, 1.5f);
        for (AbilitySlotButton btn : this.abilitySlots) {
            btn.func_230430_a_(matrixStack, x, y, f);
        }
        ++this.renderTick;
        super.func_230430_a_(matrixStack, x, y, f);
    }

    public void func_231160_c_() {
        int posX = (this.field_230708_k_ - 256) / 2;
        int posY = (this.field_230709_l_ - 256) / 2;
        posX += 65;
        posY -= 40;
        this.factionButton = new TexturedIconButton(ModResources.BUTTON, (posX -= 65) - 85, (posY += 5) + 65, 90, 40, (ITextComponent)ModI18n.FACTION_NAME, btn -> {
            this.page = 0;
            this.resetButtonState();
            this.factionButton.setIsPressed(true);
            ((Widget)this.field_230710_m_.get((int)5)).field_230694_p_ = false;
            ((Widget)this.field_230710_m_.get((int)6)).field_230694_p_ = false;
        });
        this.factionButton = this.factionButton.setTextureInfo(posX - 90, posY + 60, 100, 50).setTextInfo(posX - 10, posY + 128, 1.4f);
        this.func_230480_a_((Widget)this.factionButton);
        this.raceButton = new TexturedIconButton(ModResources.BUTTON, posX - 85, (posY += 45) + 65, 90, 40, (ITextComponent)ModI18n.RACE_NAME, btn -> {
            this.page = 1;
            this.resetButtonState();
            this.raceButton.setIsPressed(true);
            this.applyMinkSwitcher();
        });
        this.raceButton = this.raceButton.setTextureInfo(posX - 90, posY + 60, 100, 50).setTextInfo(posX - 10, posY + 128, 1.4f);
        this.func_230480_a_((Widget)this.raceButton);
        this.styleButton = new TexturedIconButton(ModResources.BUTTON, posX - 85, (posY += 45) + 65, 90, 40, (ITextComponent)ModI18n.STYLE_NAME, btn -> {
            this.page = 2;
            this.resetButtonState();
            this.styleButton.setIsPressed(true);
            ((Widget)this.field_230710_m_.get((int)5)).field_230694_p_ = false;
            ((Widget)this.field_230710_m_.get((int)6)).field_230694_p_ = false;
        });
        this.styleButton = this.styleButton.setTextureInfo(posX - 90, posY + 60, 100, 50).setTextInfo(posX - 10, posY + 128, 1.4f);
        this.func_230480_a_((Widget)this.styleButton);
        posX += 65;
        posY -= 95;
        TexturedIconButton prevButton = new TexturedIconButton(ModResources.RED_ARROW_LEFT, (posX += 30) + 60, (posY += 130) + 80, 40, 20, StringTextComponent.field_240750_d_, btn -> {
            this.decreaseSelectedPage();
            this.applyMinkSwitcher();
        });
        prevButton = prevButton.setTextureInfo(posX + 62, posY + 82, 35, 17);
        this.func_230480_a_((Widget)prevButton);
        TexturedIconButton nextButton = new TexturedIconButton(ModResources.RED_ARROW_RIGHT, (posX -= 90) + 215, posY + 80, 40, 20, StringTextComponent.field_240750_d_, btn -> {
            this.increaseSelectedPage();
            this.applyMinkSwitcher();
        });
        nextButton = nextButton.setTextureInfo(posX + 218, posY + 82, 35, 17);
        this.func_230480_a_((Widget)nextButton);
        TexturedIconButton minkDecrease = new TexturedIconButton(ModResources.RED_ARROW_LEFT, (posX += 30) + 100, (posY -= 110) + 110, 30, 50, StringTextComponent.field_240750_d_, btn -> this.decreaseMinkRace());
        minkDecrease = minkDecrease.setTextureInfo(posX + 100, posY + 110, 30, 50);
        ((TexturedIconButton)this.func_230480_a_((Widget)minkDecrease)).field_230694_p_ = false;
        TexturedIconButton minkIncrease = new TexturedIconButton(ModResources.RED_ARROW_RIGHT, (posX -= 5) + 215, posY + 110, 30, 50, StringTextComponent.field_240750_d_, btn -> this.increaseMinkRace());
        minkIncrease = minkIncrease.setTextureInfo(posX + 215, posY + 110, 30, 50);
        ((TexturedIconButton)this.func_230480_a_((Widget)minkIncrease)).field_230694_p_ = false;
        SimpleButton finishButton = new SimpleButton((posX -= 120) + 115, (posY += 30) + 175, 70, 30, (ITextComponent)new TranslationTextComponent(ModI18n.GUI_FINISH), btn -> this.completeCreation());
        finishButton.setTextOnly();
        finishButton.setFontSize(1.5f);
        this.func_230480_a_((Widget)finishButton);
        this.createAbilitySlotButtons();
    }

    private void applyMinkSwitcher() {
        if (this.allowMinkRaceSelect && this.isOnMinkPage()) {
            ((Widget)this.field_230710_m_.get((int)5)).field_230694_p_ = true;
            ((Widget)this.field_230710_m_.get((int)6)).field_230694_p_ = true;
        } else {
            ((Widget)this.field_230710_m_.get((int)5)).field_230694_p_ = false;
            ((Widget)this.field_230710_m_.get((int)6)).field_230694_p_ = false;
        }
    }

    private boolean isOnMinkPage() {
        return this.page == 1 && this.getSelectedRaceId() == 4;
    }

    private void resetButtonState() {
        this.factionButton.setIsPressed(false);
        this.raceButton.setIsPressed(false);
        this.styleButton.setIsPressed(false);
        this.updateSelection();
    }

    private void completeCreation() {
        Minecraft.func_71410_x().func_147108_a(null);
        WyNetwork.sendToServer(new CFinishCCPacket(this.getSelectedFactionId() - 1, this.getSelectedRaceId() - 1, this.getSelectedStyleId() - 1, this.minkTextureId));
    }

    public void func_231023_e_() {
        this.maxOpt = CharacterCreatorEntry.values()[this.page].getSize() + 1;
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    private void drawCategory(MatrixStack matrixStack, String text, int posX, int posY, float scale) {
        this.drawCategoryLabel(matrixStack, (ITextComponent)new StringTextComponent(text), posX, posY, scale);
    }

    private void drawCategoryIcon(MatrixStack matrixStack, ResourceLocation icon, int posX, int posY, float scale) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(icon);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)posX, (double)posY, 2.0);
        matrixStack.func_227861_a_(128.0, 128.0, 0.0);
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        matrixStack.func_227861_a_(-128.0, -128.0, 0.0);
        GuiUtils.drawTexturedModalRect((MatrixStack)matrixStack, (int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (float)1.0f);
        matrixStack.func_227865_b_();
    }

    private void drawCategoryLabel(MatrixStack matrixStack, ITextComponent text, int posX, int posY, float scale) {
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)posX, (double)posY, 2.0);
        matrixStack.func_227861_a_(128.0, 128.0, 0.0);
        matrixStack.func_227862_a_(scale, scale, 1.0f);
        matrixStack.func_227861_a_(-128.0, -128.0, 0.0);
        WyHelper.drawStringWithBorder(this.field_230712_o_, matrixStack, text, -this.field_230712_o_.func_238414_a_((ITextProperties)text) / 2, 0, -1);
        matrixStack.func_227865_b_();
    }

    public int getSelectedFactionId() {
        return this.options[0];
    }

    public int getSelectedRaceId() {
        return this.options[1];
    }

    public int getSelectedStyleId() {
        return this.options[2];
    }

    public int getSelectedId() {
        return this.options[this.page];
    }

    public void increaseSelectedPage() {
        if (this.options[this.page] + 1 < this.maxOpt) {
            int n = this.page;
            this.options[n] = this.options[n] + 1;
        } else {
            this.options[this.page] = 0;
        }
        this.updateSelection();
    }

    public void decreaseSelectedPage() {
        if (this.options[this.page] - 1 > -1) {
            int n = this.page;
            this.options[n] = this.options[n] - 1;
        } else {
            this.options[this.page] = this.maxOpt - 1;
        }
        this.updateSelection();
    }

    private void updateSelection() {
        CharacterCreatorEntry value = CharacterCreatorEntry.values()[this.page];
        ICharacterCreatorEntry entry = this.getSelectedId() == 0 ? ICharacterCreatorEntry.RANDOM : value.getInfo(this.getSelectedId() - 1);
        CharacterCreatorSelectionMap.SelectionInfo info = entry.getInfo();
        if (info != null) {
            if (entry instanceof RaceId && !((RaceId)entry).getSubRaces().isEmpty()) {
                this.updateMinkSelection();
            } else {
                this.icon = info.getIcon();
            }
            this.label = this.getSelectedId() == 0 ? ModI18n.GUI_RANDOM : value.getLocalizedTitle(entry.getRegistryName());
            this.topAbilities = info.getTopAbilities();
            this.bottomAbilities = info.getBottomAbilities();
            this.createAbilitySlotButtons();
        }
    }

    private void createAbilitySlotButtons() {
        AbilitySlotButton slot;
        Object abl;
        int posX = (this.field_230708_k_ - 256) / 2;
        int posY = (this.field_230709_l_ - 256) / 2;
        this.abilitySlots.clear();
        int i = 0;
        int xOffset = 0;
        int yOffset = 0;
        for (AbilityCore<?> core : this.topAbilities) {
            if (i % 3 == 0) {
                xOffset = 0;
                yOffset += 30;
            } else {
                xOffset += 38;
            }
            abl = core.createAbility();
            slot = new AbilitySlotButton((IAbility)abl, posX + 20 + xOffset, posY + 10 + yOffset, 22, 22, (PlayerEntity)this.player, btn -> {});
            this.abilitySlots.add(slot);
            this.func_230481_d_((IGuiEventListener)slot);
            ++i;
        }
        i = 0;
        xOffset = 0;
        yOffset = 0;
        for (AbilityCore<?> core : this.bottomAbilities) {
            if (i % 3 == 0) {
                xOffset = 0;
                yOffset += 30;
            } else {
                xOffset += 38;
            }
            abl = core.createAbility();
            slot = new AbilitySlotButton((IAbility)abl, posX + 20 + xOffset, posY + 100 + yOffset, 22, 22, (PlayerEntity)this.player, btn -> {});
            this.abilitySlots.add(slot);
            this.func_230481_d_((IGuiEventListener)slot);
            ++i;
        }
    }

    public void increaseMinkRace() {
        this.minkTextureId = this.minkTextureId == this.getCurrentSubRaces().size() - 1 ? 0 : ++this.minkTextureId;
        this.updateMinkSelection();
    }

    private List<String> getCurrentSubRaces() {
        if (this.getCurrentInfo() instanceof RaceId) {
            return ((RaceId)this.getCurrentInfo()).getSubRaces();
        }
        return new ArrayList<String>();
    }

    private ICharacterCreatorEntry getCurrentInfo() {
        if (this.getSelectedRaceId() == 0) {
            return ICharacterCreatorEntry.RANDOM;
        }
        return CharacterCreatorEntry.values()[this.page].getInfo(this.getSelectedId() - 1);
    }

    public void decreaseMinkRace() {
        this.minkTextureId = this.minkTextureId == 0 ? this.getCurrentSubRaces().size() - 1 : --this.minkTextureId;
        this.updateMinkSelection();
    }

    private void updateMinkSelection() {
        ResourceLocation race = this.getCurrentInfo().getRegistryName();
        this.icon = new ResourceLocation(race.func_110624_b(), "textures/gui/icons/" + race.func_110623_a() + (this.minkTextureId + 1) + ".png");
    }

    public static void open(boolean hasRandomizedRace, boolean allowMinkRaceSelect) {
        Minecraft.func_71410_x().func_147108_a((Screen)new CharacterCreatorScreen(hasRandomizedRace, allowMinkRaceSelect));
    }
}

