/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.api.effects.IBlockOverlayEffect;
import xyz.pixelatedw.mineminenomi.api.effects.IColorOverlayEffect;
import xyz.pixelatedw.mineminenomi.api.effects.ITextureOverlayEffect;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.models.abilities.TornadoModel;

@OnlyIn(value=Dist.CLIENT)
public class PotionLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    private final TornadoModel tornadoModel = new TornadoModel();

    public PotionLayer(IEntityRenderer renderer) {
        super(renderer);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Effect effect;
        for (EffectInstance instance : entity.func_70651_bq()) {
            effect = instance.func_188419_a();
            if (!entity.func_70644_a(effect) || entity.func_70660_b(effect).func_76459_b() > 0) continue;
            entity.func_195063_d(effect);
        }
        for (EffectInstance instance : entity.func_70651_bq()) {
            ResourceLocation res;
            int z;
            int y;
            effect = instance.func_188419_a();
            if (effect == ModEffects.PUNK_CROSS.get()) {
                matrixStack.func_227860_a_();
                float blocksWidth = (float)(Math.ceil(entity.func_213311_cf()) + 1.0);
                float blocksHeight = (float)(Math.ceil(entity.func_213302_cg()) + 1.0);
                matrixStack.func_227861_a_((double)(0.4f - blocksWidth / 2.0f), (double)(1.4f - entity.func_213302_cg() / 2.0f - blocksHeight / 2.0f), (double)(0.4f - blocksWidth / 2.0f));
                matrixStack.func_227861_a_(0.0, -2.0, 0.0);
                Random rand = new Random();
                int x = 0;
                while ((float)x < blocksWidth) {
                    y = 0;
                    while ((float)y < blocksHeight + 2.0f) {
                        z = 0;
                        while ((float)z < blocksWidth) {
                            int seed = 1 + x + y + z;
                            rand.setSeed(seed);
                            int w = rand.nextInt(180);
                            matrixStack.func_227860_a_();
                            matrixStack.func_227861_a_((double)x, (double)y, (double)z);
                            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)w));
                            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(-w)));
                            Minecraft.func_71410_x().func_175599_af().func_229110_a_(new ItemStack((IItemProvider)Blocks.field_150339_S), ItemCameraTransforms.TransformType.HEAD, packedLight, OverlayTexture.field_229196_a_, matrixStack, buffer);
                            matrixStack.func_227865_b_();
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                matrixStack.func_227861_a_(-1.5, 1.0, 0.5);
                x = 0;
                while ((float)x < blocksHeight + 2.0f) {
                    y = 0;
                    while ((float)y < blocksWidth) {
                        int seed = 1 + x + y;
                        rand.setSeed(seed);
                        int w = rand.nextInt(180);
                        matrixStack.func_227860_a_();
                        matrixStack.func_227861_a_((double)x, (double)y, 0.0);
                        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)w));
                        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)(-w)));
                        Minecraft.func_71410_x().func_175599_af().func_229110_a_(new ItemStack((IItemProvider)Blocks.field_150339_S), ItemCameraTransforms.TransformType.HEAD, packedLight, OverlayTexture.field_229196_a_, matrixStack, buffer);
                        matrixStack.func_227865_b_();
                        ++y;
                    }
                    ++x;
                }
                matrixStack.func_227865_b_();
                continue;
            }
            if (effect == ModEffects.CYCLONE_TEMPO.get()) {
                matrixStack.func_227860_a_();
                float width = entity.func_213311_cf() * 6.0f;
                float height = entity.func_213302_cg() * 1.15f;
                matrixStack.func_227862_a_(width, height, width);
                matrixStack.func_227861_a_(0.0, (double)-0.3f, 0.0);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)((LivingEntity)entity).field_70173_aa * (float)Math.PI * 1.5f));
                IVertexBuilder vertex = buffer.getBuffer(ModRenderTypes.TRANSPARENT_COLOR);
                this.tornadoModel.func_225598_a_(matrixStack, vertex, packedLight, OverlayTexture.field_229196_a_, 0.5f, 0.8f, 1.0f, 0.4f);
                float anim = (float)Math.sin((float)instance.func_76459_b() % 20.0f / 20.0f * 3.0f);
                matrixStack.func_227862_a_(anim, anim, anim);
                matrixStack.func_227861_a_(0.0, (double)-0.1f, 0.0);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)((LivingEntity)entity).field_70173_aa * (float)Math.PI * 2.5f));
                this.tornadoModel.func_225598_a_(matrixStack, vertex, packedLight, OverlayTexture.field_229196_a_, 0.5f, 0.8f, 1.0f, 0.4f);
                matrixStack.func_227865_b_();
                continue;
            }
            if (effect instanceof IBlockOverlayEffect) {
                Block overlay = ((IBlockOverlayEffect)effect).getBlockOverlay(instance.func_76459_b(), instance.func_76458_c());
                if (overlay == null) continue;
                matrixStack.func_227860_a_();
                float blocksWidth = (float)(Math.ceil(entity.func_213311_cf()) + 1.0);
                float blocksHeight = (float)(Math.ceil(entity.func_213302_cg()) + 1.0);
                matrixStack.func_227861_a_((double)(0.4f - blocksWidth / 2.0f), (double)(1.4f - entity.func_213302_cg() / 2.0f - blocksHeight / 2.0f), (double)(0.4f - blocksWidth / 2.0f));
                int x = 0;
                while ((float)x < blocksWidth) {
                    y = 0;
                    while ((float)y < blocksHeight) {
                        z = 0;
                        while ((float)z < blocksWidth) {
                            matrixStack.func_227860_a_();
                            matrixStack.func_227861_a_((double)x, (double)y, (double)z);
                            Minecraft.func_71410_x().func_175599_af().func_229110_a_(new ItemStack((IItemProvider)overlay), ItemCameraTransforms.TransformType.HEAD, packedLight, OverlayTexture.field_229196_a_, matrixStack, buffer);
                            matrixStack.func_227865_b_();
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
                matrixStack.func_227865_b_();
                continue;
            }
            if (effect instanceof IColorOverlayEffect) {
                float[] colors = ((IColorOverlayEffect)effect).getBodyOverlayColor(instance.func_76459_b(), instance.func_76458_c());
                if (colors == null) continue;
                matrixStack.func_227860_a_();
                IVertexBuilder vertex = buffer.getBuffer(ModRenderTypes.TRANSPARENT_COLOR);
                this.func_215332_c().func_225598_a_(matrixStack, vertex, packedLight, OverlayTexture.field_229196_a_, colors[0], colors[1], colors[2], colors[3]);
                matrixStack.func_227865_b_();
                continue;
            }
            if (!(effect instanceof ITextureOverlayEffect) || (res = ((ITextureOverlayEffect)effect).getBodyTexture(instance.func_76459_b(), instance.func_76458_c())) == null) continue;
            matrixStack.func_227860_a_();
            IVertexBuilder vertex = buffer.getBuffer(ModRenderTypes.getAbilityBody(res));
            float[] colors = ((ITextureOverlayEffect)effect).getOverlayColor();
            this.func_215332_c().func_225598_a_(matrixStack, vertex, packedLight, OverlayTexture.field_229196_a_, colors[0], colors[1], colors[2], colors[3]);
            matrixStack.func_227865_b_();
        }
    }
}

