/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.abilities.doku;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.entities.projectiles.doku.HydraProjectile;
import xyz.pixelatedw.mineminenomi.models.abilities.CubeModel;
import xyz.pixelatedw.mineminenomi.models.entities.projectiles.HydraModel;
import xyz.pixelatedw.mineminenomi.renderers.abilities.StretchingProjectileRenderer;

public class HydraRenderer<M extends EntityModel<HydraProjectile>>
extends StretchingProjectileRenderer<HydraProjectile, M> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mineminenomi", "textures/models/projectiles/hydra_full.png");
    private static final Color NORMAL_COLOR = new Color(255, 255, 255, 100);
    private static final Color DEMON_COLOR = new Color(255, 0, 0, 100);
    private static final Vector3f NORMAL_SCALE = new Vector3f(5.5f, 5.5f, 5.5f);
    private static final Vector3f DEMON_SCALE = new Vector3f(7.5f, 7.5f, 7.5f);

    public HydraRenderer(EntityRendererManager renderManager, M model) {
        super(renderManager, model, new CubeModel());
        this.setTexture(TEXTURE);
        this.setNormalDetails();
    }

    public boolean shouldRender(HydraProjectile pLivingEntity, ClippingHelper pCamera, double pCamX, double pCamY, double pCamZ) {
        return true;
    }

    @Override
    public void render(HydraProjectile entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        super.render(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        if (entity.isDemonMode()) {
            this.setDemonDetails();
        } else {
            this.setNormalDetails();
        }
    }

    private void setDemonDetails() {
        this.setColor(DEMON_COLOR);
        this.setScale(DEMON_SCALE);
        this.setStretchScale(DEMON_SCALE.func_195899_a(), DEMON_SCALE.func_195900_b(), 8.0);
    }

    private void setNormalDetails() {
        this.setColor(NORMAL_COLOR);
        this.setScale(NORMAL_SCALE);
        this.setStretchScale(NORMAL_SCALE.func_195899_a(), NORMAL_SCALE.func_195900_b(), 8.0);
    }

    public static class Factory
    implements IRenderFactory<HydraProjectile> {
        public HydraRenderer createRenderFor(EntityRendererManager manager) {
            return new HydraRenderer(manager, new HydraModel());
        }
    }
}

