/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.abilities;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.IFlexibleSizeProjectile;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.models.abilities.CubeModel;
import xyz.pixelatedw.mineminenomi.models.abilities.EntityArmModel;
import xyz.pixelatedw.mineminenomi.renderers.abilities.effects.SpiralEffectRenderer;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

@OnlyIn(value=Dist.CLIENT)
public class AbilityProjectileRenderer<T extends AbilityProjectileEntity, M extends EntityModel<T>>
extends EntityRenderer<T> {
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float scaleZ = 1.0f;
    private float rotationX = 0.0f;
    private float rotationY = 0.0f;
    private float rotationZ = 0.0f;
    protected double translateX = 0.0;
    protected double translateY = 0.0;
    protected double translateZ = 0.0;
    private Color colour;
    protected M model;
    private ResourceLocation texture;
    private boolean usePlayerTexture;
    private boolean isGlowing;
    private SpiralEffectRenderer spiralEffectRenderer;

    public AbilityProjectileRenderer(EntityRendererManager renderManager, M model, @Nullable Set<Effect> effects) {
        super(renderManager);
        this.model = model;
        if (effects != null && effects.contains((Object)Effect.SPIRAL)) {
            this.spiralEffectRenderer = new SpiralEffectRenderer(renderManager);
        }
    }

    public void setTexture(ResourceLocation res) {
        this.texture = res;
    }

    public void setPlayerTexture(boolean flag) {
        this.usePlayerTexture = flag;
    }

    public Color getColor() {
        return this.colour;
    }

    public void setColor(Color colour) {
        this.colour = colour;
    }

    public void setGlowing(boolean flag) {
        this.isGlowing = flag;
    }

    public boolean isGlowing() {
        return this.isGlowing;
    }

    public void setScale(float scaleX, float scaleY, float scaleZ) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
    }

    public void setScale(Vector3f scale) {
        this.scaleX = scale.func_195899_a();
        this.scaleY = scale.func_195900_b();
        this.scaleZ = scale.func_195902_c();
    }

    public void setScale(float scale) {
        this.scaleY = this.scaleZ = scale;
        this.scaleX = this.scaleZ;
    }

    public void setRotation(float rotationX, float rotationY, float rotationZ) {
        this.rotationX = rotationX;
        this.rotationY = rotationY;
        this.rotationZ = rotationZ;
    }

    public void setTranslate(double tX, double tY, double tZ) {
        this.translateX = tX;
        this.translateY = tY;
        this.translateZ = tZ;
    }

    public Vector3d getScale() {
        return new Vector3d((double)this.scaleX, (double)this.scaleY, (double)this.scaleZ);
    }

    public void render(T entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        if (((AbilityProjectileEntity)((Object)entity)).field_70173_aa < 2) {
            return;
        }
        if (entity instanceof IFlexibleSizeProjectile) {
            this.setScale(((IFlexibleSizeProjectile)entity).getSize());
        }
        if (Minecraft.func_71410_x().func_175598_ae().func_178634_b() && !entity.func_82150_aj() && !Minecraft.func_71410_x().func_189648_am()) {
            this.renderDebugBox(matrixStack, buffer.getBuffer(RenderType.func_228659_m_()), entity);
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)((AbilityProjectileEntity)((Object)entity)).field_70126_B, (float)((AbilityProjectileEntity)((Object)entity)).field_70177_z) + 180.0f + this.rotationX));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_219799_g((float)partialTicks, (float)((AbilityProjectileEntity)((Object)entity)).field_70127_C, (float)((AbilityProjectileEntity)((Object)entity)).field_70125_A) + this.rotationY));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(this.rotationZ));
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        matrixStack.func_227862_a_(this.scaleX, this.scaleY, this.scaleZ);
        matrixStack.func_227861_a_(this.translateX, this.translateY, this.translateZ);
        RenderType type = this.getRenderType();
        ResourceLocation finalTexture = this.getTextureLocation((AbilityProjectileEntity)((Object)entity));
        if (type == null) {
            type = finalTexture == null ? (this.isGlowing() ? ModRenderTypes.getEnergyRenderType() : ModRenderTypes.TRANSPARENT_COLOR) : RenderType.func_228644_e_((ResourceLocation)finalTexture);
        }
        boolean isSlim = false;
        if (((AbilityProjectileEntity)((Object)entity)).getThrower() instanceof ClientPlayerEntity) {
            isSlim = ((AbstractClientPlayerEntity)((AbilityProjectileEntity)((Object)entity)).getThrower()).func_175154_l().equals("slim");
        }
        if (isSlim && this.model instanceof EntityArmModel) {
            try {
                this.model = (EntityModel)this.model.getClass().getConstructor(Boolean.TYPE).newInstance(isSlim);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        float ageInTicks = (float)((AbilityProjectileEntity)((Object)entity)).field_70173_aa + partialTicks;
        if (this.model != null) {
            boolean haoshokuInfusionCheck;
            this.model.func_225597_a_(entity, 0.0f, 0.0f, ageInTicks, 0.0f, 0.0f);
            Color colour = this.getColor();
            boolean bl = haoshokuInfusionCheck = ((AbilityProjectileEntity)((Object)entity)).isAffectedByHaki() && HakiHelper.isProjectileHaoshokuInfused(entity);
            if (haoshokuInfusionCheck && !this.isGlowing() && ((AbilityProjectileEntity)((Object)entity)).getThrower() != null) {
                colour = new Color(HakiHelper.getHaoshokuColour(((AbilityProjectileEntity)((Object)entity)).getThrower()));
            }
            IVertexBuilder ivertexbuilder = buffer.getBuffer(type);
            this.model.func_225598_a_(matrixStack, ivertexbuilder, packedLight, OverlayTexture.field_229196_a_, (float)colour.getRed() / 255.0f, (float)colour.getGreen() / 255.0f, (float)colour.getBlue() / 255.0f, (float)colour.getAlpha() / 255.0f);
            this.renderHakiOverlay(this.model, entity, matrixStack, buffer, packedLight);
            if (this.spiralEffectRenderer != null) {
                this.spiralEffectRenderer.func_225623_a_(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
            }
        }
        matrixStack.func_227865_b_();
        super.func_225623_a_(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public void renderHakiOverlay(M model, T entity, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        boolean highlightCheck;
        LivingEntity thrower = ((AbilityProjectileEntity)((Object)entity)).getThrower();
        if (thrower == null) {
            return;
        }
        boolean bl = ((AbilityProjectileEntity)((Object)entity)).isAffectedByHardening() ? HakiHelper.hasAdvancedBusoActive(thrower) : (highlightCheck = ((AbilityProjectileEntity)((Object)entity)).isAffectedByHaki() && HakiHelper.isProjectileBusoshokuShrouded(entity));
        if (highlightCheck) {
            matrixStack.func_227860_a_();
            Color clientRGB = WyHelper.intToRGB(HakiHelper.getHaoshokuColour(thrower), 102);
            float scale = 1.1f;
            matrixStack.func_227862_a_(scale, scale, scale);
            IVertexBuilder ivb = buffer.getBuffer(ModRenderTypes.TRANSPARENT_COLOR);
            model.func_225598_a_(matrixStack, ivb, packedLight, OverlayTexture.field_229196_a_, (float)clientRGB.getRed() / 255.0f, (float)clientRGB.getGreen() / 255.0f, (float)clientRGB.getBlue() / 255.0f, (float)clientRGB.getAlpha() / 255.0f);
            matrixStack.func_227865_b_();
        }
    }

    private void renderDebugBox(MatrixStack matrixStack, IVertexBuilder vertexBuilder, T entity) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(-((AbilityProjectileEntity)((Object)entity)).getBlockCollisionBox().func_216364_b() / 2.0, -((AbilityProjectileEntity)((Object)entity)).getBlockCollisionBox().func_216360_c() / 2.0, -((AbilityProjectileEntity)((Object)entity)).getBlockCollisionBox().func_216362_d() / 2.0, ((AbilityProjectileEntity)((Object)entity)).getBlockCollisionBox().func_216364_b() / 2.0, ((AbilityProjectileEntity)((Object)entity)).getBlockCollisionBox().func_216360_c() / 2.0, ((AbilityProjectileEntity)((Object)entity)).getBlockCollisionBox().func_216362_d() / 2.0);
        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)vertexBuilder, (AxisAlignedBB)axisalignedbb, (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public RenderType getRenderType() {
        return null;
    }

    public ResourceLocation getTextureLocation(AbilityProjectileEntity entity) {
        if (entity.func_234616_v_() != null && entity.func_234616_v_() instanceof LivingEntity && entity.isAffectedByHaki()) {
            boolean imbuingCheck;
            boolean hardeningCheck = entity.isAffectedByHardening() && HakiHelper.hasHardeningActive(entity.getThrower(), false, false);
            boolean bl = imbuingCheck = entity.isAffectedByImbuing() && HakiHelper.isProjectileBusoshokuImbued((ProjectileEntity)entity);
            if (hardeningCheck || imbuingCheck) {
                return ModResources.BUSOSHOKU_HAKI_ARM;
            }
        }
        if (this.usePlayerTexture && entity.getThrower() != null && entity.getThrower() instanceof PlayerEntity) {
            PlayerEntity player = entity.field_70170_p.func_217371_b(entity.getThrower().func_110124_au());
            if (player != null) {
                return ((AbstractClientPlayerEntity)player).func_110306_p();
            }
            return DefaultPlayerSkin.func_177334_a((UUID)entity.func_110124_au());
        }
        return this.texture;
    }

    public static enum Effect {
        SPIRAL;

    }

    public static class Factory
    implements IRenderFactory<AbilityProjectileEntity> {
        protected EntityModel model = new CubeModel();
        protected float scaleX = 1.0f;
        protected float scaleY = 1.0f;
        protected float scaleZ = 1.0f;
        private float rotationX = 0.0f;
        private float rotationY = 0.0f;
        private float rotationZ = 0.0f;
        protected double translateX = 0.0;
        protected double translateY = 0.0;
        protected double translateZ = 0.0;
        protected Color colour = new Color(255, 255, 255, 255);
        protected ResourceLocation texture;
        protected boolean usePlayerTexture;
        protected boolean isGlowing = false;
        protected Set<Effect> effects = new HashSet<Effect>();

        public Factory(EntityModel model) {
            this.model = model;
        }

        public Factory setTexture(String textureName) {
            this.texture = new ResourceLocation("mineminenomi", "textures/models/projectiles/" + textureName + ".png");
            return this;
        }

        public Factory setTexture(ResourceLocation location) {
            this.texture = location;
            return this;
        }

        public Factory setPlayerTexture() {
            this.usePlayerTexture = true;
            return this;
        }

        public Factory setGlowing() {
            this.isGlowing = true;
            return this;
        }

        public Factory setColor(int red, int green, int blue, int alpha) {
            this.colour = new Color(red, green, blue, alpha);
            return this;
        }

        public Factory setColor(float red, float green, float blue, float alpha) {
            this.colour = new Color(red, green, blue, alpha);
            return this;
        }

        public Factory setColor(String hex) {
            this.colour = WyHelper.hexToRGB(hex);
            return this;
        }

        public Factory setAlpha(int alpha) {
            this.setAlpha((float)alpha / 255.0f);
            return this;
        }

        public Factory setAlpha(float alpha) {
            float red = (float)this.colour.getRed() / 255.0f;
            float green = (float)this.colour.getGreen() / 255.0f;
            float blue = (float)this.colour.getBlue() / 255.0f;
            this.colour = new Color(red, green, blue, alpha);
            return this;
        }

        public Factory setScale(double scale) {
            this.scaleY = this.scaleZ = (float)scale;
            this.scaleX = this.scaleZ;
            return this;
        }

        public Factory setScale(double scaleX, double scaleY, double scaleZ) {
            this.scaleX = (float)scaleX;
            this.scaleY = (float)scaleY;
            this.scaleZ = (float)scaleZ;
            return this;
        }

        public Factory setRotation(float rotationX, float rotationY, float rotationZ) {
            this.rotationX = rotationX;
            this.rotationY = rotationY;
            this.rotationZ = rotationZ;
            return this;
        }

        public Factory setTranslate(double tX, double tY, double tZ) {
            this.translateX = tX;
            this.translateY = tY;
            this.translateZ = tZ;
            return this;
        }

        public Factory addEffect(Effect ... effects) {
            this.effects.addAll(Sets.newHashSet((Object[])effects));
            return this;
        }

        public EntityRenderer<? super AbilityProjectileEntity> createRenderFor(EntityRendererManager manager) {
            AbilityProjectileRenderer renderer = new AbilityProjectileRenderer(manager, this.model, this.effects);
            renderer.setTexture(this.texture);
            renderer.setPlayerTexture(this.usePlayerTexture);
            renderer.setGlowing(this.isGlowing);
            renderer.setScale(this.scaleX, this.scaleY, this.scaleZ);
            renderer.setRotation(this.rotationX, this.rotationY, this.rotationZ);
            renderer.setTranslate(this.translateX, this.translateY, this.translateZ);
            renderer.setColor(this.colour);
            return renderer;
        }
    }
}

