/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Matrix4f;

public class RenderInWorldSkyboxCube {
    private ResourceLocation[] images;
    private float animationSpeed = 1.0f;
    private Random rand;
    private long seed;

    public static RenderInWorldSkyboxCube solid(ResourceLocation textures) {
        RenderInWorldSkyboxCube skybox = new RenderInWorldSkyboxCube();
        skybox.images = new ResourceLocation[1];
        skybox.images[0] = textures;
        skybox.rand = new Random();
        skybox.seed = skybox.rand.nextInt(1000);
        return skybox;
    }

    public void render2(Minecraft mc, MatrixStack matrixStack, ActiveRenderInfo info, double posX, double posY, double posZ, float sizeX, float sizeY, float sizeZ, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        float x = (float)info.func_216785_c().field_72450_a;
        float y = (float)info.func_216785_c().field_72448_b;
        float z = (float)info.func_216785_c().field_72449_c;
        float minY = (float)((double)(-sizeY - y) + posY);
        float maxY = (float)((double)(sizeY + 1.0f - y) + posY);
        float minX = (float)((double)(-sizeX - x) + posX);
        float maxX = (float)((double)(sizeX + 1.0f - x) + posX);
        float minZ = (float)((double)(-sizeZ - z) + posZ);
        float maxZ = (float)((double)(sizeZ + 1.0f - z) + posZ);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.pushMatrix();
        RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
        RenderSystem.enablePolygonOffset();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableAlphaTest();
        RenderSystem.disableCull();
        float animU = (float)(Util.func_211177_b() + this.seed) % this.animationSpeed / this.animationSpeed;
        float animV = (float)Util.func_211177_b() % this.animationSpeed / this.animationSpeed;
        float u = animU + 1.0f;
        float v = 0.0f + (float)this.seed / 1000.0f;
        for (int k = 0; k < this.images.length; ++k) {
            mc.func_110434_K().func_110577_a(this.images[k]);
            buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
            int l = (int)(alpha * 255.0f);
            if (k == 0) {
                buffer.func_227888_a_(matrix, minX, maxY, maxZ).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f + u, 0.0f + v).func_181675_d();
                buffer.func_227888_a_(matrix, minX, minY, maxZ).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f + u, 1.0f + v).func_181675_d();
                buffer.func_227888_a_(matrix, maxX, minY, maxZ).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f + u, 1.0f + v).func_181675_d();
                buffer.func_227888_a_(matrix, maxX, maxY, maxZ).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f + u, 0.0f + v).func_181675_d();
            }
            if (k == 1) {
                buffer.func_227888_a_(matrix, maxX, maxY, maxZ).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f + u, 0.0f + v).func_181675_d();
                buffer.func_227888_a_(matrix, maxX, minY, maxZ).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f + u, 1.0f + v).func_181675_d();
                buffer.func_227888_a_(matrix, maxX, minY, minZ).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f + u, 1.0f + v).func_181675_d();
                buffer.func_227888_a_(matrix, maxX, maxY, minZ).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f + u, 0.0f + v).func_181675_d();
            }
            if (k == 2) {
                buffer.func_227888_a_(matrix, maxX, maxY, minZ).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f + u, 0.0f + v).func_181675_d();
                buffer.func_227888_a_(matrix, maxX, minY, minZ).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f + u, 1.0f + v).func_181675_d();
                buffer.func_227888_a_(matrix, minX, minY, minZ).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f + u, 1.0f + v).func_181675_d();
                buffer.func_227888_a_(matrix, minX, maxY, minZ).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f + u, 0.0f + v).func_181675_d();
            }
            if (k == 3) {
                buffer.func_227888_a_(matrix, minX, maxY, minZ).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f + u, 0.0f + v).func_181675_d();
                buffer.func_227888_a_(matrix, minX, minY, minZ).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f + u, 1.0f + v).func_181675_d();
                buffer.func_227888_a_(matrix, minX, minY, maxZ).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f + u, 1.0f + v).func_181675_d();
                buffer.func_227888_a_(matrix, minX, maxY, maxZ).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f + u, 0.0f + v).func_181675_d();
            }
            if (k == 4) {
                buffer.func_227888_a_(matrix, minX, maxY, minZ).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f + u, 0.0f).func_181675_d();
                buffer.func_227888_a_(matrix, minX, maxY, maxZ).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f + u, 1.0f).func_181675_d();
                buffer.func_227888_a_(matrix, maxX, maxY, maxZ).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f + u, 1.0f).func_181675_d();
                buffer.func_227888_a_(matrix, maxX, maxY, minZ).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f + u, 0.0f).func_181675_d();
            }
            if (k == 5) {
                buffer.func_227888_a_(matrix, minX, minY, maxZ).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f + u, 0.0f).func_181675_d();
                buffer.func_227888_a_(matrix, minX, minY, minZ).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f + u, 1.0f).func_181675_d();
                buffer.func_227888_a_(matrix, maxX, minY, minZ).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f + u, 1.0f).func_181675_d();
                buffer.func_227888_a_(matrix, maxX, minY, maxZ).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f + u, 0.0f).func_181675_d();
            }
            tessellator.func_78381_a();
        }
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.enableCull();
        RenderSystem.disableAlphaTest();
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
        RenderSystem.enableAlphaTest();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
        RenderSystem.depthMask((boolean)true);
    }

    public void render(Minecraft mc, float pitch, float yaw, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        RenderSystem.matrixMode((int)5889);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        RenderSystem.multMatrix((Matrix4f)Matrix4f.func_195876_a((double)85.0, (float)((float)mc.func_228018_at_().func_198109_k() / (float)mc.func_228018_at_().func_198091_l()), (float)0.001f, (float)10.0f));
        RenderSystem.matrixMode((int)5888);
        RenderSystem.pushMatrix();
        RenderSystem.loadIdentity();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.disableCull();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        int i = 2;
        for (int j = 0; j < 4; ++j) {
            RenderSystem.pushMatrix();
            float f = ((float)(j % 2) / 2.0f - 0.5f) / 256.0f;
            float f1 = ((float)(j / 2) / 2.0f - 0.5f) / 256.0f;
            float f2 = 0.0f;
            RenderSystem.translatef((float)f, (float)f1, (float)0.0f);
            RenderSystem.rotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
            RenderSystem.rotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
            for (int k = 0; k < 6; ++k) {
                mc.func_110434_K().func_110577_a(this.images[k]);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                int l = Math.round(255.0f * alpha) / (j + 1);
                if (k == 0) {
                    bufferbuilder.func_225582_a_(-1.0, -1.0, 1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f, 0.0f).func_181675_d();
                    bufferbuilder.func_225582_a_(-1.0, 1.0, 1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f, 1.0f).func_181675_d();
                    bufferbuilder.func_225582_a_(1.0, 1.0, 1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f, 1.0f).func_181675_d();
                    bufferbuilder.func_225582_a_(1.0, -1.0, 1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f, 0.0f).func_181675_d();
                }
                if (k == 1) {
                    bufferbuilder.func_225582_a_(1.0, -1.0, 1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f, 0.0f).func_181675_d();
                    bufferbuilder.func_225582_a_(1.0, 1.0, 1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f, 1.0f).func_181675_d();
                    bufferbuilder.func_225582_a_(1.0, 1.0, -1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f, 1.0f).func_181675_d();
                    bufferbuilder.func_225582_a_(1.0, -1.0, -1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f, 0.0f).func_181675_d();
                }
                if (k == 2) {
                    bufferbuilder.func_225582_a_(1.0, -1.0, -1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f, 0.0f).func_181675_d();
                    bufferbuilder.func_225582_a_(1.0, 1.0, -1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f, 1.0f).func_181675_d();
                    bufferbuilder.func_225582_a_(-1.0, 1.0, -1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f, 1.0f).func_181675_d();
                    bufferbuilder.func_225582_a_(-1.0, -1.0, -1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f, 0.0f).func_181675_d();
                }
                if (k == 3) {
                    bufferbuilder.func_225582_a_(-1.0, -1.0, -1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f, 0.0f).func_181675_d();
                    bufferbuilder.func_225582_a_(-1.0, 1.0, -1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f, 1.0f).func_181675_d();
                    bufferbuilder.func_225582_a_(-1.0, 1.0, 1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f, 1.0f).func_181675_d();
                    bufferbuilder.func_225582_a_(-1.0, -1.0, 1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f, 0.0f).func_181675_d();
                }
                if (k == 4) {
                    bufferbuilder.func_225582_a_(-1.0, -1.0, -1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f, 0.0f).func_181675_d();
                    bufferbuilder.func_225582_a_(-1.0, -1.0, 1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f, 1.0f).func_181675_d();
                    bufferbuilder.func_225582_a_(1.0, -1.0, 1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f, 1.0f).func_181675_d();
                    bufferbuilder.func_225582_a_(1.0, -1.0, -1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f, 0.0f).func_181675_d();
                }
                if (k == 5) {
                    bufferbuilder.func_225582_a_(-1.0, 1.0, 1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f, 0.0f).func_181675_d();
                    bufferbuilder.func_225582_a_(-1.0, 1.0, -1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(0.0f, 1.0f).func_181675_d();
                    bufferbuilder.func_225582_a_(1.0, 1.0, -1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f, 1.0f).func_181675_d();
                    bufferbuilder.func_225582_a_(1.0, 1.0, 1.0).func_225586_a_(255, 255, 255, l).func_225583_a_(1.0f, 0.0f).func_181675_d();
                }
                tessellator.func_78381_a();
            }
            RenderSystem.popMatrix();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        }
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.matrixMode((int)5889);
        RenderSystem.popMatrix();
        RenderSystem.matrixMode((int)5888);
        RenderSystem.popMatrix();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableCull();
        RenderSystem.enableDepthTest();
    }

    public CompletableFuture<Void> preload(TextureManager pTexMngr, Executor pBackgroundExecutor) {
        CompletableFuture[] completablefuture = new CompletableFuture[6];
        for (int i = 0; i < completablefuture.length; ++i) {
            completablefuture[i] = pTexMngr.func_215268_a(this.images[i], pBackgroundExecutor);
        }
        return CompletableFuture.allOf(completablefuture);
    }
}

