/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

@OnlyIn(value=Dist.CLIENT)
public class ArenaSkybox {
    private final Minecraft minecraft;
    private float time;
    private int seed;
    private Color color = Color.WHITE;
    private ResourceLocation[] textures = new ResourceLocation[]{new ResourceLocation("mineminenomi", "textures/skyboxes/default.png")};
    private int animationSpeed = 10000;
    private int detailLevel = 8;
    private float radius = 1.0f;
    private boolean isFullWrapping;
    private boolean isGlobal;
    private long lastTick;
    private int textureId = 0;

    public ArenaSkybox() {
        this.minecraft = Minecraft.func_71410_x();
    }

    public ArenaSkybox setTexture(boolean isFullWrapping, ResourceLocation ... textures) {
        this.textures = textures;
        this.textureId = 0;
        this.isFullWrapping = isFullWrapping;
        return this;
    }

    public ArenaSkybox setAnimationSpeed(int animationSpeed) {
        this.animationSpeed = animationSpeed;
        return this;
    }

    public ArenaSkybox setColor(Color color) {
        this.color = color;
        return this;
    }

    public ArenaSkybox setAlpha(float alpha) {
        this.color = WyHelper.intToRGB(this.color.getRGB(), (int)alpha * 255);
        return this;
    }

    public ArenaSkybox setRadius(float radius) {
        this.radius = radius;
        return this;
    }

    public ArenaSkybox setDetailLevel(int detail) {
        this.detailLevel = detail;
        return this;
    }

    public ArenaSkybox setGlobal() {
        this.isGlobal = true;
        return this;
    }

    public void renderSphere(MatrixStack matrixStack) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableDepthTest();
        this.renderActualSphere(matrixStack, 0.0f, 0.0f, 0.0f, true);
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    public void renderSphereInWorld(MatrixStack matrixStack, ActiveRenderInfo info, double posX, double posY, double posZ) {
        double x = info.func_216785_c().field_72450_a;
        double y = info.func_216785_c().field_72448_b;
        double z = info.func_216785_c().field_72449_c;
        boolean isInisde = false;
        double distance = (x - posX) * (x - posX) + (z - posZ) * (z - posZ) + (y - posY) * (y - posY);
        if (distance < (double)(this.radius * this.radius)) {
            isInisde = true;
        }
        if (this.isGlobal) {
            x = (double)(-this.radius) - x + posX + (double)this.radius;
            y = (double)(-this.radius) - y + posY + (double)this.radius;
            z = (double)(-this.radius) - z + posZ + (double)this.radius;
        } else {
            x = 0.0;
            y = 0.0;
            z = 0.0;
        }
        if (Minecraft.func_238218_y_()) {
            Minecraft.func_71410_x().field_71438_f.func_239229_r_().func_147610_a(false);
        }
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.depthMask((boolean)Minecraft.func_238218_y_());
        RenderSystem.pushMatrix();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableAlphaTest();
        if (!isInisde) {
            if (Minecraft.func_238218_y_()) {
                RenderSystem.disableCull();
                RenderSystem.depthMask((boolean)false);
            } else {
                RenderSystem.disableCull();
            }
        }
        this.renderActualSphere(matrixStack, (float)x, (float)y, (float)z, isInisde);
        if (!isInisde) {
            RenderSystem.enableCull();
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
        RenderSystem.depthMask((boolean)true);
        if (Minecraft.func_238218_y_()) {
            Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        }
    }

    private void renderActualSphere(MatrixStack matrixStack, float x, float y, float z, boolean isInisde) {
        long currentTick;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertex = tessellator.func_178180_c();
        if (this.textures.length > 1 && (currentTick = Util.func_211177_b()) > this.lastTick + 100L) {
            this.lastTick = currentTick;
            ++this.textureId;
            this.textureId %= this.textures.length;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.textures[this.textureId]);
        vertex.func_181668_a(4, DefaultVertexFormats.field_227852_q_);
        float startU = 0.0f;
        float startV = 0.0f;
        float endU = (float)Math.PI * 2;
        float endV = (float)Math.PI;
        float stepU = (endU - startU) / (float)this.detailLevel;
        float stepV = (endV - startV) / (float)this.detailLevel;
        float animU = (float)((Util.func_211177_b() + (long)this.seed) % (long)this.animationSpeed) / (float)this.animationSpeed;
        float animV = (float)(Util.func_211177_b() % (long)this.animationSpeed) / (float)this.animationSpeed;
        float uAnim = animU + 1.0f;
        float vAnim = 0.0f;
        int red = this.color.getRed();
        int green = this.color.getGreen();
        int blue = this.color.getBlue();
        int alpha = this.color.getAlpha();
        Matrix4f projection = matrixStack.func_227866_c_().func_227870_a_();
        for (int i = 0; i < this.detailLevel; ++i) {
            for (int j = 0; j < this.detailLevel; ++j) {
                float u = (float)i * stepU + startU;
                float v = (float)j * stepV + startV;
                float un = i + 1 == this.detailLevel ? endU : (float)(i + 1) * stepU + startU;
                float vn = j + 1 == this.detailLevel ? endV : (float)(j + 1) * stepV + startV;
                Vector3f p0 = this.parametricSphere(u, v, this.radius);
                Vector3f p1 = this.parametricSphere(u, vn, this.radius);
                Vector3f p2 = this.parametricSphere(un, v, this.radius);
                Vector3f p3 = this.parametricSphere(un, vn, this.radius);
                float textureU = u / endU * (this.isFullWrapping ? 1.0f : this.radius);
                float textureV = v / endV * (this.isFullWrapping ? 1.0f : this.radius);
                float textureUN = un / endU * (this.isFullWrapping ? 1.0f : this.radius);
                float textureVN = vn / endV * (this.isFullWrapping ? 1.0f : this.radius);
                textureU += uAnim;
                textureUN += uAnim;
                if (isInisde) {
                    this.vertexPosColorUVLight((IVertexBuilder)vertex, projection, x - p0.func_195899_a(), y - p0.func_195900_b(), z - p0.func_195902_c(), red, green, blue, alpha, textureU, textureV, 1);
                    this.vertexPosColorUVLight((IVertexBuilder)vertex, projection, x - p2.func_195899_a(), y - p2.func_195900_b(), z - p2.func_195902_c(), red, green, blue, alpha, textureUN, textureV, 1);
                    this.vertexPosColorUVLight((IVertexBuilder)vertex, projection, x - p1.func_195899_a(), y - p1.func_195900_b(), z - p1.func_195902_c(), red, green, blue, alpha, textureU, textureVN, 1);
                    this.vertexPosColorUVLight((IVertexBuilder)vertex, projection, x - p3.func_195899_a(), y - p3.func_195900_b(), z - p3.func_195902_c(), red, green, blue, alpha, textureUN, textureVN, 1);
                    this.vertexPosColorUVLight((IVertexBuilder)vertex, projection, x - p1.func_195899_a(), y - p1.func_195900_b(), z - p1.func_195902_c(), red, green, blue, alpha, textureU, textureVN, 1);
                    this.vertexPosColorUVLight((IVertexBuilder)vertex, projection, x - p2.func_195899_a(), y - p2.func_195900_b(), z - p2.func_195902_c(), red, green, blue, alpha, textureUN, textureV, 1);
                    continue;
                }
                this.vertexPosColorUVLight((IVertexBuilder)vertex, projection, x + p0.func_195899_a(), y + p0.func_195900_b(), z + p0.func_195902_c(), red, green, blue, alpha, textureU, textureV, 1);
                this.vertexPosColorUVLight((IVertexBuilder)vertex, projection, x + p2.func_195899_a(), y + p2.func_195900_b(), z + p2.func_195902_c(), red, green, blue, alpha, textureUN, textureV, 1);
                this.vertexPosColorUVLight((IVertexBuilder)vertex, projection, x + p1.func_195899_a(), y + p1.func_195900_b(), z + p1.func_195902_c(), red, green, blue, alpha, textureU, textureVN, 1);
                this.vertexPosColorUVLight((IVertexBuilder)vertex, projection, x + p3.func_195899_a(), y + p3.func_195900_b(), z + p3.func_195902_c(), red, green, blue, alpha, textureUN, textureVN, 1);
                this.vertexPosColorUVLight((IVertexBuilder)vertex, projection, x + p1.func_195899_a(), y + p1.func_195900_b(), z + p1.func_195902_c(), red, green, blue, alpha, textureU, textureVN, 1);
                this.vertexPosColorUVLight((IVertexBuilder)vertex, projection, x + p2.func_195899_a(), y + p2.func_195900_b(), z + p2.func_195902_c(), red, green, blue, alpha, textureUN, textureV, 1);
            }
        }
        tessellator.func_78381_a();
    }

    private Vector3f parametricSphere(float u, float v, float r) {
        return new Vector3f(MathHelper.func_76134_b((float)u) * MathHelper.func_76126_a((float)v) * r, MathHelper.func_76134_b((float)v) * r, MathHelper.func_76126_a((float)u) * MathHelper.func_76126_a((float)v) * r);
    }

    private void vertexPosColorUVLight(IVertexBuilder buffer, Matrix4f projection, float x, float y, float z, int r, int g, int b, int a, float u, float v, int light) {
        buffer.func_227888_a_(projection, x, y, z).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_227886_a_(light).func_181675_d();
    }
}

