/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.quests.objectives;

import net.minecraft.entity.player.PlayerEntity;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.IUseAbilityObjective;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;

public class UseAbilityObjective
extends Objective
implements IUseAbilityObjective {
    protected ICheckAbilityUse useEvent = (player, ability) -> true;

    public UseAbilityObjective(String title, int count) {
        this(title, count, (ICheckAbilityUse)null);
    }

    public UseAbilityObjective(String title, int count, AbilityCore ability) {
        this(title, count, (PlayerEntity player, IAbility abl) -> abl.getCore().equals(ability));
    }

    public UseAbilityObjective(String title, int count, ICheckAbilityUse check) {
        super(title);
        this.setMaxProgress(count);
        if (check != null) {
            this.useEvent = check;
        }
    }

    @Override
    public boolean checkAbility(PlayerEntity player, IAbility ability) {
        return this.useEvent.test(player, ability);
    }

    @FunctionalInterface
    public static interface ICheckAbilityUse {
        public boolean test(PlayerEntity var1, IAbility var2);

        default public ICheckAbilityUse and(ICheckAbilityUse check) {
            return (player, ability) -> this.test(player, ability) && check.test(player, ability);
        }

        default public ICheckAbilityUse or(ICheckAbilityUse check) {
            return (player, ability) -> this.test(player, ability) || check.test(player, ability);
        }
    }
}

