/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.effects.zushi;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;

public class GraviZoneParticleEffect
extends ParticleEffect<Details> {
    public GraviZoneParticleEffect() {
        super(Details::new);
    }

    @Override
    public void spawn(Entity entity, World world, double posX, double posY, double posZ, Details details) {
        for (double z = 0.0; z < 7.283185307179586; z += 0.09817477042468103) {
            SimpleParticleData part = new SimpleParticleData((ParticleType)ModParticleTypes.GASU.get());
            part.setLife(12);
            part.setSize(2.0f);
            double offsetX = Math.cos(z) * (double)details.getRange();
            double offsetZ = Math.sin(z) * (double)details.getRange();
            part.setMotion(offsetX / 20.0, 0.0, offsetZ / 20.0);
            part.setRotation(0.0f, 0.0f, 1.0f);
            part.setRotationSpeed(world.func_201674_k().nextFloat() / 2.0f);
            world.func_195590_a((IParticleData)part, true, posX + offsetX, posY + 1.0 + (double)details.getYOffset(), posZ + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    public static class Details
    extends ParticleEffect.Details {
        private int range;
        private int yOffset;

        @Override
        public void save(CompoundNBT nbt) {
            nbt.func_74768_a("range", this.range);
            nbt.func_74768_a("yOffset", this.yOffset);
        }

        @Override
        public void load(CompoundNBT nbt) {
            this.range = nbt.func_74762_e("range");
            this.yOffset = nbt.func_74762_e("yOffset");
        }

        public void setYOffset(int offset) {
            this.yOffset = offset;
        }

        public int getYOffset() {
            return this.yOffset;
        }

        public void setRange(int range) {
            this.range = range;
        }

        public int getRange() {
            return this.range;
        }
    }
}

