/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.effects.toriphoenix;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;

public class BlueBirdParticleEffect
extends ParticleEffect<Details> {
    public BlueBirdParticleEffect() {
        super(Details::new);
    }

    @Override
    public void spawn(Entity entity, World world, double posX, double posY, double posZ, Details details) {
        float incrementPI = 0.049087387f;
        float radius1 = (float)BlueBirdParticleEffect.fromRangeToRange(0.0, details.getMaxChargeTime(), 0.25, 1.25, details.getMaxChargeTime() - details.getCurrentChargeTime()) * 1.6f;
        float radius2 = (float)BlueBirdParticleEffect.fromRangeToRange(0.0, details.getMaxChargeTime(), 0.15, 0.3, details.getMaxChargeTime() - details.getCurrentChargeTime()) * 1.8f;
        float rotation = (float)((double)incrementPI * BlueBirdParticleEffect.fromRangeToRange(0.0, details.getMaxChargeTime(), -128.0, 128.0, details.getCurrentChargeTime()));
        float rotation2 = (float)((double)incrementPI * BlueBirdParticleEffect.fromRangeToRange(0.0, details.getMaxChargeTime(), -128.0, 128.0, details.getCurrentChargeTime()) + 2.0943951023931953);
        float rotation3 = (float)((double)incrementPI * BlueBirdParticleEffect.fromRangeToRange(0.0, details.getMaxChargeTime(), -128.0, 128.0, details.getCurrentChargeTime()) - 2.0943951023931953);
        Vector3d normalizedH = BlueBirdParticleEffect.getPerpendicularHorizontalLine(Vector3d.field_186680_a, entity.func_70040_Z(), radius1).func_216372_d(2.0, 2.0, 2.0);
        Vector3d normalizedV = BlueBirdParticleEffect.getPerpendicularVerticalLine(Vector3d.field_186680_a, entity.func_70040_Z(), normalizedH.func_216372_d(-Math.PI, -Math.PI, -Math.PI), radius2).func_216372_d(2.0, 2.0, 2.0);
        Vector3d finalPosition1 = BlueBirdParticleEffect.getParticlePositionInSpiral(rotation, normalizedH, normalizedV);
        Vector3d finalPosition2 = BlueBirdParticleEffect.getParticlePositionInSpiral(rotation2, normalizedH, normalizedV);
        Vector3d finalPosition3 = BlueBirdParticleEffect.getParticlePositionInSpiral(rotation3, normalizedH, normalizedV);
        SimpleParticleData data = new SimpleParticleData((ParticleType)ModParticleTypes.BLUE_FLAME.get());
        data.setLife(15);
        data.setSize(4.0f);
        data.setMotion(entity.func_70040_Z().field_72450_a / 10.0, entity.func_70040_Z().field_72448_b / 10.0, entity.func_70040_Z().field_72449_c / 10.0);
        double posX1 = entity.func_226277_ct_() + finalPosition1.field_72450_a;
        double posY1 = entity.func_226280_cw_() + finalPosition1.field_72448_b;
        double posZ1 = entity.func_226281_cx_() + finalPosition1.field_72449_c;
        double posX2 = entity.func_226277_ct_() + finalPosition2.field_72450_a;
        double posY2 = entity.func_226280_cw_() + finalPosition2.field_72448_b;
        double posZ2 = entity.func_226281_cx_() + finalPosition2.field_72449_c;
        double posX3 = entity.func_226277_ct_() + finalPosition3.field_72450_a;
        double posY3 = entity.func_226280_cw_() + finalPosition3.field_72448_b;
        double posZ3 = entity.func_226281_cx_() + finalPosition3.field_72449_c;
        world.func_195590_a((IParticleData)data, true, posX1, posY1, posZ1, 0.0, 0.0, 0.0);
        world.func_195590_a((IParticleData)data, true, posX2, posY2, posZ2, 0.0, 0.0, 0.0);
        world.func_195590_a((IParticleData)data, true, posX3, posY3, posZ3, 0.0, 0.0, 0.0);
    }

    private static Vector3d getPerpendicularHorizontalLine(Vector3d startPoint, Vector3d endPoint, float radius) {
        Vector3d line;
        Vector3d axis = new Vector3d(1.0, 0.0, 1.0);
        Vector3d newStart = startPoint.func_216369_h(axis);
        Vector3d newEnd = endPoint.func_216369_h(axis);
        line.func_72441_c((line = newEnd.func_178788_d(newStart)).func_82615_a() == 0.0 ? 0.001 : 0.0, 0.0, line.func_82616_c() == 0.0 ? 0.001 : 0.0);
        Vector3d newLine = new Vector3d(line.field_72449_c, 0.0, -line.field_72450_a);
        return newLine.func_72432_b().func_216372_d((double)radius, (double)radius, (double)radius);
    }

    private static Vector3d getPerpendicularVerticalLine(Vector3d startPoint, Vector3d endPoint, Vector3d horizontalPoint, float radius) {
        Vector3d vec1 = endPoint.func_178788_d(startPoint);
        Vector3d vec2 = horizontalPoint.func_178788_d(startPoint);
        Vector3d newLine = vec1.func_72431_c(vec2);
        return newLine.func_72432_b().func_216372_d((double)radius, (double)radius, (double)radius);
    }

    private static double fromRangeToRange(double oldMin, double oldMax, double min, double max, double oldValue) {
        return (oldValue - oldMin) * (max - min) / (oldMax - oldMin) + min;
    }

    private static Vector3d getParticlePositionInSpiral(float rotation, Vector3d normalizedH, Vector3d normalizedV) {
        Vector3d incrementH = normalizedH.func_216372_d(Math.cos(rotation), Math.cos(rotation), Math.cos(rotation));
        Vector3d incrementV = normalizedV.func_216372_d(Math.sin(rotation), Math.sin(rotation), Math.sin(rotation));
        Vector3d HVVec = incrementV.func_178788_d(incrementH);
        return incrementV.func_178787_e(HVVec.func_216372_d(0.5, 0.5, 0.5));
    }

    public static class Details
    extends ParticleEffect.Details {
        private double currentChargeTime;
        private double maxChargeTime;

        @Override
        public void save(CompoundNBT nbt) {
            nbt.func_74780_a("currentChargeTime", this.currentChargeTime);
            nbt.func_74780_a("maxChargeTime", this.maxChargeTime);
        }

        @Override
        public void load(CompoundNBT nbt) {
            this.currentChargeTime = nbt.func_74769_h("currentChargeTime");
            this.maxChargeTime = nbt.func_74769_h("maxChargeTime");
        }

        public void setCurrentChargeTime(double currChargeTime) {
            this.currentChargeTime = currChargeTime;
        }

        public void setMaxChargeTime(double maxChargeTime) {
            this.maxChargeTime = maxChargeTime;
        }

        public double getMaxChargeTime() {
            return this.maxChargeTime;
        }

        public double getCurrentChargeTime() {
            return this.currentChargeTime;
        }
    }
}

