/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.effects.goro;

import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class LightningExplosionParticleEffect
extends ParticleEffect {
    private int explosionSize;

    public LightningExplosionParticleEffect() {
        this(2);
    }

    public LightningExplosionParticleEffect(int explosionSize) {
        this.explosionSize = explosionSize;
    }

    @Override
    public void spawn(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        ParticleType goro_particle = ClientConfig.INSTANCE.isGoroBlue() ? (ParticleType)ModParticleTypes.GORO.get() : (ParticleType)ModParticleTypes.GORO_YELLOW.get();
        ParticleType goro2_particle = ClientConfig.INSTANCE.isGoroBlue() ? (ParticleType)ModParticleTypes.GORO2.get() : (ParticleType)ModParticleTypes.GORO2_YELLOW.get();
        for (int i = 0; i < this.explosionSize * 2; ++i) {
            double x = posX + WyHelper.randomWithRange(-this.explosionSize / 2, this.explosionSize / 2) + WyHelper.randomDouble();
            double y = posY + WyHelper.randomDouble();
            double z = posZ + WyHelper.randomWithRange(-this.explosionSize / 2, this.explosionSize / 2) + WyHelper.randomDouble();
            motionX = WyHelper.randomWithRange(-3, 3) + WyHelper.randomDouble();
            motionY = WyHelper.randomWithRange(-3, 3) + WyHelper.randomDouble();
            motionZ = WyHelper.randomWithRange(-3, 3) + WyHelper.randomDouble();
            double middlePoint = 0.5 / (5.0 / (double)this.explosionSize + 0.1);
            motionX *= (middlePoint *= WyHelper.randomDouble() * 2.0 + (double)0.3f) / 2.0;
            motionY *= middlePoint / 2.0;
            motionZ *= middlePoint / 2.0;
            float scale = (float)(1.0 + WyHelper.randomWithRange(2, 5));
            ParticleType particle = goro_particle;
            if (i % 2 == 0) {
                particle = goro2_particle;
            }
            SimpleParticleData data = new SimpleParticleData(particle);
            data.setLife(30);
            data.setSize(scale);
            data.setMotion(motionX, motionY, motionZ);
            WyHelper.spawnParticles(data, (ServerWorld)world, x, y + 1.0, z);
            WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197598_I, (ServerWorld)world, posX, posY + 1.0, posZ);
        }
    }
}

