/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.effects.goro;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KariParticleEffect
extends ParticleEffect<Details> {
    public KariParticleEffect() {
        super(Details::new);
    }

    @Override
    public void spawn(Entity entity, World world, double posX, double posY, double posZ, Details details) {
        ParticleType goro_particle = ClientConfig.INSTANCE.isGoroBlue() ? (ParticleType)ModParticleTypes.GORO.get() : (ParticleType)ModParticleTypes.GORO_YELLOW.get();
        ParticleType goro2_particle = ClientConfig.INSTANCE.isGoroBlue() ? (ParticleType)ModParticleTypes.GORO2.get() : (ParticleType)ModParticleTypes.GORO2_YELLOW.get();
        for (int i = 0; i < 16 * details.getRange(); ++i) {
            double offsetX = WyHelper.randomWithRange(-details.getRange(), details.getRange()) + WyHelper.randomDouble();
            double offsetY = WyHelper.randomWithRange(-details.getRange(), 2 + details.getRange()) + WyHelper.randomDouble();
            double offsetZ = WyHelper.randomWithRange(-details.getRange(), details.getRange()) + WyHelper.randomDouble();
            SimpleParticleData data = new SimpleParticleData(goro2_particle);
            data.setLife(5);
            data.setSize(details.getSize());
            world.func_195590_a((IParticleData)data, true, posX + offsetX, posY + offsetY, posZ + offsetZ, 0.0, 0.0, 0.0);
            SimpleParticleData data2 = new SimpleParticleData(goro_particle);
            data2.setLife(5);
            data2.setSize(details.getSize());
            data.setRotation(Vector3f.field_229181_d_);
            world.func_195590_a((IParticleData)data, true, posX + offsetX, posY + offsetY, posZ + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    public static class Details
    extends ParticleEffect.Details {
        private int range;
        private float size;

        @Override
        public void save(CompoundNBT nbt) {
            nbt.func_74768_a("range", this.range);
            nbt.func_74776_a("size", this.size);
        }

        @Override
        public void load(CompoundNBT nbt) {
            this.range = nbt.func_74762_e("range");
            this.size = nbt.func_74760_g("size");
        }

        public int getRange() {
            return this.range;
        }

        public float getSize() {
            return this.size;
        }

        public void setRange(int range) {
            this.range = range;
        }

        public void setSize(float range) {
            this.size = range;
        }
    }
}

