/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.effects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;

public class BreakingBlocksParticleEffect
extends ParticleEffect<Details> {
    public BreakingBlocksParticleEffect() {
        super(Details::new);
    }

    @Override
    public void spawn(Entity entity, World world, double posX, double posY, double posZ, Details details) {
        if (details.isVecList) {
            for (Vector3d pos : details.vecPositions) {
                posX = pos.func_82615_a();
                posY = pos.func_82617_b();
                posZ = pos.func_82616_c();
                for (int i = 0; i < details.amount; ++i) {
                    double offsetX = world.field_73012_v.nextDouble();
                    double offsetY = 1.0;
                    double offsetZ = world.field_73012_v.nextDouble();
                    BlockState blockState = world.func_180495_p(new BlockPos(posX + offsetX, posY, posZ + offsetZ).func_177977_b());
                    BlockParticleData particleData = new BlockParticleData(ParticleTypes.field_197611_d, blockState);
                    world.func_195590_a((IParticleData)particleData, true, posX + offsetX, posY + offsetY, posZ + offsetZ, 0.0, 0.0, 0.0);
                }
            }
            return;
        }
        for (BlockPos pos : details.positions) {
            posX = pos.func_177958_n();
            posY = pos.func_177956_o();
            posZ = pos.func_177952_p();
            for (int i = 0; i < details.amount; ++i) {
                double offsetX = world.field_73012_v.nextDouble();
                double offsetY = 1.0;
                double offsetZ = world.field_73012_v.nextDouble();
                BlockState blockState = world.func_180495_p(new BlockPos(posX + offsetX, posY, posZ + offsetZ).func_177977_b());
                BlockParticleData particleData = new BlockParticleData(ParticleTypes.field_197611_d, blockState);
                world.func_195590_a((IParticleData)particleData, true, posX + offsetX, posY + offsetY, posZ + offsetZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public static class Details
    extends ParticleEffect.Details {
        private int amount = 60;
        private boolean isVecList;
        private List<BlockPos> positions = new ArrayList<BlockPos>();
        private List<Vector3d> vecPositions = new ArrayList<Vector3d>();

        public Details() {
        }

        public Details(int amount) {
            this.amount = amount;
        }

        @Override
        public void save(CompoundNBT nbt) {
            nbt.func_74768_a("amount", this.amount);
            nbt.func_74757_a("isVec", this.isVecList);
            ListNBT positionsList = new ListNBT();
            if (this.positions.size() > 0) {
                for (BlockPos pos : this.positions) {
                    CompoundNBT entry = new CompoundNBT();
                    entry.func_74768_a("x", pos.func_177958_n());
                    entry.func_74768_a("y", pos.func_177956_o());
                    entry.func_74768_a("z", pos.func_177952_p());
                    positionsList.add((Object)entry);
                }
            }
            nbt.func_218657_a("positions", (INBT)positionsList);
            ListNBT vecPositionsList = new ListNBT();
            if (this.vecPositions.size() > 0) {
                for (Vector3d pos : this.vecPositions) {
                    CompoundNBT entry = new CompoundNBT();
                    entry.func_74780_a("x", pos.func_82615_a());
                    entry.func_74780_a("y", pos.func_82617_b());
                    entry.func_74780_a("z", pos.func_82616_c());
                    vecPositionsList.add((Object)entry);
                }
            }
            nbt.func_218657_a("vecPositions", (INBT)vecPositionsList);
        }

        @Override
        public void load(CompoundNBT nbt) {
            this.amount = nbt.func_74762_e("amount");
            this.isVecList = nbt.func_74767_n("isVec");
            ListNBT positionsList = nbt.func_150295_c("positions", 10);
            this.positions.clear();
            for (int i = 0; i < positionsList.size(); ++i) {
                CompoundNBT entry = positionsList.func_150305_b(i);
                BlockPos pos = new BlockPos(entry.func_74762_e("x"), entry.func_74762_e("y"), entry.func_74762_e("z"));
                this.positions.add(pos);
            }
            ListNBT vecPositionsList = nbt.func_150295_c("vecPositions", 10);
            this.vecPositions.clear();
            for (int i = 0; i < vecPositionsList.size(); ++i) {
                CompoundNBT entry = vecPositionsList.func_150305_b(i);
                Vector3d pos = new Vector3d(entry.func_74769_h("x"), entry.func_74769_h("y"), entry.func_74769_h("z"));
                this.vecPositions.add(pos);
            }
        }

        public void setParticleAmount(int amount) {
            this.amount = amount;
        }

        public void setPositions(List<BlockPos> positions) {
            this.positions = positions;
        }

        public void setPositions(BlockPos[] positions) {
            this.positions.addAll(Arrays.asList(positions));
        }

        public void setVecPositions(List<Vector3d> positions) {
            this.vecPositions = positions;
            this.isVecList = true;
        }

        public void addPosition(BlockPos pos) {
            this.positions.add(pos);
        }

        public void clearPositions() {
            this.positions.clear();
        }
    }
}

