/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ui;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.WantedPosterData;
import xyz.pixelatedw.mineminenomi.screens.WantedPosterScreen;

public class SOpenWantedPosterScreenPacket {
    private CompoundNBT wantedData;

    public SOpenWantedPosterScreenPacket() {
    }

    public SOpenWantedPosterScreenPacket(WantedPosterData wantedData) {
        this.wantedData = wantedData.write();
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_150786_a(this.wantedData);
    }

    public static SOpenWantedPosterScreenPacket decode(PacketBuffer buffer) {
        SOpenWantedPosterScreenPacket msg = new SOpenWantedPosterScreenPacket();
        msg.wantedData = buffer.func_244273_m();
        return msg;
    }

    public static void handle(SOpenWantedPosterScreenPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SOpenWantedPosterScreenPacket message) {
            WantedPosterData wantedPosterData = WantedPosterData.from(message.wantedData);
            WantedPosterScreen.open(wantedPosterData);
        }
    }
}

