/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ui;

import java.util.LinkedHashSet;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.ModMain;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.crew.JollyRogerElement;
import xyz.pixelatedw.mineminenomi.screens.JollyRogerCreatorScreen;

public class SOpenJollyRogerCreatorScreenPacket {
    private boolean isEditing;
    private Crew crew;
    private LinkedHashSet<JollyRogerElement> elements;

    public SOpenJollyRogerCreatorScreenPacket() {
    }

    public SOpenJollyRogerCreatorScreenPacket(boolean isEditing, Crew crew, LinkedHashSet<JollyRogerElement> elements) {
        this.isEditing = isEditing;
        this.crew = crew;
        this.elements = elements;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.isEditing);
        int size = this.elements.size();
        buffer.writeInt(size);
        for (JollyRogerElement elem : this.elements) {
            buffer.func_192572_a(elem.getRegistryName());
        }
        buffer.func_150786_a(this.crew.write());
    }

    public static SOpenJollyRogerCreatorScreenPacket decode(PacketBuffer buffer) {
        SOpenJollyRogerCreatorScreenPacket msg = new SOpenJollyRogerCreatorScreenPacket();
        msg.isEditing = buffer.readBoolean();
        int size = buffer.readInt();
        msg.elements = new LinkedHashSet();
        for (int i = 0; i < size; ++i) {
            ResourceLocation res = buffer.func_192575_l();
            JollyRogerElement elem = (JollyRogerElement)ModRegistries.JOLLY_ROGER_ELEMENTS.getValue(res);
            if (elem != null) {
                msg.elements.add(elem);
                continue;
            }
            ModMain.LOGGER.warn(res + " could not be found as a jolly roger element!");
        }
        CompoundNBT jollyRogerData = buffer.func_244273_m();
        msg.crew = Crew.from(jollyRogerData);
        return msg;
    }

    public static void handle(SOpenJollyRogerCreatorScreenPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SOpenJollyRogerCreatorScreenPacket message) {
            JollyRogerCreatorScreen.open(message.isEditing, message.crew, message.elements);
        }
    }
}

