/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ui;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.interactions.Interaction;
import xyz.pixelatedw.mineminenomi.screens.DialogueScreen;

public class SOpenDialogueScreenPacket {
    private int entityId;
    private Interaction interaction;

    public SOpenDialogueScreenPacket() {
    }

    public SOpenDialogueScreenPacket(LivingEntity entity, Interaction interaction) {
        this.entityId = entity.func_145782_y();
        this.interaction = interaction;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.func_192572_a(this.interaction.getRegistryName());
    }

    public static SOpenDialogueScreenPacket decode(PacketBuffer buffer) {
        SOpenDialogueScreenPacket msg = new SOpenDialogueScreenPacket();
        msg.entityId = buffer.readInt();
        msg.interaction = (Interaction)ModRegistries.INTERACTIONS.getValue(buffer.func_192575_l());
        return msg;
    }

    public static void handle(SOpenDialogueScreenPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SOpenDialogueScreenPacket message) {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            Entity entity = world.func_73045_a(message.entityId);
            if (entity == null || message.interaction == null || !(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity living = (LivingEntity)entity;
            Minecraft.func_71410_x().func_147108_a((Screen)new DialogueScreen(living, message.interaction));
        }
    }
}

