/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.IScreenEventReceiver;

public class SOpenChallengeGroupSelectorPacket {
    private int eventId;
    private List<Integer> ids;

    public SOpenChallengeGroupSelectorPacket() {
    }

    public SOpenChallengeGroupSelectorPacket(int eventId, List<Integer> ids) {
        this.eventId = eventId;
        this.ids = ids;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.eventId);
        buffer.writeInt(this.ids.size());
        for (int id : this.ids) {
            buffer.writeInt(id);
        }
    }

    public static SOpenChallengeGroupSelectorPacket decode(PacketBuffer buffer) {
        SOpenChallengeGroupSelectorPacket msg = new SOpenChallengeGroupSelectorPacket();
        msg.eventId = buffer.readInt();
        int size = buffer.readInt();
        msg.ids = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            int id = buffer.readInt();
            msg.ids.add(id);
        }
        return msg;
    }

    public static void handle(SOpenChallengeGroupSelectorPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SOpenChallengeGroupSelectorPacket message) {
            Minecraft mc = Minecraft.func_71410_x();
            if (!(mc.field_71462_r instanceof IScreenEventReceiver)) {
                return;
            }
            IScreenEventReceiver screen = (IScreenEventReceiver)mc.field_71462_r;
            screen.handleEvent(message.eventId, message.ids);
        }
    }
}

