/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ui;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.screens.ArenaSetupScreen;

public class SOpenArenaSetupScreenPacket {
    private String arenaName;

    public SOpenArenaSetupScreenPacket() {
    }

    public SOpenArenaSetupScreenPacket(String arenaName) {
        this.arenaName = arenaName;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.arenaName.length());
        buffer.func_211400_a(this.arenaName, this.arenaName.length());
    }

    public static SOpenArenaSetupScreenPacket decode(PacketBuffer buffer) {
        SOpenArenaSetupScreenPacket msg = new SOpenArenaSetupScreenPacket();
        int len = buffer.readInt();
        msg.arenaName = buffer.func_150789_c(len);
        return msg;
    }

    public static void handle(SOpenArenaSetupScreenPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SOpenArenaSetupScreenPacket message) {
            ArenaSetupScreen.open(message.arenaName);
        }
    }
}

