/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability.components;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class SDisableAbilityPacket {
    private int entityId;
    private Set<ResourceLocation> abilityIds = new HashSet<ResourceLocation>();
    private int disableTicks;
    private boolean state;

    public SDisableAbilityPacket() {
    }

    public SDisableAbilityPacket(int entityId, Set<IAbility> abilities, int disableTicks, boolean state) {
        this.entityId = entityId;
        this.abilityIds = abilities.stream().map(a -> a.getCore().getRegistryName()).collect(Collectors.toSet());
        this.disableTicks = disableTicks;
        this.state = state;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.abilityIds.size());
        for (ResourceLocation rs : this.abilityIds) {
            buffer.func_192572_a(rs);
        }
        buffer.writeInt(this.disableTicks);
        buffer.writeBoolean(this.state);
    }

    public static SDisableAbilityPacket decode(PacketBuffer buffer) {
        SDisableAbilityPacket msg = new SDisableAbilityPacket();
        msg.entityId = buffer.readInt();
        int abilities = buffer.readInt();
        for (int i = 0; i < abilities; ++i) {
            msg.abilityIds.add(buffer.func_192575_l());
        }
        msg.disableTicks = buffer.readInt();
        msg.state = buffer.readBoolean();
        return msg;
    }

    public static void handle(SDisableAbilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SDisableAbilityPacket message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)target;
            IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
            Set passiveAbilities = props.getPassiveAbilities(a -> message.abilityIds.contains(a.getCore().getRegistryName()));
            Set equippedAbilities = props.getEquippedAbilities(a -> message.abilityIds.contains(a.getCore().getRegistryName()));
            if (message.state) {
                passiveAbilities.stream().filter(a -> a.hasComponent(ModAbilityKeys.DISABLE)).forEach(a -> a.getComponent(ModAbilityKeys.DISABLE).ifPresent(comp -> comp.startDisable((LivingEntity)player, message.disableTicks)));
                equippedAbilities.stream().filter(a -> a.hasComponent(ModAbilityKeys.DISABLE)).forEach(a -> a.getComponent(ModAbilityKeys.DISABLE).ifPresent(comp -> comp.startDisable((LivingEntity)player, message.disableTicks)));
            } else {
                passiveAbilities.stream().filter(a -> a.hasComponent(ModAbilityKeys.DISABLE)).forEach(a -> a.getComponent(ModAbilityKeys.DISABLE).ifPresent(comp -> comp.stopDisable((LivingEntity)player)));
                equippedAbilities.stream().filter(a -> a.hasComponent(ModAbilityKeys.DISABLE)).forEach(a -> a.getComponent(ModAbilityKeys.DISABLE).ifPresent(comp -> comp.stopDisable((LivingEntity)player)));
            }
        }
    }
}

