/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability.components;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponentKey;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusManager;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;

public class SBonusManagerUpdatePacket {
    private int entityId;
    private int abilityId;
    private AbilityComponentKey<?> key;
    private Map<UUID, BonusManager.BonusValue> bonuses;

    public SBonusManagerUpdatePacket() {
    }

    public SBonusManagerUpdatePacket(LivingEntity entity, IAbility ability, AbilityComponent comp, Map<UUID, BonusManager.BonusValue> bonuses) {
        this.entityId = entity.func_145782_y();
        this.abilityId = AbilityDataCapability.get(entity).getEquippedAbilitySlot(ability);
        this.key = comp.getKey();
        this.bonuses = bonuses;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.abilityId);
        buffer.func_192572_a(this.key.getId());
        int size = this.bonuses.size();
        buffer.writeInt(size);
        this.bonuses.forEach((id, val) -> {
            buffer.func_179252_a(id);
            int nameLen = val.getName().length();
            buffer.writeInt(nameLen);
            buffer.func_211400_a(null, nameLen);
            buffer.writeInt(val.getType().ordinal());
            buffer.writeFloat(val.getValue());
        });
    }

    public static SBonusManagerUpdatePacket decode(PacketBuffer buffer) {
        SBonusManagerUpdatePacket msg = new SBonusManagerUpdatePacket();
        msg.entityId = buffer.readInt();
        msg.abilityId = buffer.readInt();
        msg.key = new AbilityComponentKey(buffer.func_192575_l());
        int size = buffer.readInt();
        msg.bonuses = new HashMap<UUID, BonusManager.BonusValue>();
        for (int i = 0; i < size; ++i) {
            UUID id = buffer.func_179253_g();
            int nameLen = buffer.readInt();
            String name = buffer.func_150789_c(nameLen);
            BonusOperation op = BonusOperation.values()[buffer.readInt()];
            float value = buffer.readFloat();
            msg.bonuses.put(id, new BonusManager.BonusValue(name, op, value));
        }
        return msg;
    }

    public static void handle(SBonusManagerUpdatePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SBonusManagerUpdatePacket message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity = (LivingEntity)target;
            IAbilityData props = AbilityDataCapability.get(entity);
            Object abl = props.getEquippedAbility(message.abilityId);
            if (abl == null) {
                return;
            }
            abl.getComponent(message.key).ifPresent(comp -> comp.getBonusManagers().forEachRemaining(manager -> manager.setBonusMap(message.bonuses)));
        }
    }
}

