/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server.ability;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.events.CombatModeEvents;

public class SToggleCombatModePacket {
    private boolean combatMode = false;
    private int bars = 1;

    public SToggleCombatModePacket() {
    }

    public SToggleCombatModePacket(boolean combatMode, int bars) {
        this.combatMode = combatMode;
        this.bars = bars;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.combatMode);
        buffer.writeInt(this.bars);
    }

    public static SToggleCombatModePacket decode(PacketBuffer buffer) {
        SToggleCombatModePacket msg = new SToggleCombatModePacket();
        msg.combatMode = buffer.readBoolean();
        msg.bars = buffer.readInt();
        return msg;
    }

    public static void handle(SToggleCombatModePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SToggleCombatModePacket message) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
            props.setCombatMode(message.combatMode);
            CombatModeEvents.Client.ABILITY_BARS = message.bars;
        }
    }
}

