/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.entities.StrikerEntity;

public class SSyncStrikerCrewPacket {
    private int entityId;
    private Crew crew;

    public SSyncStrikerCrewPacket() {
    }

    public SSyncStrikerCrewPacket(StrikerEntity entity, Crew crew) {
        this.entityId = entity.func_145782_y();
        this.crew = crew;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.func_150786_a(this.crew.write());
    }

    public static SSyncStrikerCrewPacket decode(PacketBuffer buffer) {
        SSyncStrikerCrewPacket msg = new SSyncStrikerCrewPacket();
        msg.entityId = buffer.readInt();
        msg.crew = Crew.from(buffer.func_244273_m());
        return msg;
    }

    public static void handle(SSyncStrikerCrewPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SSyncStrikerCrewPacket message) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            if (player == null) {
                return;
            }
            Entity entity = mc.field_71441_e.func_73045_a(message.entityId);
            if (entity == null) {
                return;
            }
            if (entity instanceof StrikerEntity) {
                ((StrikerEntity)entity).setCrew(message.crew);
            }
        }
    }
}

