/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.data.entity.projectilesextra.IProjectileExtras;
import xyz.pixelatedw.mineminenomi.data.entity.projectilesextra.ProjectileExtrasCapability;

public class SSyncProjectileExtrasPacket {
    private int entityId;
    private INBT data;

    public SSyncProjectileExtrasPacket() {
    }

    public SSyncProjectileExtrasPacket(ProjectileEntity projectile) {
        this.data = new CompoundNBT();
        IProjectileExtras props = ProjectileExtrasCapability.get((Entity)projectile);
        this.data = ProjectileExtrasCapability.INSTANCE.getStorage().writeNBT(ProjectileExtrasCapability.INSTANCE, (Object)props, null);
        this.entityId = projectile.func_145782_y();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.func_150786_a((CompoundNBT)this.data);
    }

    public static SSyncProjectileExtrasPacket decode(PacketBuffer buffer) {
        SSyncProjectileExtrasPacket msg = new SSyncProjectileExtrasPacket();
        msg.entityId = buffer.readInt();
        msg.data = buffer.func_150793_b();
        return msg;
    }

    public static void handle(SSyncProjectileExtrasPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SSyncProjectileExtrasPacket message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof ProjectileEntity)) {
                return;
            }
            IProjectileExtras props = ProjectileExtrasCapability.get(target);
            ProjectileExtrasCapability.INSTANCE.getStorage().readNBT(ProjectileExtrasCapability.INSTANCE, (Object)props, null, message.data);
        }
    }
}

