/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;

public class SSpawnParticleEffectPacket {
    private int spawnerId;
    private ResourceLocation res;
    private double posX;
    private double posY;
    private double posZ;
    private CompoundNBT nbt = new CompoundNBT();

    public SSpawnParticleEffectPacket() {
    }

    public SSpawnParticleEffectPacket(ParticleEffect effect, Entity entity, double posX, double posY, double posZ, @Nullable ParticleEffect.Details details) {
        this.res = effect.getRegistryName();
        this.spawnerId = entity.func_145782_y();
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        if (details != null) {
            details.save(this.nbt);
        }
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_192572_a(this.res);
        buffer.writeInt(this.spawnerId);
        buffer.writeDouble(this.posX);
        buffer.writeDouble(this.posY);
        buffer.writeDouble(this.posZ);
        buffer.func_150786_a(this.nbt);
    }

    public static SSpawnParticleEffectPacket decode(PacketBuffer buffer) {
        SSpawnParticleEffectPacket msg = new SSpawnParticleEffectPacket();
        msg.res = buffer.func_192575_l();
        msg.spawnerId = buffer.readInt();
        msg.posX = buffer.readDouble();
        msg.posY = buffer.readDouble();
        msg.posZ = buffer.readDouble();
        msg.nbt = buffer.func_150793_b();
        return msg;
    }

    public static void handle(SSpawnParticleEffectPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SSpawnParticleEffectPacket message) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            if (player == null) {
                return;
            }
            Entity spawner = player.field_70170_p.func_73045_a(message.spawnerId);
            ParticleEffect effect = (ParticleEffect)GameRegistry.findRegistry(ParticleEffect.class).getValue(message.res);
            if (effect == null || spawner == null) {
                return;
            }
            Object details = effect.createDetails();
            if (message.nbt != null) {
                ((ParticleEffect.Details)details).load(message.nbt);
            }
            if (effect.canParticlesSpawn(player.field_70170_p)) {
                effect.spawn(spawner, spawner.field_70170_p, message.posX, message.posY, message.posZ, details);
            }
        }
    }
}

